#include "parms.h"
#include "structs.h"

#ifdef	RCSIDENT
static char rcsid[] = "$Header: /home/ace/master/rmtc/misc/notes/src/gtime.c,v 1.8 1989/05/15 11:13:27 polk Exp $";
#endif	RCSIDENT

/*
 * gettime(whenvec) struct when_f *whenvec; {}
 *
 *    fills in whenvec with the most uptodate time
 *
 *	Rob Kolstad Winter 1980
 *	Modified to split getting and formatting time
 *			Malcolm Slaney	March 1983
 */

/*
 *	4.2 Bsd moved the file!
 */
#ifndef	BSD42
#include 	<time.h>
#else
#include	<sys/time.h>
#endif	!BSD42

int     use_forcetime = 0;
struct when_f   forcetime;

gettime (whenvec) struct when_f *whenvec;
{
    long    tvec;

    if (use_forcetime)
    {
	*whenvec = forcetime;
	return 0;
    }
    time (&tvec);
    return (maketime (whenvec, tvec));
}

maketime (whenvec, tvec)
struct when_f  *whenvec;
long    tvec;
{
    struct tm  *ovec;
    struct tm  *localtime ();
    ovec = localtime (&tvec);			  /* convert to local time */
    whenvec -> w_mins = ovec -> tm_min;
    whenvec -> w_hours = ovec -> tm_hour;
    whenvec -> w_day = ovec -> tm_mday;
    whenvec -> w_month = ovec -> tm_mon + 1;	  /* jan= 0 as supplied, correct it */
    whenvec -> w_year = ovec -> tm_year + 1900;	  /* all from CTIME (III) */
    whenvec -> w_gmttime = tvec;

    return 0;
}
