#define	MAINLINE

/*
 *	rbefix
 *
 *	This simple program runs through the specified notesfiles
 *	and sets some fields in the descriptor to default
 *	values.  You'll have to pick which fields you actually
 *	want to change, this will depend on how recent your code is.
 *
 *
 *	Ray Essick	September 6, 1983
 *
 * $Header: /home/ace/master/rmtc/misc/notes/utility/rbefix-whattime.c,v 1.1 1989/05/15 11:05:33 polk Exp $
 */

#include "../src/parms.h"
#include "../src/structs.h"

main (argc, argv)
char  **argv;
{
    int     i,
            j,
            k;
    int     c;
    int     start;
    int     verbose = 0;
    char   *p,
           *q,
           *r;
    char    cmdline[CMDLEN];
    struct io_f io;
    struct note_f   note;

    startup (argc, argv);				/* common initialization */

    start = 1;
    if (strcmp (argv[1], "-v") == 0)
    {
	start++;
	verbose++;
    }

    for (i = start; i < argc; i++)			/* for each notesfile  */
    {
	if (init (&io, argv[i]) < 0)
	{
	    printf ("bong %s\n", argv[i]);
	    continue;
	}
	if (verbose)
	    printf ("%s\n", argv[i]);

	getdscr (&io, &io.descr);			/* grab up to date */

	printf ("%-20s Anon %3s Age %5d\n",
		argv[i],
		io.descr.d_stat & ANONOK ? "yes" : "no",
		io.descr.d_archtime);
	closenf (&io);

    }
    exit (GOOD);
}
