#define	MAINLINE

/*
 *	fieldchange
 *
 *	This simple program runs through the specified notesfiles
 *	and sets some fields in the descriptor to default
 *	values.  You'll have to pick which fields you actually
 *	want to change, this will depend on how recent your code is.
 *
 *
 *	Ray Essick	September 6, 1983
 *
 * $Header: /home/ace/master/rmtc/misc/notes/utility/rbefix.c,v 1.1 1989/05/15 11:05:34 polk Exp $
 */

#include "../src/parms.h"
#include "../src/structs.h"

main (argc, argv)
char  **argv;
{
    int     i,
            j,
            k;
    int     c;
    int     start;
    int     verbose = 0;
    char   *p,
           *q,
           *r;
    char    cmdline[CMDLEN];
    struct io_f io;
    struct note_f   note;

    startup (argc, argv);				/* common initialization */

    start = 1;
    if (strcmp (argv[1], "-v") == 0)
    {
	start++;
	verbose++;
    }

    for (i = start; i < argc; i++)			/* for each notesfile  */
    {
	if (init (&io, argv[i]) < 0)
	{
	    printf ("bong %s\n", argv[i]);
	    continue;
	}
	if (verbose)
	    printf ("%s\n", argv[i]);

	locknf (&io, 'n');
	getdscr (&io, &io.descr);			/* grab up to date */

	/*
	 * screw with the global descriptor
	 */
	io.descr.d_stat |= OPEN;
	putdscr (&io, &io.descr);			/* grab up to date */

#ifdef	notdef
	/*
	 * screw with the descriptor for each note.
	 */
	for (j = 1; j <= io.descr.d_nnote; j++)
	{
	    getnrec (&io, j, &note);
	    if (note.n_stat & ORPHND)
	    {
		printf("Foster Note %d: addr = %ld, textlen from %ld to zero\n",
			j,note.n_addr.addr, note.n_addr.textlen);
		note.n_addr.textlen = 0;
		putnrec (&io, j, &note);
		continue;
	    }
	    if (note.n_addr.addr == 0)
	    {
	printf("Note %d: Change zero-addr textlen from %ld to zero\n",
		j, note.n_addr.textlen);
		note.n_addr.textlen = 0;
		putnrec (&io, j, &note);
	    }
	}
#endif	notdef
	unlocknf (&io, 'n');
	finish (&io);

    }
    exit (GOOD);
}
