/* slots.c
 * Slots.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#include "gtypes.h"
#include "slots.h"
#include "registers.h"
#include "md.h"

static slots basicslots[MAXRETURNS+MAXSLOT];
slots* returninfo = &basicslots[0];
slots* slotinfo = &basicslots[MAXRETURNS];

slots* localinfo;
slots* stackinfo;
slots* tempinfo;

extern int maxLocal;


/*
 * Initiate slots.
 */
void
initSlots(void)
{
	int i;

        /* Free all slots */
        for (i = 0; i < MAXSLOT; i++) {
		slotinfo[i].insn = 0;
		slotinfo[i].regno = NOREG;
		slotinfo[i].modified = 0;
        }

        /* Mark returns as busy */
        for (i = 0; i < MAXRETURNS; i++) {
                returninfo[i].insn = 0;
                returninfo[i].regno = NOREG;
		returninfo[i].modified = 0;
        }
        returninfo[returnInt].regno = RETURN_INT;
        returninfo[returnRef].regno = RETURN_REF;
        returninfo[returnLong].regno = RETURN_LONG_LOW;
        returninfo[returnLong+1].regno = RETURN_LONG_HIGH;
        returninfo[returnFloat].regno = RETURN_FLOAT;
        returninfo[returnDouble].regno = RETURN_DOUBLE_LOW;
        returninfo[returnDouble+1].regno = RETURN_DOUBLE_HIGH;
}

/*
 * Mark return in use so they don't get optimised away.
 */
void
markReturns(void)
{
        returninfo[returnInt].insn = 0;
        returninfo[returnRef].insn = 0;
        returninfo[returnLong].insn = 0;
        returninfo[returnLong+1].insn = 0;
        returninfo[returnFloat].insn = 0;
        returninfo[returnDouble].insn = 0;
        returninfo[returnDouble+1].insn = 0;
}
