/*
 * external_wrappers.h
 * Wrap up the calls between Kaffe and native method calls for systems
 *  which don't support shared libraries.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Attila Molnar <gusthy@hu.bonus.com>, 1996.
 * Modified by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __external_wrappers_h
#define __external_wrappers_h

#if defined(TRANSLATOR)
#define	KAFFEFUNC(_f_)	_f_
#elif defined(INTERPRETER)
#define	KAFFEFUNC(_f_)	Kaffe_##_f_##_stub
#endif

extern KAFFEFUNC(java_net_DatagramSocket_datagramSocketCreate)();
extern KAFFEFUNC(java_net_DatagramSocket_datagramSocketBind)();
extern KAFFEFUNC(java_net_DatagramSocket_datagramSocketSend)();
extern KAFFEFUNC(java_net_DatagramSocket_datagramSocketPeek)();
extern KAFFEFUNC(java_net_DatagramSocket_datagramSocketReceive)();
extern KAFFEFUNC(java_net_DatagramSocket_datagramSocketClose)();
extern KAFFEFUNC(java_net_InetAddress_getLocalHostName)();
extern KAFFEFUNC(java_net_InetAddress_makeAnyLocalAddress)();
extern KAFFEFUNC(java_net_InetAddress_lookupHostAddr)();
extern KAFFEFUNC(java_net_InetAddress_lookupAllHostAddr)();
extern KAFFEFUNC(java_net_InetAddress_getHostByAddr)();
extern KAFFEFUNC(java_net_InetAddress_getInetFamily)();
extern KAFFEFUNC(java_net_PlainSocketImpl_socketCreate)();
extern KAFFEFUNC(java_net_PlainSocketImpl_socketConnect)();
extern KAFFEFUNC(java_net_PlainSocketImpl_socketBind)();
extern KAFFEFUNC(java_net_PlainSocketImpl_socketListen)();
extern KAFFEFUNC(java_net_PlainSocketImpl_socketAccept)();
extern KAFFEFUNC(java_net_PlainSocketImpl_socketAvailable)();
extern KAFFEFUNC(java_net_PlainSocketImpl_socketClose)();
extern KAFFEFUNC(java_net_SocketInputStream_socketRead)();
extern KAFFEFUNC(java_net_SocketOutputStream_socketWrite)();
extern KAFFEFUNC(java_util_Date_toString)();
extern KAFFEFUNC(java_util_Date_toLocaleString)();
extern KAFFEFUNC(java_util_Date_toGMTString)();
extern KAFFEFUNC(java_util_Date_expand)();
extern KAFFEFUNC(java_util_Date_computeValue)();
extern KAFFEFUNC(java_lang_ClassLoader_init)();
extern KAFFEFUNC(java_lang_ClassLoader_defineClass0)();
extern KAFFEFUNC(java_lang_ClassLoader_resolveClass0)();
extern KAFFEFUNC(java_lang_ClassLoader_findSystemClass0)();
extern KAFFEFUNC(java_lang_Class_forName)();
extern KAFFEFUNC(java_lang_Class_newInstance)();
extern KAFFEFUNC(java_lang_Class_getName)();
extern KAFFEFUNC(java_lang_Class_getSuperclass)();
extern KAFFEFUNC(java_lang_Class_getInterfaces)();
extern KAFFEFUNC(java_lang_Class_getClassLoader)();
extern KAFFEFUNC(java_lang_Class_isInterface)();
extern KAFFEFUNC(java_lang_Compiler_initialize)();
extern KAFFEFUNC(java_lang_Compiler_compileClass)();
extern KAFFEFUNC(java_lang_Compiler_compileClasses)();
extern KAFFEFUNC(java_lang_Compiler_command)();
extern KAFFEFUNC(java_lang_Compiler_enable)();
extern KAFFEFUNC(java_lang_Compiler_disable)();
extern KAFFEFUNC(java_lang_Double_toString)();
extern KAFFEFUNC(java_lang_Double_valueOf)();
extern KAFFEFUNC(java_lang_Double_doubleToLongBits)();
extern KAFFEFUNC(java_lang_Double_longBitsToDouble)();
extern KAFFEFUNC(java_lang_Float_toString)();
extern KAFFEFUNC(java_lang_Float_valueOf)();
extern KAFFEFUNC(java_lang_Float_floatToIntBits)();
extern KAFFEFUNC(java_lang_Float_intBitsToFloat)();
extern KAFFEFUNC(java_lang_Math_sin)();
extern KAFFEFUNC(java_lang_Math_cos)();
extern KAFFEFUNC(java_lang_Math_tan)();
extern KAFFEFUNC(java_lang_Math_asin)();
extern KAFFEFUNC(java_lang_Math_acos)();
extern KAFFEFUNC(java_lang_Math_atan)();
extern KAFFEFUNC(java_lang_Math_exp)();
extern KAFFEFUNC(java_lang_Math_log)();
extern KAFFEFUNC(java_lang_Math_sqrt)();
extern KAFFEFUNC(java_lang_Math_IEEEremainder)();
extern KAFFEFUNC(java_lang_Math_ceil)();
extern KAFFEFUNC(java_lang_Math_floor)();
extern KAFFEFUNC(java_lang_Math_rint)();
extern KAFFEFUNC(java_lang_Math_atan2)();
extern KAFFEFUNC(java_lang_Math_pow)();
extern KAFFEFUNC(java_lang_Object_getClass)();
extern KAFFEFUNC(java_lang_Object_hashCode)();
extern KAFFEFUNC(java_lang_Object_clone)();
extern KAFFEFUNC(java_lang_Object_notify)();
extern KAFFEFUNC(java_lang_Object_notifyAll)();
extern KAFFEFUNC(java_lang_Object_wait)();
extern KAFFEFUNC(java_lang_ProcessReaper_waitForDeath)();
extern KAFFEFUNC(java_lang_Runtime_exitInternal)();
extern KAFFEFUNC(java_lang_Runtime_execInternal)();
extern KAFFEFUNC(java_lang_Runtime_freeMemory)();
extern KAFFEFUNC(java_lang_Runtime_totalMemory)();
extern KAFFEFUNC(java_lang_Runtime_gc)();
extern KAFFEFUNC(java_lang_Runtime_runFinalization)();
extern KAFFEFUNC(java_lang_Runtime_traceInstructions)();
extern KAFFEFUNC(java_lang_Runtime_traceMethodCalls)();
extern KAFFEFUNC(java_lang_Runtime_initializeLinkerInternal)();
extern KAFFEFUNC(java_lang_Runtime_buildLibName)();
extern KAFFEFUNC(java_lang_Runtime_loadFileInternal)();
extern KAFFEFUNC(java_lang_SecurityManager_getClassContext)();
extern KAFFEFUNC(java_lang_SecurityManager_currentClassLoader)();
extern KAFFEFUNC(java_lang_SecurityManager_classDepth)();
extern KAFFEFUNC(java_lang_SecurityManager_classLoaderDepth)();
extern KAFFEFUNC(java_lang_System_currentTimeMillis)();
extern KAFFEFUNC(java_lang_System_arraycopy)();
extern KAFFEFUNC(java_lang_System_initProperties)();
extern KAFFEFUNC(java_lang_Thread_currentThread)();
extern KAFFEFUNC(java_lang_Thread_yield)();
extern KAFFEFUNC(java_lang_Thread_sleep)();
extern KAFFEFUNC(java_lang_Thread_start)();
extern KAFFEFUNC(java_lang_Thread_isAlive)();
extern KAFFEFUNC(java_lang_Thread_countStackFrames)();
extern KAFFEFUNC(java_lang_Thread_setPriority0)();
extern KAFFEFUNC(java_lang_Thread_stop0)();
extern KAFFEFUNC(java_lang_Thread_suspend0)();
extern KAFFEFUNC(java_lang_Thread_resume0)();
extern KAFFEFUNC(java_lang_Throwable_printStackTrace0)();
extern KAFFEFUNC(java_lang_Throwable_fillInStackTrace)();
extern KAFFEFUNC(java_lang_UNIXProcess_exec)();
extern KAFFEFUNC(java_lang_UNIXProcess_fork)();
extern KAFFEFUNC(java_lang_UNIXProcess_waitForUNIXProcess)();
extern KAFFEFUNC(java_lang_UNIXProcess_destroy)();
extern KAFFEFUNC(java_io_FileDescriptor_valid)();
extern KAFFEFUNC(java_io_FileDescriptor_initSystemFD)();
extern KAFFEFUNC(java_io_FileInputStream_open)();
extern KAFFEFUNC(java_io_FileInputStream_read)();
extern KAFFEFUNC(java_io_FileInputStream_readBytes)();
extern KAFFEFUNC(java_io_FileInputStream_skip)();
extern KAFFEFUNC(java_io_FileInputStream_available)();
extern KAFFEFUNC(java_io_FileInputStream_close)();
extern KAFFEFUNC(java_io_FileOutputStream_open)();
extern KAFFEFUNC(java_io_FileOutputStream_write)();
extern KAFFEFUNC(java_io_FileOutputStream_writeBytes)();
extern KAFFEFUNC(java_io_FileOutputStream_close)();
extern KAFFEFUNC(java_io_File_exists0)();
extern KAFFEFUNC(java_io_File_canWrite0)();
extern KAFFEFUNC(java_io_File_canRead0)();
extern KAFFEFUNC(java_io_File_isFile0)();
extern KAFFEFUNC(java_io_File_isDirectory0)();
extern KAFFEFUNC(java_io_File_lastModified0)();
extern KAFFEFUNC(java_io_File_length0)();
extern KAFFEFUNC(java_io_File_mkdir0)();
extern KAFFEFUNC(java_io_File_renameTo0)();
extern KAFFEFUNC(java_io_File_delete0)();
extern KAFFEFUNC(java_io_File_list0)();
extern KAFFEFUNC(java_io_File_isAbsolute)();
extern KAFFEFUNC(java_io_RandomAccessFile_open)();
extern KAFFEFUNC(java_io_RandomAccessFile_read)();
extern KAFFEFUNC(java_io_RandomAccessFile_readBytes)();
extern KAFFEFUNC(java_io_RandomAccessFile_write)();
extern KAFFEFUNC(java_io_RandomAccessFile_writeBytes)();
extern KAFFEFUNC(java_io_RandomAccessFile_getFilePointer)();
extern KAFFEFUNC(java_io_RandomAccessFile_seek)();
extern KAFFEFUNC(java_io_RandomAccessFile_length)();
extern KAFFEFUNC(java_io_RandomAccessFile_close)();

/*
 * Name each method.
 */
char *native_name[] = {

	"java_net_DatagramSocket_datagramSocketCreate",
	"java_net_DatagramSocket_datagramSocketBind",
	"java_net_DatagramSocket_datagramSocketSend",
	"java_net_DatagramSocket_datagramSocketPeek",
	"java_net_DatagramSocket_datagramSocketReceive",
	"java_net_DatagramSocket_datagramSocketClose",
	"java_net_InetAddress_getLocalHostName",
	"java_net_InetAddress_makeAnyLocalAddress",
	"java_net_InetAddress_lookupHostAddr",
	"java_net_InetAddress_lookupAllHostAddr",
	"java_net_InetAddress_getHostByAddr",
	"java_net_InetAddress_getInetFamily",
	"java_net_PlainSocketImpl_socketCreate",
	"java_net_PlainSocketImpl_socketConnect",
	"java_net_PlainSocketImpl_socketBind",
	"java_net_PlainSocketImpl_socketListen",
	"java_net_PlainSocketImpl_socketAccept",
	"java_net_PlainSocketImpl_socketAvailable",
	"java_net_PlainSocketImpl_socketClose",
	"java_net_SocketInputStream_socketRead",
	"java_net_SocketOutputStream_socketWrite",
	"java_util_Date_toString",
	"java_util_Date_toLocaleString",
	"java_util_Date_toGMTString",
	"java_util_Date_expand",
	"java_util_Date_computeValue",
	"java_lang_ClassLoader_init",
	"java_lang_ClassLoader_defineClass0",
	"java_lang_ClassLoader_resolveClass0",
	"java_lang_ClassLoader_findSystemClass0",
	"java_lang_Class_forName",
	"java_lang_Class_newInstance",
	"java_lang_Class_getName",
	"java_lang_Class_getSuperclass",
	"java_lang_Class_getInterfaces",
	"java_lang_Class_getClassLoader",
	"java_lang_Class_isInterface",
	"java_lang_Compiler_initialize",
	"java_lang_Compiler_compileClass",
	"java_lang_Compiler_compileClasses",
	"java_lang_Compiler_command",
	"java_lang_Compiler_enable",
	"java_lang_Compiler_disable",
	"java_lang_Double_toString",
	"java_lang_Double_valueOf",
	"java_lang_Double_doubleToLongBits",
	"java_lang_Double_longBitsToDouble",
	"java_lang_Float_toString",
	"java_lang_Float_valueOf",
	"java_lang_Float_floatToIntBits",
	"java_lang_Float_intBitsToFloat",
	"java_lang_Math_sin",
	"java_lang_Math_cos",
	"java_lang_Math_tan",
	"java_lang_Math_asin",
	"java_lang_Math_acos",
	"java_lang_Math_atan",
	"java_lang_Math_exp",
	"java_lang_Math_log",
	"java_lang_Math_sqrt",
	"java_lang_Math_IEEEremainder",
	"java_lang_Math_ceil",
	"java_lang_Math_floor",
	"java_lang_Math_rint",
	"java_lang_Math_atan2",
	"java_lang_Math_pow",
	"java_lang_Object_getClass",
	"java_lang_Object_hashCode",
	"java_lang_Object_clone",
	"java_lang_Object_notify",
	"java_lang_Object_notifyAll",
	"java_lang_Object_wait",
	"java_lang_ProcessReaper_waitForDeath",
	"java_lang_Runtime_exitInternal",
	"java_lang_Runtime_execInternal",
	"java_lang_Runtime_freeMemory",
	"java_lang_Runtime_totalMemory",
	"java_lang_Runtime_gc",
	"java_lang_Runtime_runFinalization",
	"java_lang_Runtime_traceInstructions",
	"java_lang_Runtime_traceMethodCalls",
	"java_lang_Runtime_initializeLinkerInternal",
	"java_lang_Runtime_buildLibName",
	"java_lang_Runtime_loadFileInternal",
	"java_lang_SecurityManager_getClassContext",
	"java_lang_SecurityManager_currentClassLoader",
	"java_lang_SecurityManager_classDepth",
	"java_lang_SecurityManager_classLoaderDepth",
	"java_lang_System_currentTimeMillis",
	"java_lang_System_arraycopy",
	"java_lang_System_initProperties",
	"java_lang_Thread_currentThread",
	"java_lang_Thread_yield",
	"java_lang_Thread_sleep",
	"java_lang_Thread_start",
	"java_lang_Thread_isAlive",
	"java_lang_Thread_countStackFrames",
	"java_lang_Thread_setPriority0",
	"java_lang_Thread_stop0",
	"java_lang_Thread_suspend0",
	"java_lang_Thread_resume0",
	"java_lang_Throwable_printStackTrace0",
	"java_lang_Throwable_fillInStackTrace",
	"java_lang_UNIXProcess_exec",
	"java_lang_UNIXProcess_fork",
	"java_lang_UNIXProcess_waitForUNIXProcess",
	"java_lang_UNIXProcess_destroy",
	"java_io_FileDescriptor_valid",
	"java_io_FileDescriptor_initSystemFD",
	"java_io_FileInputStream_open",
	"java_io_FileInputStream_read",
	"java_io_FileInputStream_readBytes",
	"java_io_FileInputStream_skip",
	"java_io_FileInputStream_available",
	"java_io_FileInputStream_close",
	"java_io_FileOutputStream_open",
	"java_io_FileOutputStream_write",
	"java_io_FileOutputStream_writeBytes",
	"java_io_FileOutputStream_close",
	"java_io_File_exists0",
	"java_io_File_canWrite0",
	"java_io_File_canRead0",
	"java_io_File_isFile0",
	"java_io_File_isDirectory0",
	"java_io_File_lastModified0",
	"java_io_File_length0",
	"java_io_File_mkdir0",
	"java_io_File_renameTo0",
	"java_io_File_delete0",
	"java_io_File_list0",
	"java_io_File_isAbsolute",
	"java_io_RandomAccessFile_open",
	"java_io_RandomAccessFile_read",
	"java_io_RandomAccessFile_readBytes",
	"java_io_RandomAccessFile_write",
	"java_io_RandomAccessFile_writeBytes",
	"java_io_RandomAccessFile_getFilePointer",
	"java_io_RandomAccessFile_seek",
	"java_io_RandomAccessFile_length",
	"java_io_RandomAccessFile_close",

	0
};

/*
 * Define the corresponding functions.
 */
void *native_func[] = {

	KAFFEFUNC(java_net_DatagramSocket_datagramSocketCreate),
	KAFFEFUNC(java_net_DatagramSocket_datagramSocketBind),
	KAFFEFUNC(java_net_DatagramSocket_datagramSocketSend),
	KAFFEFUNC(java_net_DatagramSocket_datagramSocketPeek),
	KAFFEFUNC(java_net_DatagramSocket_datagramSocketReceive),
	KAFFEFUNC(java_net_DatagramSocket_datagramSocketClose),
	KAFFEFUNC(java_net_InetAddress_getLocalHostName),
	KAFFEFUNC(java_net_InetAddress_makeAnyLocalAddress),
	KAFFEFUNC(java_net_InetAddress_lookupHostAddr),
	KAFFEFUNC(java_net_InetAddress_lookupAllHostAddr),
	KAFFEFUNC(java_net_InetAddress_getHostByAddr),
	KAFFEFUNC(java_net_InetAddress_getInetFamily),
	KAFFEFUNC(java_net_PlainSocketImpl_socketCreate),
	KAFFEFUNC(java_net_PlainSocketImpl_socketConnect),
	KAFFEFUNC(java_net_PlainSocketImpl_socketBind),
	KAFFEFUNC(java_net_PlainSocketImpl_socketListen),
	KAFFEFUNC(java_net_PlainSocketImpl_socketAccept),
	KAFFEFUNC(java_net_PlainSocketImpl_socketAvailable),
	KAFFEFUNC(java_net_PlainSocketImpl_socketClose),
	KAFFEFUNC(java_net_SocketInputStream_socketRead),
	KAFFEFUNC(java_net_SocketOutputStream_socketWrite),
	KAFFEFUNC(java_util_Date_toString),
	KAFFEFUNC(java_util_Date_toLocaleString),
	KAFFEFUNC(java_util_Date_toGMTString),
	KAFFEFUNC(java_util_Date_expand),
	KAFFEFUNC(java_util_Date_computeValue),
	KAFFEFUNC(java_lang_ClassLoader_init),
	KAFFEFUNC(java_lang_ClassLoader_defineClass0),
	KAFFEFUNC(java_lang_ClassLoader_resolveClass0),
	KAFFEFUNC(java_lang_ClassLoader_findSystemClass0),
	KAFFEFUNC(java_lang_Class_forName),
	KAFFEFUNC(java_lang_Class_newInstance),
	KAFFEFUNC(java_lang_Class_getName),
	KAFFEFUNC(java_lang_Class_getSuperclass),
	KAFFEFUNC(java_lang_Class_getInterfaces),
	KAFFEFUNC(java_lang_Class_getClassLoader),
	KAFFEFUNC(java_lang_Class_isInterface),
	KAFFEFUNC(java_lang_Compiler_initialize),
	KAFFEFUNC(java_lang_Compiler_compileClass),
	KAFFEFUNC(java_lang_Compiler_compileClasses),
	KAFFEFUNC(java_lang_Compiler_command),
	KAFFEFUNC(java_lang_Compiler_enable),
	KAFFEFUNC(java_lang_Compiler_disable),
	KAFFEFUNC(java_lang_Double_toString),
	KAFFEFUNC(java_lang_Double_valueOf),
	KAFFEFUNC(java_lang_Double_doubleToLongBits),
	KAFFEFUNC(java_lang_Double_longBitsToDouble),
	KAFFEFUNC(java_lang_Float_toString),
	KAFFEFUNC(java_lang_Float_valueOf),
	KAFFEFUNC(java_lang_Float_floatToIntBits),
	KAFFEFUNC(java_lang_Float_intBitsToFloat),
	KAFFEFUNC(java_lang_Math_sin),
	KAFFEFUNC(java_lang_Math_cos),
	KAFFEFUNC(java_lang_Math_tan),
	KAFFEFUNC(java_lang_Math_asin),
	KAFFEFUNC(java_lang_Math_acos),
	KAFFEFUNC(java_lang_Math_atan),
	KAFFEFUNC(java_lang_Math_exp),
	KAFFEFUNC(java_lang_Math_log),
	KAFFEFUNC(java_lang_Math_sqrt),
	KAFFEFUNC(java_lang_Math_IEEEremainder),
	KAFFEFUNC(java_lang_Math_ceil),
	KAFFEFUNC(java_lang_Math_floor),
	KAFFEFUNC(java_lang_Math_rint),
	KAFFEFUNC(java_lang_Math_atan2),
	KAFFEFUNC(java_lang_Math_pow),
	KAFFEFUNC(java_lang_Object_getClass),
	KAFFEFUNC(java_lang_Object_hashCode),
	KAFFEFUNC(java_lang_Object_clone),
	KAFFEFUNC(java_lang_Object_notify),
	KAFFEFUNC(java_lang_Object_notifyAll),
	KAFFEFUNC(java_lang_Object_wait),
	KAFFEFUNC(java_lang_ProcessReaper_waitForDeath),
	KAFFEFUNC(java_lang_Runtime_exitInternal),
	KAFFEFUNC(java_lang_Runtime_execInternal),
	KAFFEFUNC(java_lang_Runtime_freeMemory),
	KAFFEFUNC(java_lang_Runtime_totalMemory),
	KAFFEFUNC(java_lang_Runtime_gc),
	KAFFEFUNC(java_lang_Runtime_runFinalization),
	KAFFEFUNC(java_lang_Runtime_traceInstructions),
	KAFFEFUNC(java_lang_Runtime_traceMethodCalls),
	KAFFEFUNC(java_lang_Runtime_initializeLinkerInternal),
	KAFFEFUNC(java_lang_Runtime_buildLibName),
	KAFFEFUNC(java_lang_Runtime_loadFileInternal),
	KAFFEFUNC(java_lang_SecurityManager_getClassContext),
	KAFFEFUNC(java_lang_SecurityManager_currentClassLoader),
	KAFFEFUNC(java_lang_SecurityManager_classDepth),
	KAFFEFUNC(java_lang_SecurityManager_classLoaderDepth),
	KAFFEFUNC(java_lang_System_currentTimeMillis),
	KAFFEFUNC(java_lang_System_arraycopy),
	KAFFEFUNC(java_lang_System_initProperties),
	KAFFEFUNC(java_lang_Thread_currentThread),
	KAFFEFUNC(java_lang_Thread_yield),
	KAFFEFUNC(java_lang_Thread_sleep),
	KAFFEFUNC(java_lang_Thread_start),
	KAFFEFUNC(java_lang_Thread_isAlive),
	KAFFEFUNC(java_lang_Thread_countStackFrames),
	KAFFEFUNC(java_lang_Thread_setPriority0),
	KAFFEFUNC(java_lang_Thread_stop0),
	KAFFEFUNC(java_lang_Thread_suspend0),
	KAFFEFUNC(java_lang_Thread_resume0),
	KAFFEFUNC(java_lang_Throwable_printStackTrace0),
	KAFFEFUNC(java_lang_Throwable_fillInStackTrace),
	KAFFEFUNC(java_lang_UNIXProcess_exec),
	KAFFEFUNC(java_lang_UNIXProcess_fork),
	KAFFEFUNC(java_lang_UNIXProcess_waitForUNIXProcess),
	KAFFEFUNC(java_lang_UNIXProcess_destroy),
	KAFFEFUNC(java_io_FileDescriptor_valid),
	KAFFEFUNC(java_io_FileDescriptor_initSystemFD),
	KAFFEFUNC(java_io_FileInputStream_open),
	KAFFEFUNC(java_io_FileInputStream_read),
	KAFFEFUNC(java_io_FileInputStream_readBytes),
	KAFFEFUNC(java_io_FileInputStream_skip),
	KAFFEFUNC(java_io_FileInputStream_available),
	KAFFEFUNC(java_io_FileInputStream_close),
	KAFFEFUNC(java_io_FileOutputStream_open),
	KAFFEFUNC(java_io_FileOutputStream_write),
	KAFFEFUNC(java_io_FileOutputStream_writeBytes),
	KAFFEFUNC(java_io_FileOutputStream_close),
	KAFFEFUNC(java_io_File_exists0),
	KAFFEFUNC(java_io_File_canWrite0),
	KAFFEFUNC(java_io_File_canRead0),
	KAFFEFUNC(java_io_File_isFile0),
	KAFFEFUNC(java_io_File_isDirectory0),
	KAFFEFUNC(java_io_File_lastModified0),
	KAFFEFUNC(java_io_File_length0),
	KAFFEFUNC(java_io_File_mkdir0),
	KAFFEFUNC(java_io_File_renameTo0),
	KAFFEFUNC(java_io_File_delete0),
	KAFFEFUNC(java_io_File_list0),
	KAFFEFUNC(java_io_File_isAbsolute),
	KAFFEFUNC(java_io_RandomAccessFile_open),
	KAFFEFUNC(java_io_RandomAccessFile_read),
	KAFFEFUNC(java_io_RandomAccessFile_readBytes),
	KAFFEFUNC(java_io_RandomAccessFile_write),
	KAFFEFUNC(java_io_RandomAccessFile_writeBytes),
	KAFFEFUNC(java_io_RandomAccessFile_getFilePointer),
	KAFFEFUNC(java_io_RandomAccessFile_seek),
	KAFFEFUNC(java_io_RandomAccessFile_length),
	KAFFEFUNC(java_io_RandomAccessFile_close),

	0
};

#endif
