/*
 * java.io.FileDescriptor.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include <stdio.h>
#include <assert.h>
#include "java.io.stubs/FileDescriptor.h"
#include "kthread.h"

/*
 * Initialise a file descriptor to the given file nr.
 */
struct Hjava_io_FileDescriptor*
java_io_FileDescriptor_initSystemFD(struct Hjava_io_FileDescriptor* none, struct Hjava_io_FileDescriptor* this, jint i)
{
	unhand(this)->fd = threadedFileDescriptor(i);
	return (this);
}

/*
 * Is this file descriptor valid ?
 */
jint /* bool */
java_io_FileDescriptor_valid(struct Hjava_io_FileDescriptor* this)
{
	if (unhand(this)->fd >= 0) {
		return (1);
	}
	else {
		return (0);
	}
}
