/*
 * java.lang.Double.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include "config.h"
#include <stdlib.h>
#include <native.h>
#include "defs.h"
#include "java.lang.stubs/Double.h"

/*
 * Convert double to string.
 */
struct Hjava_lang_String*
java_lang_Double_toString(struct Hjava_lang_Double* none, double val)
{
	char str[MAXNUMLEN];

	sprintf(str, "%g", val);
	return (makeJavaString(str, strlen(str)));
}

/*
 * Convert string to double object.
 */
struct Hjava_lang_Double*
java_lang_Double_valueOf(struct Hjava_lang_Double* none, struct Hjava_lang_String* str)
{
	struct Hjava_lang_Double* obj;
	char buf[MAXNUMLEN];
	char* endbuf;

	javaString2CString(str, buf, sizeof(buf));

	obj = (struct Hjava_lang_Double*)execute_java_constructor(0, "java.lang.Double", 0, "()V");
#if defined(HAVE_STRTOD)
	unhand(obj)->value = strtod(buf, &endbuf);
	if (*endbuf != 0) {
		SignalError(0, "java.lang.NumberFormatException", "Bad double format");
	}
#else
	/* Fall back on old atof - no error checking */
	unhand(obj)->value = atof(buf);
#endif

	return (obj);
}

/*
 * Convert double to jlong.
 */
jlong
java_lang_Double_doubleToLongBits(struct Hjava_lang_Double* none, double val)
{
	return (*(jlong*)&val);
}

/*
 * Convert jlong to double.
 */
double
java_lang_Double_longBitsToDouble(struct Hjava_lang_Double* none, jlong val)
{
	return (*(double*)&val);
}
