/*
 * java.lang.Object.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include <stdio.h>
#include <assert.h>
#include <memory.h>
#define __jtypes_h
#include "../../kaffevm/gtypes.h"
#include "../../kaffevm/locks.h"
#include <native.h>
#include "../../kaffevm/constants.h"
#include "../../kaffevm/access.h"
#include "../../kaffevm/classMethod.h"	/* Don't need java.lang.Object.h */
#include "../../kaffevm/itypes.h"

IMPORT(struct itypes) types[];

/*
 * Generate object hash code.
 */
jint
java_lang_Object_hashCode(struct Hjava_lang_Object* o)
{
	/* Hash code is top 26 bits of object's address - objects are
	 * at least 64 bytes long.
	 */
	return (((jint)o) >> 6);
}

/*
 * Return class object for this object.
 */
struct Hjava_lang_Class*
java_lang_Object_getClass(struct Hjava_lang_Object* o)
{
	return (o->dtable->class);
}

/*
 * Notify threads waiting here.
 */
void
java_lang_Object_notifyAll(struct Hjava_lang_Object* o)
{
	broadcastCond(o);
}

/*
 * Notify a thread waiting here.
 */
void
java_lang_Object_notify(struct Hjava_lang_Object* o)
{
	signalCond(o);
}

/*
 * Clone me.
 */
struct Hjava_lang_Object*
java_lang_Object_clone(struct Hjava_lang_Object* o)
{
	object* obj;
	char* sig;
	int type;

	sig = o->dtable->class->sig;

	if (sig[0] != '[') {
		/* Clone an object */
		obj = AllocObject(o->dtable->class->name);
		memcpy(obj+1, o+1, obj->dtable->class->fsize * 4);
	}
	else if (sig[1] == '[' || sig[1] == 'L') {
		/* Clone an object array */
		obj = AllocObjectArray(o->size, &sig[1]);
		memcpy(obj+1, o+1, o->size * TYPE_SIZE_C('L'));
	}
	else {
		/* Clone an array */
		type = TYPE_TYPE_C(sig[1]);
		obj = AllocArray(o->size, type);
		memcpy(obj+1, o+1, o->size * TYPE_SIZE(type));
	}

	return (obj);
}

/*
 * Wait for this object to be notified.
 */
void
java_lang_Object_wait(struct Hjava_lang_Object* o, jlong timeout)
{
	waitCond(o, timeout);
}
