/*
 * java.lang.System.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#define __jtypes_h
#include "config.h"
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "config-std.h"
#if defined(HAVE_SYS_UTSNAME_H)
#include <sys/utsname.h>
#endif
#if defined(HAVE_PWD_H)
#include <pwd.h>
#endif
#if defined(HAVE_DIRECT_H)
#include <dirent.h>
#endif
#if defined(HAVE_DIR_H)
#include <dir.h>
#endif
#include "../../kaffevm/gtypes.h"
#include <native.h>
#include "system.h"
#include "defs.h"
#include "java.lang.stubs/System.h"
#include "../../kaffevm/itypes.h"
#include "../../kaffevm/constants.h"
#include "../../kaffevm/access.h"
#include "../../kaffevm/classMethod.h"
#include "../../kaffevm/support.h"

static char cwdpath[MAXPATHLEN];

extern jlong currentTime(void);


IMPORT(struct itypes) types[];
IMPORT(userProperty*) userProperties;

/*
 * Copy one part of an array to another.
 */
void
java_lang_System_arraycopy(struct Hjava_lang_System* none, struct Hjava_lang_Object* src, jint srcpos, struct Hjava_lang_Object* dst, jint dstpos, jint len)
{
	char* in;
	char* out;
	int elemsz;
	char* sig;

	sig = dst->dtable->class->sig;

	/* Must be some array type */
	assert(sig[0] == '[');

	/* if sig[1] == 'L' or sig[1] == '[' then I'm copying references.
	 * Am I suppose to do something clever here such as calling
	 * clone() on each element?
	 */

	elemsz = TYPE_SIZE_C(sig[1]);

	len *= elemsz;
	srcpos *= elemsz;
	dstpos *= elemsz;

	in = &((char*)(src+1))[srcpos];
	out = &((char*)(dst+1))[dstpos];

#if defined(HAVE_MEMMOVE)
	memmove((void*)out, (void*)in, len);
#else
	/* Do it ourself */
	if (out < in) {
		/* Copy forwards */
		for (; len > 0; len--) {
			*out++ = *in++;
		}
	}
	else {
		/* Copy backwards */
		out += len;
		in += len;
		for (; len > 0; len--) {
			*--out = *--in;
		}
	}
#endif
}

/*
 * Initialise system properties to their defaults.
 */
struct Hjava_util_Properties*
java_lang_System_initProperties(struct Hjava_lang_System* none, struct Hjava_util_Properties* p)
{
	int r;
	char* jhome;
	char* cpath;
	char* dir;
	userProperty* prop;
#if defined(HAVE_SYS_UTSNAME_H)
	struct utsname system;
#endif
#if defined(HAVE_PWD_H)
	struct passwd* pw;
#endif

	/* Add the default properties:
	 * java.version		Java version number
	 * java.vendor          Java vendor specific string
	 * java.vendor.url      Java vendor URL
	 * java.home            Java installation directory
	 * java.class.version   Java class version number
	 * java.class.path      Java classpath
	 * os.name              Operating System Name
	 * os.arch              Operating System Architecture
	 * os.version           Operating System Version
	 * file.separator       File separator ("/" on Unix)
	 * path.separator       Path separator (":" on Unix)
	 * line.separator       Line separator ("\n" on Unix)
	 * user.name            User account name
	 * user.home            User home directory
	 * user.dir             User's current working directory
	 */

	setProperty(p, "java.version", kaffe_version);
	setProperty(p, "java.vendor", kaffe_vendor);
	setProperty(p, "java.vendor.url", kaffe_vendor_url);

	jhome = getenv(KAFFEHOME);
	if (jhome == 0) {
		jhome = ".";
	}
	setProperty(p, "java.home", jhome);

	setProperty(p, "java.class.version", kaffe_class_version);

	cpath = getenv(KAFFECLASSPATH);
	if (cpath == 0) {
#if defined(DEFAULT_CLASSPATH)
		cpath = DEFAULT_CLASSPATH;
#else
		cpath = ".";
#endif
	}
	setProperty(p, "java.class.path", cpath);

	setProperty(p, "file.separator", file_seperator);
	setProperty(p, "path.separator", path_seperator);
	setProperty(p, "line.separator", line_seperator);

#if defined(HAVE_GETCWD)
	dir = getcwd(cwdpath, MAXPATHLEN);
#elif defined(HAVE_GETWD)
	dir = getwd(cwdpath);
#else
	dir = 0;	/* Cannot get current directory */
#endif
	if (dir == 0) {
		dir = ".";
	}
	setProperty(p, "user.dir", dir);

#if defined(HAVE_SYS_UTSNAME_H) && defined(HAVE_UNAME)
	/* Setup system properties */
	r = uname(&system);
	assert(r >= 0);
	setProperty(p, "os.name", system.sysname);
	setProperty(p, "os.arch", system.machine);
	setProperty(p, "os.version", system.version);
#else
	setProperty(p, "os.name", "Unknown");
	setProperty(p, "os.arch", "Unknown");
	setProperty(p, "os.version", "Unknown");
#endif
#if defined(HAVE_PWD_H) && defined(HAVE_GETUID)
	/* Setup user properties */
	pw = getpwuid(getuid());
	if (pw != 0) {
		setProperty(p, "user.name", pw->pw_name);
		setProperty(p, "user.home", pw->pw_dir);
	}
	else
#endif
	{
		setProperty(p, "user.name", "Unknown");
		setProperty(p, "user.home", "Unknown");
	}

	/* Now process user defined properties */
	for (prop = userProperties; prop != 0; prop = prop->next) {
		setProperty(p, prop->key, prop->value);
	}

	return (p);
}

/*
 * Return current time.
 */
jlong
java_lang_System_currentTimeMillis(struct Hjava_lang_System* none)
{
	return (currentTime());
}
