#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 8; apic id = 08
# fault virtual address   = 0x8
# fault code              = supervisor read data, page not present
# instruction pointer     = 0x20:0xffffffff80b98b73
# stack pointer           = 0x0:0xfffffe06996fc700
# frame pointer           = 0x0:0xfffffe06996fc730
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 46538 (repro11)
# trap number             = 12
# panic: page fault
# cpuid = 8
# time = 1655883715
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe06996fc4c0
# vpanic() at vpanic+0x151/frame 0xfffffe06996fc510
# panic() at panic+0x43/frame 0xfffffe06996fc570
# trap_fatal() at trap_fatal+0x387/frame 0xfffffe06996fc5d0
# trap_pfault() at trap_pfault+0xab/frame 0xfffffe06996fc630
# calltrap() at calltrap+0x8/frame 0xfffffe06996fc630
# --- trap 0xc, rip = 0xffffffff80b98b73, rsp = 0xfffffe06996fc700, rbp = 0xfffffe06996fc730 ---
# knlist_remove_kq() at knlist_remove_kq+0xa3/frame 0xfffffe06996fc730
# kqueue_drain() at kqueue_drain+0x2c8/frame 0xfffffe06996fc770
# kqueue_close() at kqueue_close+0x7e/frame 0xfffffe06996fc7b0
# _fdrop() at _fdrop+0x1b/frame 0xfffffe06996fc7d0
# closef() at closef+0x1db/frame 0xfffffe06996fc860
# fdescfree() at fdescfree+0x433/frame 0xfffffe06996fc930
# exit1() at exit1+0x4ef/frame 0xfffffe06996fc9a0
# sigexit() at sigfce20
# postsig() at postsig+0x1aa/frame 0xfffffe06996fcef0
# ast() at ast+0x4fb/frame 0xfffffe06996fcf30
# doreti_ast() at doreti_ast+0x1f/frame 0x821076840
# KDB: enter: panic
# [ thread pid 46538 tid 356284 ]
# Stopped at      kdb_enter+0x32: movq    $0,0x129f1a3(%rip)
# db> x/s version
# version: FreeBSD 14.0-CURRENT #0 main-n256236-4f1d91e413d7e: Wed Jun 22 07:47:51 CEST 2022
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller59.c <<EOF
// https://syzkaller.appspot.com/bug?id=17dea08cb46e51310db9047c400d1ff4646d2f9a
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+c94f6c97744bd9f9d14d@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_kqueue);
  if (res != -1)
    r[0] = res;
  *(uint64_t*)0x20000140 = 0;
  *(uint16_t*)0x20000148 = 0xfffa;
  *(uint16_t*)0x2000014a = 0x4021;
  *(uint32_t*)0x2000014c = 0;
  *(uint64_t*)0x20000150 = 0;
  *(uint64_t*)0x20000158 = 0;
  *(uint64_t*)0x20000160 = 0;
  *(uint64_t*)0x20000168 = 0;
  *(uint64_t*)0x20000170 = 0;
  *(uint64_t*)0x20000178 = 0;
  syscall(SYS_kevent, r[0], 0x20000140ul, 1ul, 0ul, 0ul, 0ul);
  syscall(SYS_rfork, 0x90030ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller59 -Wall -Wextra -O0 /tmp/syzkaller59.c || exit 1

(cd /tmp; ./syzkaller59) &
start=`date +%s`
while [ $((`date +%s` - start)) -lt 180 ]; do
	sleep 10
	kill -0 $! > /dev/null 2>&1 || break
done
while pkill syzkaller59; do sleep .1; done
wait

rm -rf /tmp/syzkaller59 /tmp/syzkaller59.c /tmp/syzkaller59.core \
    /tmp/syzkaller.??????
exit 0
