/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2008 Isilon Inc http://www.isilon.com/
 * Authors: Doug Rabson <dfr@rabson.org>
 * Developed with Red Inc: Alfred Perlstein <alfred@freebsd.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/usr.sbin/clear_locks/clear_locks.c 330449 2018-03-05 07:26:05Z eadler $");

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <rpc/rpc.h>
#include <rpcsvc/nlm_prot.h>

int
main(int argc, char **argv)
{
	enum clnt_stat stat;
	char *hostname;
	nlm4_notify notify;

	if (argc != 2) {
		fprintf(stderr, "Usage: clear_locks <hostname>\n");
		exit(1);
	}
	hostname = argv[1];

	if (geteuid() != 0) {
		fprintf(stderr, "clear_locks: must be root\n");
		exit(1);
	}

	notify.name = hostname;
	notify.state = 0;
	stat = rpc_call("localhost", NLM_PROG, NLM_VERS4, NLM4_FREE_ALL,
	    (xdrproc_t) xdr_nlm4_notify, (void *) &notify,
	    (xdrproc_t) xdr_void, NULL, NULL);

	if (stat != RPC_SUCCESS) {
		clnt_perrno(stat);
		exit(1);
	}
	fprintf(stderr, "clear_locks: cleared locks for hostname %s\n",
	    hostname);

	return (0);
}
