#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 23; apic id = 2b
# fault virtual address   = 0x0
# fault code              = supervisor read instruction, page not present
# instruction pointer     = 0x20:0x0
# stack pointer           = 0x28:0xfffffe0131d05b78
# frame pointer           = 0x28:0xfffffe0131d05bb0
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 35 (soaiod1)
# trap number             = 12
# panic: page fault
# cpuid = 23
# time = 1622994049
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0131d05820
# vpanic() at vpanic+0x181/frame 0xfffffe0131d05870
# panic() at panic+0x43/frame 0xfffffe0131d058d0
# trap_fatal() at trap_fatal+0x387/frame 0xfffffe0131d05930
# trap_pfault() at trap_pfault+0x97/frame 0xfffffe0131d05990
# trap() at trap+0x294/frame 0xfffffe0131d05aa0
# calltrap() at calltrap+0x8/frame 0xfffffe0131d05aa0
# --- trap 0xc, rip = 0, rsp = 0xfffffe0131d05b78, rbp = 0xfffffe0131d05bb0 ---
# ??() at 0/frame 0xfffffe0131d05bb0
# fork_exit() at fork_exit+0x80/frame 0xfffffe0131d05bf0
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe0131d05bf0
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 35 tid 100272 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x127fb8e(%rip)
# db> x/s version
# version: FreeBSD 14.0-CURRENT #0 main-n247181-1b5bc3a54b6: Sat Jun  5 04:12:19 CEST 2021
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
cat > /tmp/syzkaller41.c <<EOF
// https://syzkaller.appspot.com/bug?id=4996122a5963dbffd94839880a22e4e51575ec42
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+104d8ee3430361cb2795@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <time.h>
#include <unistd.h>

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void loop(void)
{
  int i, call, thread;
  for (call = 0; call < 4; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    *(uint32_t*)0x20000300 = r[0];
    *(uint64_t*)0x20000308 = 0x9a6;
    *(uint64_t*)0x20000310 = 0;
    *(uint64_t*)0x20000318 = 0;
    *(uint32_t*)0x20000320 = 0xffe;
    *(uint32_t*)0x20000324 = 0x100;
    *(uint64_t*)0x20000328 = 0x2b8;
    *(uint32_t*)0x20000330 = 4;
    *(uint32_t*)0x20000334 = 0xfff;
    *(uint64_t*)0x20000338 = 3;
    *(uint64_t*)0x20000340 = 0x80000001;
    *(uint64_t*)0x20000348 = 0;
    *(uint32_t*)0x20000350 = 4;
    *(uint32_t*)0x20000354 = 0xb;
    *(uint64_t*)0x20000358 = 9;
    *(uint64_t*)0x20000360 = 0xa3c5;
    *(uint64_t*)0x20000368 = 0xfffffffffffffff7;
    *(uint64_t*)0x20000370 = 0x8000;
    *(uint64_t*)0x20000378 = 3;
    *(uint64_t*)0x20000380 = 0x498c;
    *(uint64_t*)0x20000388 = 8;
    *(uint64_t*)0x20000390 = 4;
    *(uint64_t*)0x20000398 = 3;
    syscall(SYS_aio_read, 0x20000300ul);
    break;
  case 2:
    *(uint8_t*)0x20000000 = 0x1c;
    *(uint8_t*)0x20000001 = 0x1c;
    *(uint16_t*)0x20000002 = htobe16(0x4e21);
    *(uint32_t*)0x20000004 = 0;
    *(uint8_t*)0x20000008 = 0xfe;
    *(uint8_t*)0x20000009 = 0x80;
    memset((void*)0x2000000a, 0, 12);
    *(uint8_t*)0x20000016 = 0;
    *(uint8_t*)0x20000017 = 0xaa;
    *(uint32_t*)0x20000018 = 1;
    syscall(SYS_connect, r[0], 0x20000000ul, 0x1cul);
    break;
  case 3:
    syscall(SYS_shutdown, r[0], 0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller41 -Wall -Wextra -O0 /tmp/syzkaller41.c -lpthread ||
    exit 1

(cd /tmp; timeout 3m ./syzkaller41)

rm -rf /tmp/syzkaller41 /tmp/syzkaller41.c /tmp/syzkaller.*
exit 0
