/*
** ethers.h           Ethers "map" handling functions
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#ifndef __ETHERS_H__
#define __ETHERS_H__

#include <sys/types.h>

#define _PATH_ETHERS "/etc/ethers"


struct ether_addr
{
    unsigned char ether_addr_octet[6];
};

struct ether
{
    char name[128];
    struct ether_addr addr;
};


#ifndef FINALOUT
#define _setethent setethent
#define _endethent endethent
#define _getethent getethent
#define _getethbyname getethbyname
#define _getethbyaddr getethbyaddr
#endif

/* /etc/ethers file access functions */
extern void _setethent(void);
extern void _endethent(void);
extern struct ether *_getethent(void);
extern struct ether *_getethbyname(char *name);
extern struct ether *_getethbyaddr(struct ether_addr *addr);

/* Client access functions */
extern char *              ether_ntoa(struct ether_addr *addr);
extern struct ether_addr * ether_aton(char *addr);

extern int ether_ntohost(char *hostname, struct ether_addr *addr);
extern int ether_hostton(char *hostname, struct ether_addr *addr);

extern int ether_line(char *line, struct ether_addr *addr, char *hostname);

#endif
