/*
** pwd.h           Passwd "map" handling functions and structures
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#ifndef __PWD_H__
#define __PWD_H__

#include <sys/types.h>

#define _PATH_PASSWD "/etc/passwd"

struct passwd
{
    char *pw_name;
    char *pw_passwd;
    int pw_uid;
    int pw_gid;
    char *pw_gecos;
    char *pw_dir;
    char *pw_shell;
};


extern struct passwd *sgetpwent(const char *str);
extern struct passwd *fgetpwent(FILE *fp);

extern int setpwfile(const char *file);

/* /etc-files access functions */
extern void _setpwent(void);
extern void _endpwent(void);
extern struct passwd *_getpwent(void);
extern struct passwd *_getpwnam(const char *name);
extern struct passwd *_getpwuid(int uid);

/* YP access functions */
extern void yp_setpwent(void);
extern void yp_endpwent(void);
extern struct passwd *yp_getpwent(void);
extern struct passwd *yp_getpwnam(const char *name);
extern struct passwd *yp_getpwuid(int uid);

/* NIS+ access functions */
extern void nis_setpwent(void);
extern void nis_endpwent(void);
extern struct passwd *nis_getpwent(void);
extern struct passwd *nis_getpwnam(const char *name);
extern struct passwd *nis_getpwuid(int uid);

/* DNS/Hesiod access functions */
extern void dns_setpwent(void);
extern void dns_endpwent(void);
extern struct passwd *dns_getpwent(void);
extern struct passwd *dns_getpwnam(const char *name);
extern struct passwd *dns_getpwuid(int uid);

/* Name Service Switch access functions */
extern void setpwent(void);
extern void endpwent(void);
extern struct passwd *getpwent(void);
extern struct passwd *getpwnam(const char *name);
extern struct passwd *getpwuid(int uid);

#endif
