/*
** nis_print.c
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#include <stdio.h>
#include <rpcsvc/nis.h>
#include "nis_utils.h"


static void print_directory(dob, ind)
    directory_obj *dob;
    int ind;
{
    printf("%*sName = %s\n", ind, "", dob->do_name);
    printf("%*sType = %d\n", ind, "", dob->do_type);
    printf("%*sTTL = %d (seconds)\n", ind, "", dob->do_ttl);
}

static void print_group(go, ind)
    group_obj *go;
    int ind;
{
    int i;
    
    printf("%*sFlags = 0x%08X\n", ind, "", go->gr_flags);
    printf("%*sMembers = %d:\n", ind, "", go->gr_members.gr_members_len);

    for (i = 0; i < go->gr_members.gr_members_len; i++)
	printf("%*s  1: %*s\n", ind, "", i, go->gr_members.gr_members_val[i]);
}


static void print_table_col(tc, ind)
    table_col *tc;
    int ind;
{
   printf("%*sName   = %s\n", ind, "", tc->tc_name);
   printf("%*sFlags  = 0x%08X (%s)\n", ind, "", tc->tc_flags,
	  	   nis_taflags2str(tc->tc_flags, NULL));
   printf("%*sRights = 0x%08X (%s)\n", ind, "", tc->tc_rights,
	  nis_access2str(tc->tc_rights, NULL));
}


static void print_table(to, ind)
    table_obj *to;
    int ind;
{
    int i;
    
    printf("%*sType = %s\n", ind, "", to->ta_type);
    printf("%*sMaxCol = %d\n", ind, "", to->ta_maxcol);
    printf("%*sSeparator = '%c' (%d)\n", ind, "", to->ta_sep, to->ta_sep);

    for (i = 0; i < to->ta_cols.ta_cols_len; i++)
    {
	printf("%*s  Column #%d:\n", ind, "", i);
	print_table_col(&to->ta_cols.ta_cols_val[i], ind+4);
    }

    printf("%*sPath = %s\n", ind, "", to->ta_path);
}


static void print_entry_col(ec, ind)
    entry_col *ec;
    int ind;
{
    printf("%*sFlags = %08x (%s)\n", ind, "", ec->ec_flags,
	   nis_enflags2str(ec->ec_flags, NULL));
    printf("%*sValue length = %d\n", ind, "", ec->ec_value.ec_value_len);
    printf("%*sValue data   = %s\n", ind, "", ec->ec_value.ec_value_val);
}


static void print_entry(eo, ind)
    entry_obj *eo;
    int ind;
{
    int i;
    
    printf("%*sType = %s\n", ind, "", eo->en_type);
    printf("%*sValues = %d\n", ind, "", eo->en_cols.en_cols_len);
    for (i = 0; i < eo->en_cols.en_cols_len; i++)
    {
	printf("%*s  Value #%d:\n", ind, "", i);
	print_entry_col(&eo->en_cols.en_cols_val[i], ind+4);
    }
}


static void print_attr(at, ind)
    nis_attr *at;
    int ind;
{
    printf("%*sNDX = %s\n", ind, "", at->zattr_ndx);
    printf("%*sLength = %d\n", ind, "", at->zattr_val.zattr_val_len);
}


static void print_link(lo, ind)
    link_obj *lo;
    int ind;
{
    int i;
    
    printf("%*sType = %d\n", ind, "", lo->li_rtype);
    printf("%*sName = %s\n", ind, "", lo->li_name);
    printf("%*sAttributes = %d\n", ind, "", lo->li_attrs.li_attrs_len);
    for (i = 0; i < lo->li_attrs.li_attrs_len; i++)
    {
	printf("%*s  Attribute #%d:\n", ind, "", i);
	print_attr(&lo->li_attrs.li_attrs_val[i], ind+4);
    }
}
    

static void print_objdata(obd, ind)
    objdata *obd;
    int ind;
{
    printf("%*sObjType = %d ", ind, "", obd->zo_type);
    switch (obd->zo_type)
    {
      case BOGUS_OBJ:
	printf("(Bogus Object)\n");
	break;
	
      case NO_OBJ:
	printf("(No Object)\n");
	break;
	
      case DIRECTORY_OBJ:
	printf("(Directory)\n");
	print_directory(&obd->objdata_u.di_data, ind+4);
	break;

      case GROUP_OBJ:
	printf("(Group)\n");
	print_group(&obd->objdata_u.gr_data, ind+4);
	break;

      case TABLE_OBJ:
	printf("(Table)\n");
	print_table(&obd->objdata_u.ta_data, ind+4);
	break;

      case ENTRY_OBJ:
	printf("(Entry)\n");
	print_entry(&obd->objdata_u.en_data, ind+4);
	break;

      case LINK_OBJ:
	printf("(Link)\n");
	print_link(&obd->objdata_u.li_data, ind+4);
	break;

      case PRIVATE_OBJ:
	printf("(Private)\n");
	printf("%*s    Data Length = %d\n", ind, "", 
	       obd->objdata_u.po_data.po_data_len);
	break;

      default:
	printf("(Unknown object)\n");
	break;
    }
}


static void print_object(ob, ind)
    nis_object *ob;
    int ind;
{
    printf("%*sObject created at %s", ind, "", ctime(&ob->zo_oid.ctime));
    printf("%*s last modified at %s", ind, "", ctime(&ob->zo_oid.mtime));
    printf("%*sName   = \"%s\"\n", ind, "", ob->zo_name);
    printf("%*sOwner  = \"%s\"\n", ind, "", ob->zo_owner);
    printf("%*sGroup  = \"%s\"\n", ind, "", ob->zo_group);
    printf("%*sDomain = \"%s\"\n", ind, "", ob->zo_domain);
    printf("%*sRights = 0x%08X (%s)\n", ind, "", ob->zo_access,
	   nis_access2str(ob->zo_access, NULL));
    printf("%*sTTL    = %d (seconds)\n", ind, "", ob->zo_ttl);
    
    print_objdata(&ob->zo_data, ind+4);
}


void print_result(nsres, ind)
    nis_result *nsres;
    int ind;
{
    int i;

    
    printf("%*sStatus = %d\n", ind, "", nsres->status);
    printf("%*sNumber of objects = %d\n", ind, "", nsres->objects.objects_len);
    
    for (i = 0; i < nsres->objects.objects_len; i++)
    {
	printf("%*s  Object #%d:\n", ind, "", i);
	print_object(&nsres->objects.objects_val[i], ind+4);
    }
}
