static char SCCSID[] = "@(#)hline.c	1.2 89/02/22";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC drawWhite, drawBlack;
static XSegment *segments;
#define NSEG    256

/*
 * horizontal lines
 *
 * often called for boxes/labels and spans
 */
hline_setup(dpy, win, len)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int i;
	XSegment *sp;

	drawWhite = XCreateGC(dpy, win, 0L, NULL);
	if (! drawWhite) return 1;
	XSetForeground(dpy, drawWhite, WhitePixel(dpy, screen));
	XSetBackground(dpy, drawWhite, BlackPixel(dpy, screen));

	drawBlack = XCreateGC(dpy, win, 0L, NULL);
	if (!drawBlack) return 1;
	XSetForeground(dpy, drawBlack, BlackPixel(dpy, screen));
	XSetBackground(dpy, drawBlack, WhitePixel(dpy, screen));

	segments = (XSegment *)malloc(sizeof(XSegment) * NSEG);
	if (segments == (XSegment *)0)
	    return 1;

	sp = segments;
	for (i=0; i<NSEG; i++) {
	    sp->x1 = i; sp->y1 = i;
	    sp->x2 = i+len; sp->y2 = i;
	    sp++;
	}
	return 0;
}

hline_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, drawWhite);
	XFreeGC(dpy, drawBlack);
	free(segments);
}

hline_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int nline;

	nline = 0;
	while (benchRunning) {
	    XDrawSegments(dpy, win, drawWhite, segments, NSEG);
	    XDrawSegments(dpy, win, drawBlack, segments, NSEG);
	    nline += NSEG*2;
	}
	return nline;
}

hline_msg(deltaT, nline, len, rate)
double rate;
{
	printf("HORIZONTAL LINES\n");
	printf("\n");
	printf("%d horizontal vectors of len. %d in %d secs\n",
				nline, len, deltaT);
	printf("rate = %8.2f vectors/sec (%d Pixels/sec)\n",
				rate, (nline*len)/deltaT);
}
