/****************************************************************************** 
 *
 * File:        midiprint.h
 * Version:     $Id: midiprint.h,v 1.2 1995/07/02 02:45:35 burgaard Exp $
 *
 * Purpose:     Standard MIDI File Pretty Printing
 *
 * Project:     MIDI/Sequencer library.
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 * Copyrights:  Copyright (c) 1994, 1995 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************
 *
 * Compile and see ../doc/libmidifile.tex for documentation on this file.
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MIDI_PRINT_H
#define __MIDI_PRINT_H

#include "miditypes.h"
#include "midiqueue.h"

/*** ENUMERATIONS *************************************************************/

enum MIDI_PRINT {
  MIDI_PRINT_NONE,
  MIDI_PRINT_SPARSE, /* sequence name and such */
  MIDI_PRINT_META,   /* all meta events */
  MIDI_PRINT_ALL
};

/*** MIDI FILE PRETTY PRINTING ************************************************/

extern void midi_printdata(int size, byte *data);
extern void midi_printtext(int size, byte *data);
extern void midi_printunknown(midi_event *event, enum MIDI_PRINT level);
extern void midi_printmeta(midi_event *event, enum MIDI_PRINT level);
extern void midi_printsysex(midi_event *event, enum MIDI_PRINT level);
extern void midi_printevent(midi_event *event, enum MIDI_PRINT level);
extern void midi_printrawevent(byte type, unsigned long time, word size, byte *data, enum MIDI_PRINT level);

#endif /* __MIDI_PRINT_H */

/*** END OF FILE **************************************************************/
