/***********************************************************************\
*	fft.h								*
*   Fast Fourier Transform C library - header file			*
*   Based on RECrandell's						*
*   dpwe 22jan90							*
*   08apr90 With experimental FFT2torl - converse of FFT2real		*
\***********************************************************************/

/*  
    To call an FFT, one must first assign the complex exponential factors:
    A call such as
	e = AssignBasis(NULL, size)
    will set up the complex *e to be the array of cos, sin pairs corresponding
    to total number of complex data = size.   This call allocates the
    (cos, sin) array memory for you.  If you already have such memory
    allocated, pass the allocated pointer instead of NULL.
 */

/*** how can it be so hard to get PI *?***/
#ifndef PI
#ifdef M_PI
#define PI M_PI
#else
#define PI 3.1415926535
#endif
#endif

/*** yukky ansi bodge ***/
#ifndef FLOATARG
#ifdef __STDC__
#define FLOATARG double /* some prototype checkers get funny about promotion */
#else
#define FLOATARG double
#endif /* def __STDC__ */
#endif /* def FLOATARG */

typedef struct {
    float re, im;
    } complex;

typedef struct lnode
    {
    struct lnode *next;
    long		 size;
    complex	 *table;
    } LNODE;

#ifdef __STDC__

int scancomplexdata(complex *);
void putcomplexdata(complex *, long);
void ShowCpx(complex *, long, char *);
int PureReal(complex *, long);
int IsPowerOfTwo(long);
complex *FindTable(long);	/* search our list of existing LUT's */
complex *AssignBasis(complex *, long);
void reverseDig(complex *, long, int);
void FFT2dimensional(complex *, long, long, complex *);
void FFT2torl(complex *, long, int, FLOATARG, complex *);
void ConjScale(complex *, long, FLOATARG);
void FFT2real(complex *, long, int, complex *);
void Reals(complex *, long, int, int, complex *);
void FFT2(complex *, long, int, complex *);
void FFT2raw(complex *, long, int, int, complex *);
void FFTarb(complex *, complex *, long, complex *);
void DFT(complex *, complex *, long, complex *);

#else

int scancomplexdata();
void putcomplexdata();
void ShowCpx();
int PureReal();
int IsPowerOfTwo();
complex *FindTable();	/* search our list of existing LUT's */
complex *AssignBasis();
void reverseDig();
void FFT2dimensional();
void FFT2torl();
void ConjScale();
void FFT2real();
void Reals();
void FFT2();
void FFT2raw();
void FFTarb();
void DFT();

#endif
