#include <stdio.h>
#include <midi.h>

MidiTimeShift(in, out, offset)
FILE	*in, *out;
float	offset;
/*
** Copy MIDI data from 'in' to 'out', shifting the times by 'offset'
** to delay or rush the events (times before 0 are ignored).
** Example: 'MidiTimeShift(in,out,-0.5)' deletes the first 1/2 measures
** of the data.
*/
{
	long when = offset * 2 * MPU_CLOCK_PERIOD;
	MpuCmd m;

	while (GetMpuCmd(in, &m)) {
		when += m.time_tag == RT_TCIP? MPU_CLOCK_PERIOD : m.time_tag;
		if (when >= 0)
			MidiClockPut(out, &m, when);
	}
	MidiClockPut(out, 0, 0);
}
