
/*
 *
$Log: motd.c,v $
 * Revision 1.5  1993/07/01  13:41:12  wade
 * clean compilation on osf
 *
 * Revision 1.4  1993/01/01  16:29:52  wade
 * improved contextual help message
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include "xnl.h"

int currentUpMotd_thatwasreallyup;

static Widget *menuItem;

void motdCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
        Mode_desired = MODE_MOTD;
        currentUpMotd = (int)call_data;
        
        Handle_state(w, NULL, NULL);
}


Popup_motd(w)
Widget w;
{
    currentUpMotd_thatwasreallyup = currentUpMotd;

	LibOrClass = Mode = MODE_MOTD;

	currentDisplayText = motdPop[currentUpMotd];
    
    XtManageChild(motdPop[currentUpMotd]);

    set_status(MOTD_HEADER, GREEN);
	return 1;
}

restart_motd(num_servers)
int num_servers;
{
    register int i;

    /* destroy items in menu */
    for (i=0; i < num_servers; i++)
	  if (menuItem[i] != NULL) {
        XtDestroyWidget(menuItem[i]);
        XtDestroyWidget(motdPop[i]);
	  }

    /* free motdPop, menuItem */
    free(motdPop);
    free(menuItem);

    make_motd(toplevel);
}

make_motd(w)
Widget w;
{
    Arg args[20];
    register int n, i;
    char filename[MAXLINE];
    FILE *fp;
    Boolean fileAvailable, anyNew;
    Widget entry;
	int file_age;
	char name[255];
	int IDX_LIFE_save;

	anyNew = False;

	con_help[MODE_MOTD] = "\n\
The Message of The Day is displayed by selecting the\n\
server from the Timely Message menu.\n\
\n\
Up to the minute site information will be posted here\n\
periodically.\n";


	/* always check for new motd */
	IDX_LIFE_save = IDX_LIFE;
	IDX_LIFE = 0;

    motdPop = (Widget*)malloc(Many_servers * sizeof(Widget) );
    menuItem = (Widget*)malloc(Many_servers * sizeof(Widget) );
    
    for (i=0; i < Many_servers; i++) {
        
        sprintf(filename, "%s/%s/%s", XNL_PATH, server_list[i], MOTD_FILE);

    
        file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False, True);

        /* first check to see if the file is there */
        if (fp = fopen(filename, "r")) {
            fileAvailable = True;
			fclose(fp);
        } else
            fileAvailable = False;

		if (file_age == 0)
			fileAvailable = False;

        if (fileAvailable) {

			if (file_age == 2) {
				strcpy(name, "* ");
				anyNew = True; /* at least one new file (mark button) */
			} else {
				name[0] = '\0';
			}
			strcat(name, server_list[i]);

		
			/* add the entry in the motd menu */
			menuItem[i] = entry = XtCreateManagedWidget(name, smeBSBObjectClass, 
				motdMenu, NULL, 0);
			XtAddCallback(entry, XtNcallback, motdCB, (XtPointer)i);

			n = 0;
			XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways);
														n++;
			XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded);
														n++;
            XtSetArg(args[n], XtNtype, XawUtkasciiFile); n++;
            XtSetArg(args[n], XtNstring, filename); n++;

			motdPop[i] = XtCreateWidget("motdPop", utkasciiTextWidgetClass, 
				topPane, args, n);
        } else {
			motdPop[i] = menuItem[i] = (Widget)NULL;
		}

    } /* for each server */

	IDX_LIFE = IDX_LIFE_save;

	if (anyNew) {	/* mark the motd button */
		XtSetArg(args[0], XtNlabel, "* Timely Message");
		XtSetValues(motdButton, args, 1);
	}

    return 1;
}

Popdown_motd(w)
Widget w;
{
	currentDisplayText = NULL;

    XtUnmanageChild(motdPop[currentUpMotd_thatwasreallyup]);

    return 1;
}

