#!/usr/bin/perl -w
#
# Convert a single gnuplot demo script to a web page
# Usage:
#	webify xxx
#
# Reads xxx.dem and creates xxx.html along with associated 
# png images output to xxx.<n>.png 
#
# If gpsavediff is present also create a set of scripts
# xxx.<n>.gnu corresponding to the minimal set of commands 
# needed to generate that png image.
#
# If gnuplot.css is present, link to it as a stylesheet.
#
# Ethan A Merritt <merritt@u.washington.edu>
# December 2003
#
# EAM Jan 2004
#   use gpsavediff if available
#   link to gnuplot.css if available
#
use HTML::Entities;

require "ctime.pl";

	my $date = &ctime(time);
	my $plot = 1;

# input and output files
	open(IN,  "<$ARGV[0].dem") or die "can't open $ARGV[0].dem";
	open(OUT, ">$ARGV[0].html") or die "can't open $ARGV[0].html";

# open pipe to gnuplot and set terminal type
	open(GNUPLOT, "|gnuplot") or die "can't find gnuplot";
	print GNUPLOT "set term png enhanced font arial 8 transparent size 420,320\n";
	print GNUPLOT "set output \"$ARGV[0].$plot.png\"\n";

# find out if gpsavediff is available in current path
	my $savescripts = T;
	{local $^W=0; $savescripts = open(FOO, "|gpsavediff") }
	close FOO if ($savescripts);

# Boiler plate header
	print OUT "<html>\n<head>\n<title>gnuplot demo script: $ARGV[0].dem </title>\n";
	print OUT "<link rel=\"stylesheet\" href=\"gnuplot.css\" type=\"text/css\">\n"
		  if (-e "gnuplot.css");
	print OUT "</head>\n";
	print OUT "<body>\n<h2>gnuplot demo script: <font color=blue>$ARGV[0].dem</font> </h2>\n";
	print OUT "<i>autogenerated by webify.pl on $date</i>";

# try to find gnuplot version
	$version = `gnuplot --version`;
	print OUT "\n<br><i>gnuplot version $version</i>";
	print OUT "<hr>\n";

# Start processing
	print OUT "<img src=\"$ARGV[0].$plot.png\" alt=\"\" align=right>\n";
	print OUT "<pre>\n";

	while (<IN>) {
		if (/^pause /) {
			if ($savescripts) {
			    print OUT "<br><p>Click <a href=$ARGV[0].$plot.gnu>here</a> ",
				  "for minimal script to generate this plot</p>\n";
			    print GNUPLOT "save \"| gpsavediff > $ARGV[0].$plot.gnu\"\n";
			}
			print OUT "</pre>\n<br clear=all>\n<hr>\n";
			$plot++;
			print OUT "<img src=\"$ARGV[0].$plot.png\" alt=\"\" align=right>\n";
			print OUT "<pre>\n";
			print GNUPLOT "set output \"$ARGV[0].$plot.png\"\n";
		} else {
			print OUT HTML::Entities::encode($_);
			print GNUPLOT;
		}
	}

# Amazingly enough, that's it.
# Unlink leftover empty plot before leaving.
	close GNUPLOT;
	unlink("$ARGV[0].$plot.png");
	print OUT "</pre>\n";
	print OUT "</body>\n</html>\n";

