dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels.

AC_PREREQ(2.13)

AC_DEFUN([CL_GMALLOC],
[dnl Invented by François Pinard <pinard@iro.umontreal.ca>
dnl (but he denies having invented it).
AC_CACHE_CHECK([for broken HP/UX malloc], cl_cv_func_malloc_broken, [
if test $cross_compiling = no; then
# Note that HP-UX has two different malloc() implementations.
# Both are broken. When used with CLISP, the one in the default libc.a
# leads to a SIGSEGV, the one in libmalloc.a leads to a SIGBUS.
case "$host_os" in
  hpux*) cl_cv_func_malloc_broken=yes ;;
  *) cl_cv_func_malloc_broken=no ;;
esac
else
cl_cv_func_malloc_broken="guessing no"
fi
])
case "$cl_cv_func_malloc_broken" in
  *yes) # Remedy: Use GNU malloc.
        GMALLOC=gmalloc ;;
  *no)  GMALLOC='' ;;
esac
AC_SUBST(GMALLOC)
])
