.\"
.\" "$Id: cupstestppd.man 5099 2006-02-13 02:46:10Z mike $"
.\"
.\"   cupstestppd man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636 USA
.\"
.\"       Voice: (301) 373-9600
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH cupstestppd 1 "Common UNIX Printing System" "12 February 2006" "Easy Software Products"
.SH NAME
cupstestppd \- test conformance of ppd files
.SH SYNOPSIS
.B cupstestppd
[ -q ] [-r] [ -v[v] ] filename.ppd[.gz] [ ... filenameN.ppd[.gz] ]
.br
.B cupstestppd
[ -q ] [-r] [ -v[v] ] -
.SH DESCRIPTION
\fIcupstestppd\fR tests the conformance of PPD files to the
Adobe PostScript Printer Description file format specification
version 4.3. It can also be used to list the supported options
and available fonts in a PPD file. The results of testing and
any other output are sent to the standard output.
.LP
The first form of \fIcupstestppd\fR tests one or more PPD files
on the command-line. The second form tests the PPD file provided
on the standard input.
.SH OPTIONS
\fIcupstestppd\fR supports the following options:
.TP 5
-q
.br
Specifies that no information should be displayed.
.TP 5
-r
.br
Relaxes the PPD conformance requirements so that common
whitespace, control character, and formatting problems are not
treated as hard errors.
.TP 5
-v
.br
Specifies that detailed conformance testing results should be
displayed rather than the concise PASS/FAIL/ERROR status.
.TP 5
-vv
.br
Specifies that all information in the PPD file should be
displayed in addition to the detailed conformance testing
results.
.LP
The \fI-q\fR, \fI-v\fR, and \fI-vv\fR options are mutually exclusive.
.SH EXIT STATUS
\fIcupstestppd\fR returns zero on success and non-zero on error. The
error codes are as follows:
.TP 5
1
.br
Bad command-line arguments or missing PPD filename.
.TP 5
2
.br
Unable to open or read PPD file.
.TP 5
3
.br
The PPD file contains format errors that cannot be skipped.
.TP 5
4
.br
The PPD file does not conform to the Adobe PPD specification.
.SH EXAMPLES
The following command will test all PPD files under the current
directory and print the names of each file that does not
conform:
.nf

    find . -name \\*.ppd \\! -exec cupstestppd -q '{}' \\; -print

.fi
The next command tests all PPD files under the current directory
and print detailed conformance testing results for the files
that do not conform:
.nf

    find . -name \\*.ppd \\! -exec cupstestppd -q '{}' \\; \\
        -exec cupstestppd -v '{}' \\;

.fi
.SH SEE ALSO
\fIlpadmin(8)\fR,
.br
http://localhost:631/help
.br
Adobe PostScript Printer Description File Format Specification, Version 4.3.
.SH COPYRIGHT
Copyright 1997-2006 by Easy Software Products, All Rights Reserved.
.\"
.\" End of "$Id: cupstestppd.man 5099 2006-02-13 02:46:10Z mike $".
.\"
