/*
** Copyright (c) 2025 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

#include <catch2/catch.hpp>

#include "util/logging.h"
#include "util/spirv_parsing_util.h"

const uint32_t test_bda_spirv[] = {
    0x07230203, 0x00010300, 0x0008000b, 0x0000064e, 0x00000000, 0x00020011, 0x00000001, 0x00020011, 0x000014e3,
    0x0009000a, 0x5f565053, 0x5f52484b, 0x73796870, 0x6c616369, 0x6f74735f, 0x65676172, 0x6675625f, 0x00726566,
    0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e, 0x00000000, 0x0003000e, 0x000014e4, 0x00000001,
    0x0006000f, 0x00000005, 0x00000004, 0x6e69616d, 0x00000000, 0x00000121, 0x00060010, 0x00000004, 0x00000011,
    0x00000020, 0x00000001, 0x00000001, 0x00030003, 0x00000002, 0x000001cc, 0x00070004, 0x455f4c47, 0x625f5458,
    0x65666675, 0x65725f72, 0x65726566, 0x0065636e, 0x00080004, 0x455f4c47, 0x625f5458, 0x65666675, 0x65725f72,
    0x65726566, 0x3265636e, 0x00000000, 0x000d0004, 0x455f4c47, 0x735f5458, 0x65646168, 0x78655f72, 0x63696c70,
    0x615f7469, 0x68746972, 0x6974656d, 0x79745f63, 0x5f736570, 0x36746e69, 0x00000034, 0x000d0004, 0x455f4c47,
    0x735f5458, 0x65646168, 0x78655f72, 0x63696c70, 0x615f7469, 0x68746972, 0x6974656d, 0x79745f63, 0x5f736570,
    0x38746e69, 0x00000000, 0x000a0004, 0x475f4c47, 0x4c474f4f, 0x70635f45, 0x74735f70, 0x5f656c79, 0x656e696c,
    0x7269645f, 0x69746365, 0x00006576, 0x00080004, 0x475f4c47, 0x4c474f4f, 0x6e695f45, 0x64756c63, 0x69645f65,
    0x74636572, 0x00657669, 0x00040005, 0x00000004, 0x6e69616d, 0x00000000, 0x00080005, 0x00000121, 0x475f6c67,
    0x61626f6c, 0x766e496c, 0x7461636f, 0x496e6f69, 0x00000044, 0x00070005, 0x0000012c, 0x77617264, 0x6c75635f,
    0x61645f6c, 0x745f6174, 0x00000000, 0x00050006, 0x0000012c, 0x00000000, 0x77656976, 0x00000000, 0x00040006,
    0x0000012c, 0x00000001, 0x00303050, 0x00040006, 0x0000012c, 0x00000002, 0x00313150, 0x00050006, 0x0000012c,
    0x00000003, 0x61656e7a, 0x00000072, 0x00050006, 0x0000012c, 0x00000004, 0x7261667a, 0x00000000, 0x00050006,
    0x0000012c, 0x00000005, 0x73757266, 0x006d7574, 0x00060006, 0x0000012c, 0x00000006, 0x5f6d756e, 0x77617264,
    0x00000073, 0x00060006, 0x0000012c, 0x00000007, 0x5f646f6c, 0x65736162, 0x00000000, 0x00060006, 0x0000012c,
    0x00000008, 0x5f646f6c, 0x70657473, 0x00000000, 0x00070006, 0x0000012c, 0x00000009, 0x5f78616d, 0x5f6d756e,
    0x73646f6c, 0x00000000, 0x00070006, 0x0000012c, 0x0000000a, 0x61727970, 0x5f64696d, 0x657a6973, 0x00000000,
    0x00070006, 0x0000012c, 0x0000000b, 0x73757266, 0x5f6d7574, 0x6c6c7563, 0x00000000, 0x00070006, 0x0000012c,
    0x0000000c, 0x6c63636f, 0x6f697375, 0x75635f6e, 0x00006c6c, 0x00080006, 0x0000012c, 0x0000000d, 0x746e6f63,
    0x75626972, 0x6e6f6974, 0x6c75635f, 0x0000006c, 0x00070006, 0x0000012c, 0x0000000e, 0x70696b73, 0x73656d5f,
    0x74656c68, 0x00000073, 0x00060006, 0x0000012c, 0x0000000f, 0x5f646f6c, 0x62616e65, 0x0064656c, 0x00080006,
    0x0000012c, 0x00000010, 0x6b736174, 0x726f775f, 0x6f72676b, 0x735f7075, 0x00657a69, 0x00060006, 0x0000012c,
    0x00000011, 0x77617264, 0x6e695f73, 0x00000000, 0x00070006, 0x0000012c, 0x00000012, 0x6873656d, 0x6172645f,
    0x695f7377, 0x0000006e, 0x00070006, 0x0000012c, 0x00000013, 0x6873656d, 0x746e655f, 0x73656972, 0x006e695f,
    0x00070006, 0x0000012c, 0x00000014, 0x77617264, 0x756f5f73, 0x72705f74, 0x00000065, 0x00070006, 0x0000012c,
    0x00000015, 0x77617264, 0x756f5f73, 0x6f705f74, 0x00007473, 0x00070006, 0x0000012c, 0x00000016, 0x77617264,
    0x756f635f, 0x705f746e, 0x00006572, 0x00070006, 0x0000012c, 0x00000017, 0x77617264, 0x756f635f, 0x705f746e,
    0x0074736f, 0x00060006, 0x0000012c, 0x00000018, 0x77617264, 0x7365725f, 0x00746c75, 0x00090005, 0x0000012d,
    0x65646e69, 0x5f646578, 0x69646e69, 0x74636572, 0x6d6f635f, 0x646e616d, 0x0000745f, 0x00060006, 0x0000012d,
    0x00000000, 0x65646e69, 0x756f4378, 0x0000746e, 0x00070006, 0x0000012d, 0x00000001, 0x74736e69, 0x65636e61,
    0x6e756f43, 0x00000074, 0x00060006, 0x0000012d, 0x00000002, 0x73726966, 0x646e4974, 0x00007865, 0x00070006,
    0x0000012d, 0x00000003, 0x74726576, 0x664f7865, 0x74657366, 0x00000000, 0x00070006, 0x0000012d, 0x00000004,
    0x73726966, 0x736e4974, 0x636e6174, 0x00000065, 0x00060006, 0x0000012d, 0x00000005, 0x756f7267, 0x756f4370,
    0x0058746e, 0x00060006, 0x0000012d, 0x00000006, 0x756f7267, 0x756f4370, 0x0059746e, 0x00060006, 0x0000012d,
    0x00000007, 0x756f7267, 0x756f4370, 0x005a746e, 0x00050006, 0x0000012d, 0x00000008, 0x69736976, 0x00656c62,
    0x00070006, 0x0000012d, 0x00000009, 0x6574616c, 0x7369765f, 0x656c6269, 0x00000000, 0x00070006, 0x0000012d,
    0x0000000a, 0x656a626f, 0x695f7463, 0x7865646e, 0x00000000, 0x00070006, 0x0000012d, 0x0000000b, 0x65736162,
    0x73656d5f, 0x74656c68, 0x00000000, 0x00070006, 0x0000012d, 0x0000000c, 0x5f6d756e, 0x6873656d, 0x7374656c,
    0x00000000, 0x000a0006, 0x0000012d, 0x0000000d, 0x6873656d, 0x5f74656c, 0x69736976, 0x696c6962, 0x695f7974,
    0x7865646e, 0x00000000, 0x00080006, 0x0000012d, 0x0000000e, 0x6e756f63, 0x75625f74, 0x72656666, 0x66666f5f,
    0x00746573, 0x00080006, 0x0000012d, 0x0000000f, 0x73726966, 0x72645f74, 0x695f7761, 0x7865646e, 0x00000000,
    0x00060005, 0x0000012f, 0x77617244, 0x66667542, 0x74507265, 0x00000072, 0x00040006, 0x0000012f, 0x00000000,
    0x00000076, 0x00050005, 0x00000130, 0x6e617274, 0x726f6673, 0x00745f6d, 0x00070006, 0x00000130, 0x00000000,
    0x6e617274, 0x74616c73, 0x5f6e6f69, 0x00000078, 0x00070006, 0x00000130, 0x00000001, 0x6e617274, 0x74616c73,
    0x5f6e6f69, 0x00000079, 0x00070006, 0x00000130, 0x00000002, 0x6e617274, 0x74616c73, 0x5f6e6f69, 0x0000007a,
    0x00060006, 0x00000130, 0x00000003, 0x61746f72, 0x6e6f6974, 0x0000785f, 0x00060006, 0x00000130, 0x00000004,
    0x61746f72, 0x6e6f6974, 0x0000795f, 0x00060006, 0x00000130, 0x00000005, 0x61746f72, 0x6e6f6974, 0x00007a5f,
    0x00060006, 0x00000130, 0x00000006, 0x61746f72, 0x6e6f6974, 0x0000775f, 0x00050006, 0x00000130, 0x00000007,
    0x6c616373, 0x00785f65, 0x00050006, 0x00000130, 0x00000008, 0x6c616373, 0x00795f65, 0x00050006, 0x00000130,
    0x00000009, 0x6c616373, 0x007a5f65, 0x00060005, 0x00000131, 0x7274616d, 0x735f7869, 0x63757274, 0x00745f74,
    0x00060006, 0x00000131, 0x00000000, 0x6a6f7270, 0x69746365, 0x00006e6f, 0x00050006, 0x00000131, 0x00000001,
    0x74786574, 0x00657275, 0x00060006, 0x00000131, 0x00000002, 0x6e617274, 0x726f6673, 0x0000006d, 0x00050005,
    0x00000132, 0x6873656d, 0x6172645f, 0x00745f77, 0x00080006, 0x00000132, 0x00000000, 0x72727563, 0x5f746e65,
    0x7274616d, 0x73656369, 0x00000000, 0x00070006, 0x00000132, 0x00000001, 0x7473616c, 0x74616d5f, 0x65636972,
    0x00000073, 0x00060006, 0x00000132, 0x00000002, 0x6873656d, 0x646e695f, 0x00007865, 0x00070006, 0x00000132,
    0x00000003, 0x6574616d, 0x6c616972, 0x646e695f, 0x00007865, 0x00070005, 0x00000134, 0x6873654d, 0x77617244,
    0x66667542, 0x74507265, 0x00000072, 0x00040006, 0x00000134, 0x00000000, 0x00000076, 0x00040005, 0x00000135,
    0x5f646f6c, 0x00000074, 0x00060006, 0x00000135, 0x00000000, 0x65736162, 0x646e695f, 0x00007865, 0x00060006,
    0x00000135, 0x00000001, 0x5f6d756e, 0x69646e69, 0x00736563, 0x00070006, 0x00000135, 0x00000002, 0x65736162,
    0x73656d5f, 0x74656c68, 0x00000000, 0x00070006, 0x00000135, 0x00000003, 0x5f6d756e, 0x6873656d, 0x7374656c,
    0x00000000, 0x00060005, 0x00000138, 0x6873656d, 0x746e655f, 0x745f7972, 0x00000000, 0x00050006, 0x00000138,
    0x00000000, 0x746e6563, 0x00007265, 0x00050006, 0x00000138, 0x00000001, 0x69646172, 0x00007375, 0x00070006,
    0x00000138, 0x00000002, 0x74726576, 0x6f5f7865, 0x65736666, 0x00000074, 0x00070006, 0x00000138, 0x00000003,
    0x74726576, 0x635f7865, 0x746e756f, 0x00000000, 0x00060006, 0x00000138, 0x00000004, 0x5f646f6c, 0x6e756f63,
    0x00000074, 0x00050006, 0x00000138, 0x00000005, 0x73646f6c, 0x00000000, 0x00070005, 0x0000013a, 0x6873654d,
    0x72746e45, 0x66754279, 0x50726566, 0x00007274, 0x00040006, 0x0000013a, 0x00000000, 0x00000076, 0x00070005,
    0x0000013c, 0x77617244, 0x6e756f43, 0x66754274, 0x50726566, 0x00007274, 0x00040006, 0x0000013c, 0x00000000,
    0x00000076, 0x00070005, 0x0000013d, 0x77617264, 0x6c75635f, 0x65725f6c, 0x746c7573, 0x0000745f, 0x00060006,
    0x0000013d, 0x00000000, 0x5f6d756e, 0x77617264, 0x00000073, 0x00080006, 0x0000013d, 0x00000001, 0x5f6d756e,
    0x73757266, 0x5f6d7574, 0x6c6c7563, 0x00006465, 0x00090006, 0x0000013d, 0x00000002, 0x5f6d756e, 0x6c63636f,
    0x6f697375, 0x75635f6e, 0x64656c6c, 0x00000000, 0x00090006, 0x0000013d, 0x00000003, 0x5f6d756e, 0x746e6f63,
    0x75626972, 0x6e6f6974, 0x6c75635f, 0x0064656c, 0x00070006, 0x0000013d, 0x00000004, 0x5f6d756e, 0x61697274,
    0x656c676e, 0x00000073, 0x00070006, 0x0000013d, 0x00000005, 0x5f6d756e, 0x6873656d, 0x7374656c, 0x00000000,
    0x00060005, 0x0000013e, 0x77617244, 0x75736552, 0x7450746c, 0x00000072, 0x00040006, 0x0000013e, 0x00000000,
    0x00000076, 0x00060005, 0x0000013f, 0x6c6c7563, 0x61746164, 0x6f62755f, 0x0000745f, 0x00060006, 0x0000013f,
    0x00000000, 0x6c6c7563, 0x7461645f, 0x00000061, 0x00030005, 0x00000141, 0x00000000, 0x00040005, 0x000001ca,
    0x5f646f6c, 0x00000074, 0x00060006, 0x000001ca, 0x00000000, 0x65736162, 0x646e695f, 0x00007865, 0x00060006,
    0x000001ca, 0x00000001, 0x5f6d756e, 0x69646e69, 0x00736563, 0x00070006, 0x000001ca, 0x00000002, 0x65736162,
    0x73656d5f, 0x74656c68, 0x00000000, 0x00070006, 0x000001ca, 0x00000003, 0x5f6d756e, 0x6873656d, 0x7374656c,
    0x00000000, 0x00040005, 0x00000236, 0x746e6563, 0x00007265, 0x00040005, 0x00000256, 0x62626161, 0x00000000,
    0x00040005, 0x00000257, 0x61726170, 0x0000006d, 0x00050005, 0x00000268, 0x65726373, 0x615f6e65, 0x00616572,
    0x00040005, 0x00000276, 0x61726170, 0x0000006d, 0x00040005, 0x0000027a, 0x61726170, 0x0000006d, 0x00060005,
    0x000002d1, 0x65645f75, 0x5f687470, 0x61727970, 0x0064696d, 0x00040047, 0x00000121, 0x0000000b, 0x0000001c,
    0x00040048, 0x0000012c, 0x00000000, 0x00000005, 0x00050048, 0x0000012c, 0x00000000, 0x00000007, 0x00000010,
    0x00050048, 0x0000012c, 0x00000000, 0x00000023, 0x00000000, 0x00050048, 0x0000012c, 0x00000001, 0x00000023,
    0x00000040, 0x00050048, 0x0000012c, 0x00000002, 0x00000023, 0x00000044, 0x00050048, 0x0000012c, 0x00000003,
    0x00000023, 0x00000048, 0x00050048, 0x0000012c, 0x00000004, 0x00000023, 0x0000004c, 0x00050048, 0x0000012c,
    0x00000005, 0x00000023, 0x00000050, 0x00050048, 0x0000012c, 0x00000006, 0x00000023, 0x00000060, 0x00050048,
    0x0000012c, 0x00000007, 0x00000023, 0x00000064, 0x00050048, 0x0000012c, 0x00000008, 0x00000023, 0x00000068,
    0x00050048, 0x0000012c, 0x00000009, 0x00000023, 0x0000006c, 0x00050048, 0x0000012c, 0x0000000a, 0x00000023,
    0x00000070, 0x00050048, 0x0000012c, 0x0000000b, 0x00000023, 0x00000078, 0x00050048, 0x0000012c, 0x0000000c,
    0x00000023, 0x0000007c, 0x00050048, 0x0000012c, 0x0000000d, 0x00000023, 0x00000080, 0x00050048, 0x0000012c,
    0x0000000e, 0x00000023, 0x00000084, 0x00050048, 0x0000012c, 0x0000000f, 0x00000023, 0x00000088, 0x00050048,
    0x0000012c, 0x00000010, 0x00000023, 0x0000008c, 0x00050048, 0x0000012c, 0x00000011, 0x00000023, 0x00000090,
    0x00050048, 0x0000012c, 0x00000012, 0x00000023, 0x00000098, 0x00050048, 0x0000012c, 0x00000013, 0x00000023,
    0x000000a0, 0x00050048, 0x0000012c, 0x00000014, 0x00000023, 0x000000a8, 0x00050048, 0x0000012c, 0x00000015,
    0x00000023, 0x000000b0, 0x00050048, 0x0000012c, 0x00000016, 0x00000023, 0x000000b8, 0x00050048, 0x0000012c,
    0x00000017, 0x00000023, 0x000000c0, 0x00050048, 0x0000012c, 0x00000018, 0x00000023, 0x000000c8, 0x00050048,
    0x0000012d, 0x00000000, 0x00000023, 0x00000000, 0x00050048, 0x0000012d, 0x00000001, 0x00000023, 0x00000004,
    0x00050048, 0x0000012d, 0x00000002, 0x00000023, 0x00000008, 0x00050048, 0x0000012d, 0x00000003, 0x00000023,
    0x0000000c, 0x00050048, 0x0000012d, 0x00000004, 0x00000023, 0x00000010, 0x00050048, 0x0000012d, 0x00000005,
    0x00000023, 0x00000014, 0x00050048, 0x0000012d, 0x00000006, 0x00000023, 0x00000018, 0x00050048, 0x0000012d,
    0x00000007, 0x00000023, 0x0000001c, 0x00050048, 0x0000012d, 0x00000008, 0x00000023, 0x00000020, 0x00050048,
    0x0000012d, 0x00000009, 0x00000023, 0x00000024, 0x00050048, 0x0000012d, 0x0000000a, 0x00000023, 0x00000028,
    0x00050048, 0x0000012d, 0x0000000b, 0x00000023, 0x0000002c, 0x00050048, 0x0000012d, 0x0000000c, 0x00000023,
    0x00000030, 0x00050048, 0x0000012d, 0x0000000d, 0x00000023, 0x00000034, 0x00050048, 0x0000012d, 0x0000000e,
    0x00000023, 0x00000038, 0x00050048, 0x0000012d, 0x0000000f, 0x00000023, 0x0000003c, 0x00040047, 0x0000012e,
    0x00000006, 0x00000040, 0x00030047, 0x0000012f, 0x00000002, 0x00050048, 0x0000012f, 0x00000000, 0x00000023,
    0x00000000, 0x00050048, 0x00000130, 0x00000000, 0x00000023, 0x00000000, 0x00050048, 0x00000130, 0x00000001,
    0x00000023, 0x00000004, 0x00050048, 0x00000130, 0x00000002, 0x00000023, 0x00000008, 0x00050048, 0x00000130,
    0x00000003, 0x00000023, 0x0000000c, 0x00050048, 0x00000130, 0x00000004, 0x00000023, 0x00000010, 0x00050048,
    0x00000130, 0x00000005, 0x00000023, 0x00000014, 0x00050048, 0x00000130, 0x00000006, 0x00000023, 0x00000018,
    0x00050048, 0x00000130, 0x00000007, 0x00000023, 0x0000001c, 0x00050048, 0x00000130, 0x00000008, 0x00000023,
    0x00000020, 0x00050048, 0x00000130, 0x00000009, 0x00000023, 0x00000024, 0x00040048, 0x00000131, 0x00000000,
    0x00000005, 0x00050048, 0x00000131, 0x00000000, 0x00000007, 0x00000010, 0x00050048, 0x00000131, 0x00000000,
    0x00000023, 0x00000000, 0x00040048, 0x00000131, 0x00000001, 0x00000005, 0x00050048, 0x00000131, 0x00000001,
    0x00000007, 0x00000010, 0x00050048, 0x00000131, 0x00000001, 0x00000023, 0x00000040, 0x00050048, 0x00000131,
    0x00000002, 0x00000023, 0x00000080, 0x00050048, 0x00000132, 0x00000000, 0x00000023, 0x00000000, 0x00050048,
    0x00000132, 0x00000001, 0x00000023, 0x000000b0, 0x00050048, 0x00000132, 0x00000002, 0x00000023, 0x00000160,
    0x00050048, 0x00000132, 0x00000003, 0x00000023, 0x00000164, 0x00040047, 0x00000133, 0x00000006, 0x00000170,
    0x00030047, 0x00000134, 0x00000002, 0x00040048, 0x00000134, 0x00000000, 0x00000018, 0x00050048, 0x00000134,
    0x00000000, 0x00000023, 0x00000000, 0x00050048, 0x00000135, 0x00000000, 0x00000023, 0x00000000, 0x00050048,
    0x00000135, 0x00000001, 0x00000023, 0x00000004, 0x00050048, 0x00000135, 0x00000002, 0x00000023, 0x00000008,
    0x00050048, 0x00000135, 0x00000003, 0x00000023, 0x0000000c, 0x00040047, 0x00000137, 0x00000006, 0x00000010,
    0x00050048, 0x00000138, 0x00000000, 0x00000023, 0x00000000, 0x00050048, 0x00000138, 0x00000001, 0x00000023,
    0x0000000c, 0x00050048, 0x00000138, 0x00000002, 0x00000023, 0x00000010, 0x00050048, 0x00000138, 0x00000003,
    0x00000023, 0x00000014, 0x00050048, 0x00000138, 0x00000004, 0x00000023, 0x00000018, 0x00050048, 0x00000138,
    0x00000005, 0x00000023, 0x0000001c, 0x00040047, 0x00000139, 0x00000006, 0x000000a0, 0x00030047, 0x0000013a,
    0x00000002, 0x00040048, 0x0000013a, 0x00000000, 0x00000018, 0x00050048, 0x0000013a, 0x00000000, 0x00000023,
    0x00000000, 0x00040047, 0x0000013b, 0x00000006, 0x00000004, 0x00030047, 0x0000013c, 0x00000002, 0x00050048,
    0x0000013c, 0x00000000, 0x00000023, 0x00000000, 0x00050048, 0x0000013d, 0x00000000, 0x00000023, 0x00000000,
    0x00050048, 0x0000013d, 0x00000001, 0x00000023, 0x00000004, 0x00050048, 0x0000013d, 0x00000002, 0x00000023,
    0x00000008, 0x00050048, 0x0000013d, 0x00000003, 0x00000023, 0x0000000c, 0x00050048, 0x0000013d, 0x00000004,
    0x00000023, 0x00000010, 0x00050048, 0x0000013d, 0x00000005, 0x00000023, 0x00000014, 0x00030047, 0x0000013e,
    0x00000002, 0x00050048, 0x0000013e, 0x00000000, 0x00000023, 0x00000000, 0x00030047, 0x0000013f, 0x00000002,
    0x00050048, 0x0000013f, 0x00000000, 0x00000023, 0x00000000, 0x00040047, 0x00000141, 0x00000021, 0x00000001,
    0x00040047, 0x00000141, 0x00000022, 0x00000000, 0x00040047, 0x000002d1, 0x00000021, 0x00000000, 0x00040047,
    0x000002d1, 0x00000022, 0x00000000, 0x00040047, 0x00000414, 0x0000000b, 0x00000019, 0x00020013, 0x00000002,
    0x00030021, 0x00000003, 0x00000002, 0x00030016, 0x00000006, 0x00000020, 0x00040017, 0x00000007, 0x00000006,
    0x00000004, 0x00040017, 0x00000008, 0x00000006, 0x00000003, 0x00040020, 0x00000014, 0x00000007, 0x00000008,
    0x00040020, 0x00000015, 0x00000007, 0x00000006, 0x00040020, 0x00000016, 0x00000007, 0x00000007, 0x00020014,
    0x00000017, 0x00040015, 0x00000027, 0x00000020, 0x00000000, 0x00040020, 0x00000028, 0x00000007, 0x00000027,
    0x0004002b, 0x00000006, 0x0000002e, 0x40000000, 0x0004002b, 0x00000027, 0x00000032, 0x00000003, 0x00040015,
    0x0000003c, 0x00000020, 0x00000001, 0x0004002b, 0x0000003c, 0x0000003d, 0x00000003, 0x0004002b, 0x0000003c,
    0x0000003f, 0x00000004, 0x0004002b, 0x0000003c, 0x00000041, 0x00000005, 0x0004002b, 0x0000003c, 0x00000043,
    0x00000006, 0x0004002b, 0x0000003c, 0x00000047, 0x00000007, 0x0004002b, 0x0000003c, 0x00000049, 0x00000008,
    0x0004002b, 0x0000003c, 0x0000004b, 0x00000009, 0x0004002b, 0x0000003c, 0x00000052, 0x00000000, 0x0004002b,
    0x0000003c, 0x00000054, 0x00000001, 0x0004002b, 0x0000003c, 0x00000056, 0x00000002, 0x0004002b, 0x00000027,
    0x0000005c, 0x00000002, 0x0004002b, 0x00000027, 0x0000005f, 0x00000001, 0x0004002b, 0x00000027, 0x00000063,
    0x00000000, 0x0003002a, 0x00000017, 0x0000008c, 0x00040017, 0x0000008e, 0x00000006, 0x00000002, 0x00040020,
    0x0000008f, 0x00000007, 0x0000008e, 0x00040018, 0x000000ac, 0x0000008e, 0x00000002, 0x0004002b, 0x00000006,
    0x000000ad, 0x3f800000, 0x0004002b, 0x00000006, 0x0000010d, 0x3f000000, 0x0004002b, 0x00000006, 0x0000010e,
    0xbf000000, 0x0007002c, 0x00000007, 0x0000010f, 0x0000010d, 0x0000010e, 0x0000010d, 0x0000010e, 0x0007002c,
    0x00000007, 0x00000111, 0x0000010d, 0x0000010d, 0x0000010d, 0x0000010d, 0x00030029, 0x00000017, 0x00000113,
    0x00040017, 0x0000011f, 0x00000027, 0x00000003, 0x00040020, 0x00000120, 0x00000001, 0x0000011f, 0x0004003b,
    0x00000120, 0x00000121, 0x00000001, 0x00040020, 0x00000122, 0x00000001, 0x00000027, 0x00040018, 0x00000126,
    0x00000007, 0x00000004, 0x00030027, 0x00000127, 0x000014e5, 0x00030027, 0x00000128, 0x000014e5, 0x00030027,
    0x00000129, 0x000014e5, 0x00030027, 0x0000012a, 0x000014e5, 0x00030027, 0x0000012b, 0x000014e5, 0x001b001e,
    0x0000012c, 0x00000126, 0x00000006, 0x00000006, 0x00000006, 0x00000006, 0x00000007, 0x00000027, 0x00000006,
    0x00000006, 0x00000027, 0x0000008e, 0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x00000027,
    0x00000127, 0x00000128, 0x00000129, 0x00000127, 0x00000127, 0x0000012a, 0x0000012a, 0x0000012b, 0x0012001e,
    0x0000012d, 0x00000027, 0x00000027, 0x00000027, 0x0000003c, 0x00000027, 0x00000027, 0x00000027, 0x00000027,
    0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x0003001d,
    0x0000012e, 0x0000012d, 0x0003001e, 0x0000012f, 0x0000012e, 0x00040020, 0x00000127, 0x000014e5, 0x0000012f,
    0x000c001e, 0x00000130, 0x00000006, 0x00000006, 0x00000006, 0x00000006, 0x00000006, 0x00000006, 0x00000006,
    0x00000006, 0x00000006, 0x00000006, 0x0005001e, 0x00000131, 0x00000126, 0x00000126, 0x00000130, 0x0006001e,
    0x00000132, 0x00000131, 0x00000131, 0x00000027, 0x00000027, 0x0003001d, 0x00000133, 0x00000132, 0x0003001e,
    0x00000134, 0x00000133, 0x00040020, 0x00000128, 0x000014e5, 0x00000134, 0x0006001e, 0x00000135, 0x00000027,
    0x00000027, 0x00000027, 0x00000027, 0x0004002b, 0x00000027, 0x00000136, 0x00000008, 0x0004001c, 0x00000137,
    0x00000135, 0x00000136, 0x0008001e, 0x00000138, 0x00000008, 0x00000006, 0x00000027, 0x00000027, 0x00000027,
    0x00000137, 0x0003001d, 0x00000139, 0x00000138, 0x0003001e, 0x0000013a, 0x00000139, 0x00040020, 0x00000129,
    0x000014e5, 0x0000013a, 0x0003001d, 0x0000013b, 0x00000027, 0x0003001e, 0x0000013c, 0x0000013b, 0x00040020,
    0x0000012a, 0x000014e5, 0x0000013c, 0x0008001e, 0x0000013d, 0x00000027, 0x00000027, 0x00000027, 0x00000027,
    0x00000027, 0x00000027, 0x0003001e, 0x0000013e, 0x0000013d, 0x00040020, 0x0000012b, 0x000014e5, 0x0000013e,
    0x0003001e, 0x0000013f, 0x0000012c, 0x00040020, 0x00000140, 0x00000002, 0x0000013f, 0x0004003b, 0x00000140,
    0x00000141, 0x00000002, 0x00040020, 0x00000142, 0x00000002, 0x00000027, 0x0004002b, 0x0000003c, 0x0000014c,
    0x00000011, 0x00040020, 0x0000014d, 0x00000002, 0x00000127, 0x00040020, 0x00000151, 0x000014e5, 0x0000012d,
    0x0004002b, 0x0000003c, 0x0000016d, 0x0000000a, 0x0004002b, 0x0000003c, 0x00000170, 0x0000000b, 0x0004002b,
    0x0000003c, 0x00000173, 0x0000000c, 0x0004002b, 0x0000003c, 0x00000176, 0x0000000d, 0x0004002b, 0x0000003c,
    0x00000179, 0x0000000e, 0x0004002b, 0x0000003c, 0x0000017c, 0x0000000f, 0x0004002b, 0x0000003c, 0x00000182,
    0x00000012, 0x00040020, 0x00000183, 0x00000002, 0x00000128, 0x00040020, 0x00000188, 0x000014e5, 0x00000132,
    0x0006001e, 0x000001ca, 0x00000027, 0x00000027, 0x00000027, 0x00000027, 0x0004001c, 0x000001cb, 0x000001ca,
    0x00000136, 0x0004002b, 0x0000003c, 0x000001cf, 0x00000013, 0x00040020, 0x000001d0, 0x00000002, 0x00000129,
    0x00040020, 0x000001d5, 0x000014e5, 0x00000138, 0x00040020, 0x000001e3, 0x00000007, 0x000001cb, 0x00040020,
    0x000001e6, 0x00000007, 0x000001ca, 0x00040020, 0x00000237, 0x00000002, 0x00000126, 0x00040020, 0x0000025c,
    0x00000002, 0x00000006, 0x00040020, 0x0000027b, 0x00000002, 0x00000007, 0x0004002b, 0x0000003c, 0x00000285,
    0x00000018, 0x00040020, 0x00000286, 0x00000002, 0x0000012b, 0x00040020, 0x00000289, 0x000014e5, 0x00000027,
    0x00090019, 0x000002ce, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000,
    0x0003001b, 0x000002cf, 0x000002ce, 0x00040020, 0x000002d0, 0x00000000, 0x000002cf, 0x0004003b, 0x000002d0,
    0x000002d1, 0x00000000, 0x0004002b, 0x0000003c, 0x0000033d, 0x00000010, 0x0004002b, 0x00000027, 0x00000358,
    0x00000020, 0x0004002b, 0x0000003c, 0x0000037d, 0x00000016, 0x00040020, 0x0000037e, 0x00000002, 0x0000012a,
    0x0004002b, 0x0000003c, 0x00000385, 0x00000014, 0x00040020, 0x00000395, 0x000014e5, 0x0000003c, 0x0004002b,
    0x0000003c, 0x000003d6, 0x00000017, 0x0004002b, 0x0000003c, 0x000003dd, 0x00000015, 0x0006002c, 0x0000011f,
    0x00000414, 0x00000358, 0x0000005f, 0x0000005f, 0x0003002e, 0x00000008, 0x00000570, 0x0004002b, 0x00000027,
    0x00000571, 0x0000001f, 0x00030001, 0x00000007, 0x00000574, 0x00050036, 0x00000002, 0x00000004, 0x00000000,
    0x00000003, 0x000200f8, 0x00000005, 0x0004003b, 0x000001e3, 0x0000053d, 0x00000007, 0x0004003b, 0x0000008f,
    0x00000441, 0x00000007, 0x0004003b, 0x0000008f, 0x00000442, 0x00000007, 0x0004003b, 0x0000008f, 0x00000443,
    0x00000007, 0x0004003b, 0x0000008f, 0x00000445, 0x00000007, 0x0004003b, 0x0000008f, 0x00000446, 0x00000007,
    0x0004003b, 0x0000008f, 0x00000447, 0x00000007, 0x0004003b, 0x00000014, 0x00000236, 0x00000007, 0x0004003b,
    0x00000016, 0x00000256, 0x00000007, 0x0004003b, 0x00000014, 0x00000257, 0x00000007, 0x0004003b, 0x0000008f,
    0x00000268, 0x00000007, 0x0004003b, 0x00000014, 0x00000276, 0x00000007, 0x0004003b, 0x00000016, 0x0000027a,
    0x00000007, 0x000300f7, 0x00000415, 0x00000000, 0x000300fb, 0x00000063, 0x00000416, 0x000200f8, 0x00000416,
    0x00050041, 0x00000122, 0x00000123, 0x00000121, 0x00000063, 0x0004003d, 0x00000027, 0x00000124, 0x00000123,
    0x00060041, 0x00000142, 0x00000143, 0x00000141, 0x00000052, 0x00000043, 0x0004003d, 0x00000027, 0x00000144,
    0x00000143, 0x000500ae, 0x00000017, 0x00000145, 0x00000124, 0x00000144, 0x000300f7, 0x00000147, 0x00000000,
    0x000400fa, 0x00000145, 0x00000146, 0x00000147, 0x000200f8, 0x00000146, 0x000200f9, 0x00000415, 0x000200f8,
    0x00000147, 0x00060041, 0x0000014d, 0x0000014e, 0x00000141, 0x00000052, 0x0000014c, 0x0004003d, 0x00000127,
    0x0000014f, 0x0000014e, 0x00060041, 0x00000151, 0x00000152, 0x0000014f, 0x00000052, 0x00000124, 0x0006003d,
    0x0000012d, 0x00000153, 0x00000152, 0x00000002, 0x00000010, 0x00050051, 0x00000027, 0x00000154, 0x00000153,
    0x00000000, 0x00050051, 0x00000027, 0x00000156, 0x00000153, 0x00000001, 0x00050051, 0x00000027, 0x00000158,
    0x00000153, 0x00000002, 0x00050051, 0x0000003c, 0x0000015a, 0x00000153, 0x00000003, 0x00050051, 0x00000027,
    0x0000015d, 0x00000153, 0x00000004, 0x00050051, 0x00000027, 0x0000015f, 0x00000153, 0x00000005, 0x00050051,
    0x00000027, 0x00000161, 0x00000153, 0x00000006, 0x00050051, 0x00000027, 0x00000163, 0x00000153, 0x00000007,
    0x00050051, 0x00000027, 0x00000165, 0x00000153, 0x00000008, 0x000500ab, 0x00000017, 0x00000166, 0x00000165,
    0x00000063, 0x00050051, 0x00000027, 0x00000169, 0x00000153, 0x00000009, 0x000500ab, 0x00000017, 0x0000016a,
    0x00000169, 0x00000063, 0x00050051, 0x00000027, 0x0000016c, 0x00000153, 0x0000000a, 0x00050051, 0x00000027,
    0x0000016f, 0x00000153, 0x0000000b, 0x00050051, 0x00000027, 0x00000172, 0x00000153, 0x0000000c, 0x00050051,
    0x00000027, 0x00000175, 0x00000153, 0x0000000d, 0x00050051, 0x00000027, 0x00000178, 0x00000153, 0x0000000e,
    0x00050051, 0x00000027, 0x0000017b, 0x00000153, 0x0000000f, 0x00060041, 0x00000183, 0x00000184, 0x00000141,
    0x00000052, 0x00000182, 0x0004003d, 0x00000128, 0x00000185, 0x00000184, 0x00060041, 0x00000188, 0x00000189,
    0x00000185, 0x00000052, 0x0000016c, 0x0006003d, 0x00000132, 0x0000018a, 0x00000189, 0x00000002, 0x00000010,
    0x00050051, 0x00000131, 0x0000018b, 0x0000018a, 0x00000000, 0x00050051, 0x00000130, 0x00000193, 0x0000018b,
    0x00000002, 0x00050051, 0x00000006, 0x00000196, 0x00000193, 0x00000000, 0x00050051, 0x00000006, 0x00000198,
    0x00000193, 0x00000001, 0x00050051, 0x00000006, 0x0000019a, 0x00000193, 0x00000002, 0x00050051, 0x00000006,
    0x0000019c, 0x00000193, 0x00000003, 0x00050051, 0x00000006, 0x0000019e, 0x00000193, 0x00000004, 0x00050051,
    0x00000006, 0x000001a0, 0x00000193, 0x00000005, 0x00050051, 0x00000006, 0x000001a2, 0x00000193, 0x00000006,
    0x00050051, 0x00000006, 0x000001a4, 0x00000193, 0x00000007, 0x00050051, 0x00000006, 0x000001a6, 0x00000193,
    0x00000008, 0x00050051, 0x00000006, 0x000001a8, 0x00000193, 0x00000009, 0x00050051, 0x00000027, 0x000001c6,
    0x0000018a, 0x00000002, 0x00060041, 0x000001d0, 0x000001d1, 0x00000141, 0x00000052, 0x000001cf, 0x0004003d,
    0x00000129, 0x000001d2, 0x000001d1, 0x00060041, 0x000001d5, 0x000001d6, 0x000001d2, 0x00000052, 0x000001c6,
    0x0006003d, 0x00000138, 0x000001d7, 0x000001d6, 0x00000002, 0x00000010, 0x00050051, 0x00000008, 0x000001d8,
    0x000001d7, 0x00000000, 0x00050051, 0x00000006, 0x000001da, 0x000001d7, 0x00000001, 0x00050051, 0x00000027,
    0x000001dc, 0x000001d7, 0x00000002, 0x00050051, 0x00000027, 0x000001e0, 0x000001d7, 0x00000004, 0x00050051,
    0x00000137, 0x000001e2, 0x000001d7, 0x00000005, 0x00050051, 0x00000135, 0x000001e5, 0x000001e2, 0x00000000,
    0x00050041, 0x000001e6, 0x000001e7, 0x0000053d, 0x00000052, 0x00050051, 0x00000027, 0x000001e8, 0x000001e5,
    0x00000000, 0x00050041, 0x00000028, 0x000001e9, 0x000001e7, 0x00000052, 0x0003003e, 0x000001e9, 0x000001e8,
    0x00050051, 0x00000027, 0x000001ea, 0x000001e5, 0x00000001, 0x00050041, 0x00000028, 0x000001eb, 0x000001e7,
    0x00000054, 0x0003003e, 0x000001eb, 0x000001ea, 0x00050051, 0x00000027, 0x000001ec, 0x000001e5, 0x00000002,
    0x00050041, 0x00000028, 0x000001ed, 0x000001e7, 0x00000056, 0x0003003e, 0x000001ed, 0x000001ec, 0x00050051,
    0x00000027, 0x000001ee, 0x000001e5, 0x00000003, 0x00050041, 0x00000028, 0x000001ef, 0x000001e7, 0x0000003d,
    0x0003003e, 0x000001ef, 0x000001ee, 0x00050051, 0x00000135, 0x000001f0, 0x000001e2, 0x00000001, 0x00050041,
    0x000001e6, 0x000001f1, 0x0000053d, 0x00000054, 0x00050051, 0x00000027, 0x000001f2, 0x000001f0, 0x00000000,
    0x00050041, 0x00000028, 0x000001f3, 0x000001f1, 0x00000052, 0x0003003e, 0x000001f3, 0x000001f2, 0x00050051,
    0x00000027, 0x000001f4, 0x000001f0, 0x00000001, 0x00050041, 0x00000028, 0x000001f5, 0x000001f1, 0x00000054,
    0x0003003e, 0x000001f5, 0x000001f4, 0x00050051, 0x00000027, 0x000001f6, 0x000001f0, 0x00000002, 0x00050041,
    0x00000028, 0x000001f7, 0x000001f1, 0x00000056, 0x0003003e, 0x000001f7, 0x000001f6, 0x00050051, 0x00000027,
    0x000001f8, 0x000001f0, 0x00000003, 0x00050041, 0x00000028, 0x000001f9, 0x000001f1, 0x0000003d, 0x0003003e,
    0x000001f9, 0x000001f8, 0x00050051, 0x00000135, 0x000001fa, 0x000001e2, 0x00000002, 0x00050041, 0x000001e6,
    0x000001fb, 0x0000053d, 0x00000056, 0x00050051, 0x00000027, 0x000001fc, 0x000001fa, 0x00000000, 0x00050041,
    0x00000028, 0x000001fd, 0x000001fb, 0x00000052, 0x0003003e, 0x000001fd, 0x000001fc, 0x00050051, 0x00000027,
    0x000001fe, 0x000001fa, 0x00000001, 0x00050041, 0x00000028, 0x000001ff, 0x000001fb, 0x00000054, 0x0003003e,
    0x000001ff, 0x000001fe, 0x00050051, 0x00000027, 0x00000200, 0x000001fa, 0x00000002, 0x00050041, 0x00000028,
    0x00000201, 0x000001fb, 0x00000056, 0x0003003e, 0x00000201, 0x00000200, 0x00050051, 0x00000027, 0x00000202,
    0x000001fa, 0x00000003, 0x00050041, 0x00000028, 0x00000203, 0x000001fb, 0x0000003d, 0x0003003e, 0x00000203,
    0x00000202, 0x00050051, 0x00000135, 0x00000204, 0x000001e2, 0x00000003, 0x00050041, 0x000001e6, 0x00000205,
    0x0000053d, 0x0000003d, 0x00050051, 0x00000027, 0x00000206, 0x00000204, 0x00000000, 0x00050041, 0x00000028,
    0x00000207, 0x00000205, 0x00000052, 0x0003003e, 0x00000207, 0x00000206, 0x00050051, 0x00000027, 0x00000208,
    0x00000204, 0x00000001, 0x00050041, 0x00000028, 0x00000209, 0x00000205, 0x00000054, 0x0003003e, 0x00000209,
    0x00000208, 0x00050051, 0x00000027, 0x0000020a, 0x00000204, 0x00000002, 0x00050041, 0x00000028, 0x0000020b,
    0x00000205, 0x00000056, 0x0003003e, 0x0000020b, 0x0000020a, 0x00050051, 0x00000027, 0x0000020c, 0x00000204,
    0x00000003, 0x00050041, 0x00000028, 0x0000020d, 0x00000205, 0x0000003d, 0x0003003e, 0x0000020d, 0x0000020c,
    0x00050051, 0x00000135, 0x0000020e, 0x000001e2, 0x00000004, 0x00050041, 0x000001e6, 0x0000020f, 0x0000053d,
    0x0000003f, 0x00050051, 0x00000027, 0x00000210, 0x0000020e, 0x00000000, 0x00050041, 0x00000028, 0x00000211,
    0x0000020f, 0x00000052, 0x0003003e, 0x00000211, 0x00000210, 0x00050051, 0x00000027, 0x00000212, 0x0000020e,
    0x00000001, 0x00050041, 0x00000028, 0x00000213, 0x0000020f, 0x00000054, 0x0003003e, 0x00000213, 0x00000212,
    0x00050051, 0x00000027, 0x00000214, 0x0000020e, 0x00000002, 0x00050041, 0x00000028, 0x00000215, 0x0000020f,
    0x00000056, 0x0003003e, 0x00000215, 0x00000214, 0x00050051, 0x00000027, 0x00000216, 0x0000020e, 0x00000003,
    0x00050041, 0x00000028, 0x00000217, 0x0000020f, 0x0000003d, 0x0003003e, 0x00000217, 0x00000216, 0x00050051,
    0x00000135, 0x00000218, 0x000001e2, 0x00000005, 0x00050041, 0x000001e6, 0x00000219, 0x0000053d, 0x00000041,
    0x00050051, 0x00000027, 0x0000021a, 0x00000218, 0x00000000, 0x00050041, 0x00000028, 0x0000021b, 0x00000219,
    0x00000052, 0x0003003e, 0x0000021b, 0x0000021a, 0x00050051, 0x00000027, 0x0000021c, 0x00000218, 0x00000001,
    0x00050041, 0x00000028, 0x0000021d, 0x00000219, 0x00000054, 0x0003003e, 0x0000021d, 0x0000021c, 0x00050051,
    0x00000027, 0x0000021e, 0x00000218, 0x00000002, 0x00050041, 0x00000028, 0x0000021f, 0x00000219, 0x00000056,
    0x0003003e, 0x0000021f, 0x0000021e, 0x00050051, 0x00000027, 0x00000220, 0x00000218, 0x00000003, 0x00050041,
    0x00000028, 0x00000221, 0x00000219, 0x0000003d, 0x0003003e, 0x00000221, 0x00000220, 0x00050051, 0x00000135,
    0x00000222, 0x000001e2, 0x00000006, 0x00050041, 0x000001e6, 0x00000223, 0x0000053d, 0x00000043, 0x00050051,
    0x00000027, 0x00000224, 0x00000222, 0x00000000, 0x00050041, 0x00000028, 0x00000225, 0x00000223, 0x00000052,
    0x0003003e, 0x00000225, 0x00000224, 0x00050051, 0x00000027, 0x00000226, 0x00000222, 0x00000001, 0x00050041,
    0x00000028, 0x00000227, 0x00000223, 0x00000054, 0x0003003e, 0x00000227, 0x00000226, 0x00050051, 0x00000027,
    0x00000228, 0x00000222, 0x00000002, 0x00050041, 0x00000028, 0x00000229, 0x00000223, 0x00000056, 0x0003003e,
    0x00000229, 0x00000228, 0x00050051, 0x00000027, 0x0000022a, 0x00000222, 0x00000003, 0x00050041, 0x00000028,
    0x0000022b, 0x00000223, 0x0000003d, 0x0003003e, 0x0000022b, 0x0000022a, 0x00050051, 0x00000135, 0x0000022c,
    0x000001e2, 0x00000007, 0x00050041, 0x000001e6, 0x0000022d, 0x0000053d, 0x00000047, 0x00050051, 0x00000027,
    0x0000022e, 0x0000022c, 0x00000000, 0x00050041, 0x00000028, 0x0000022f, 0x0000022d, 0x00000052, 0x0003003e,
    0x0000022f, 0x0000022e, 0x00050051, 0x00000027, 0x00000230, 0x0000022c, 0x00000001, 0x00050041, 0x00000028,
    0x00000231, 0x0000022d, 0x00000054, 0x0003003e, 0x00000231, 0x00000230, 0x00050051, 0x00000027, 0x00000232,
    0x0000022c, 0x00000002, 0x00050041, 0x00000028, 0x00000233, 0x0000022d, 0x00000056, 0x0003003e, 0x00000233,
    0x00000232, 0x00050051, 0x00000027, 0x00000234, 0x0000022c, 0x00000003, 0x00050041, 0x00000028, 0x00000235,
    0x0000022d, 0x0000003d, 0x0003003e, 0x00000235, 0x00000234, 0x00060041, 0x00000237, 0x00000238, 0x00000141,
    0x00000052, 0x00000052, 0x0004003d, 0x00000126, 0x00000239, 0x00000238, 0x00070050, 0x00000007, 0x00000425,
    0x0000019c, 0x0000019e, 0x000001a0, 0x000001a2, 0x00060050, 0x00000008, 0x00000429, 0x000001a4, 0x000001a6,
    0x000001a8, 0x00050085, 0x00000008, 0x0000042c, 0x000001d8, 0x00000429, 0x0008004f, 0x00000008, 0x00000435,
    0x00000425, 0x00000425, 0x00000000, 0x00000001, 0x00000002, 0x0007000c, 0x00000008, 0x00000437, 0x00000001,
    0x00000044, 0x00000435, 0x0000042c, 0x0005008e, 0x00000008, 0x00000439, 0x0000042c, 0x000001a2, 0x00050081,
    0x00000008, 0x0000043a, 0x00000437, 0x00000439, 0x0007000c, 0x00000008, 0x0000043b, 0x00000001, 0x00000044,
    0x00000435, 0x0000043a, 0x0005008e, 0x00000008, 0x0000043c, 0x0000043b, 0x0000002e, 0x00050081, 0x00000008,
    0x0000043d, 0x0000042c, 0x0000043c, 0x00060050, 0x00000008, 0x00000431, 0x00000196, 0x00000198, 0x0000019a,
    0x00050081, 0x00000008, 0x00000432, 0x0000043d, 0x00000431, 0x00050051, 0x00000006, 0x0000023f, 0x00000432,
    0x00000000, 0x00050051, 0x00000006, 0x00000240, 0x00000432, 0x00000001, 0x00050051, 0x00000006, 0x00000241,
    0x00000432, 0x00000002, 0x00070050, 0x00000007, 0x00000242, 0x0000023f, 0x00000240, 0x00000241, 0x000000ad,
    0x00050091, 0x00000007, 0x00000243, 0x00000239, 0x00000242, 0x0008004f, 0x00000008, 0x00000244, 0x00000243,
    0x00000243, 0x00000000, 0x00000001, 0x00000002, 0x0003003e, 0x00000236, 0x00000244, 0x0006000c, 0x00000006,
    0x0000024a, 0x00000001, 0x00000004, 0x000001a4, 0x0006000c, 0x00000006, 0x0000024d, 0x00000001, 0x00000004,
    0x000001a6, 0x0007000c, 0x00000006, 0x0000024e, 0x00000001, 0x00000028, 0x0000024a, 0x0000024d, 0x0006000c,
    0x00000006, 0x00000251, 0x00000001, 0x00000004, 0x000001a8, 0x0007000c, 0x00000006, 0x00000252, 0x00000001,
    0x00000028, 0x0000024e, 0x00000251, 0x00050085, 0x00000006, 0x00000253, 0x000001da, 0x00000252, 0x0003003e,
    0x00000257, 0x00000244, 0x00060041, 0x0000025c, 0x0000025d, 0x00000141, 0x00000052, 0x0000003d, 0x0004003d,
    0x00000006, 0x0000025e, 0x0000025d, 0x00060041, 0x0000025c, 0x00000260, 0x00000141, 0x00000052, 0x00000054,
    0x0004003d, 0x00000006, 0x00000261, 0x00000260, 0x00060041, 0x0000025c, 0x00000263, 0x00000141, 0x00000052,
    0x00000056, 0x0004003d, 0x00000006, 0x00000264, 0x00000263, 0x000300f7, 0x000004c8, 0x00000000, 0x000300fb,
    0x00000063, 0x0000044a, 0x000200f8, 0x0000044a, 0x00050041, 0x00000015, 0x0000044b, 0x00000257, 0x0000005c,
    0x0004003d, 0x00000006, 0x0000044c, 0x0000044b, 0x0004007f, 0x00000006, 0x0000044d, 0x0000044c, 0x00050081,
    0x00000006, 0x00000450, 0x00000253, 0x0000025e, 0x000500b8, 0x00000017, 0x00000451, 0x0000044d, 0x00000450,
    0x000300f7, 0x00000453, 0x00000000, 0x000400fa, 0x00000451, 0x00000452, 0x00000453, 0x000200f8, 0x00000452,
    0x000200f9, 0x000004c8, 0x000200f8, 0x00000453, 0x00050041, 0x00000015, 0x00000454, 0x00000257, 0x00000063,
    0x0004003d, 0x00000006, 0x00000455, 0x00000454, 0x0004007f, 0x00000006, 0x00000456, 0x00000455, 0x0004003d,
    0x00000006, 0x00000458, 0x0000044b, 0x00050050, 0x0000008e, 0x00000459, 0x00000456, 0x00000458, 0x00050094,
    0x00000006, 0x0000045c, 0x00000459, 0x00000459, 0x00050085, 0x00000006, 0x0000045f, 0x00000253, 0x00000253,
    0x00050083, 0x00000006, 0x00000460, 0x0000045c, 0x0000045f, 0x0006000c, 0x00000006, 0x00000461, 0x00000001,
    0x0000001f, 0x00000460, 0x00050050, 0x0000008e, 0x00000463, 0x00000461, 0x00000253, 0x0003003e, 0x00000441,
    0x00000463, 0x00050041, 0x00000015, 0x00000464, 0x00000441, 0x00000063, 0x0004003d, 0x00000006, 0x00000465,
    0x00000464, 0x00050041, 0x00000015, 0x00000466, 0x00000441, 0x0000005f, 0x0004003d, 0x00000006, 0x00000467,
    0x00000466, 0x0004003d, 0x00000006, 0x00000469, 0x00000466, 0x0004007f, 0x00000006, 0x0000046a, 0x00000469,
    0x0004003d, 0x00000006, 0x0000046c, 0x00000464, 0x00050050, 0x0000008e, 0x0000046d, 0x00000465, 0x00000467,
    0x00050050, 0x0000008e, 0x0000046e, 0x0000046a, 0x0000046c, 0x00050050, 0x000000ac, 0x0000046f, 0x0000046d,
    0x0000046e, 0x00050091, 0x0000008e, 0x00000471, 0x0000046f, 0x00000459, 0x0003003e, 0x00000442, 0x00000471,
    0x0004003d, 0x00000006, 0x00000473, 0x00000464, 0x0004003d, 0x00000006, 0x00000475, 0x00000466, 0x0004007f,
    0x00000006, 0x00000476, 0x00000475, 0x0004003d, 0x00000006, 0x00000478, 0x00000466, 0x0004003d, 0x00000006,
    0x0000047a, 0x00000464, 0x00050050, 0x0000008e, 0x0000047b, 0x00000473, 0x00000476, 0x00050050, 0x0000008e,
    0x0000047c, 0x00000478, 0x0000047a, 0x00050050, 0x000000ac, 0x0000047d, 0x0000047b, 0x0000047c, 0x00050091,
    0x0000008e, 0x0000047f, 0x0000047d, 0x00000459, 0x0003003e, 0x00000443, 0x0000047f, 0x0007004f, 0x0000008e,
    0x00000481, 0x00000243, 0x00000570, 0x00000001, 0x00000002, 0x00050094, 0x00000006, 0x00000484, 0x00000481,
    0x00000481, 0x00050083, 0x00000006, 0x00000488, 0x00000484, 0x0000045f, 0x0006000c, 0x00000006, 0x00000489,
    0x00000001, 0x0000001f, 0x00000488, 0x00050050, 0x0000008e, 0x0000048b, 0x00000489, 0x00000253, 0x0003003e,
    0x00000445, 0x0000048b, 0x00050041, 0x00000015, 0x0000048c, 0x00000445, 0x00000063, 0x0004003d, 0x00000006,
    0x0000048d, 0x0000048c, 0x00050041, 0x00000015, 0x0000048e, 0x00000445, 0x0000005f, 0x0004003d, 0x00000006,
    0x0000048f, 0x0000048e, 0x0004003d, 0x00000006, 0x00000491, 0x0000048e, 0x0004007f, 0x00000006, 0x00000492,
    0x00000491, 0x0004003d, 0x00000006, 0x00000494, 0x0000048c, 0x00050050, 0x0000008e, 0x00000495, 0x0000048d,
    0x0000048f, 0x00050050, 0x0000008e, 0x00000496, 0x00000492, 0x00000494, 0x00050050, 0x000000ac, 0x00000497,
    0x00000495, 0x00000496, 0x00050091, 0x0000008e, 0x00000499, 0x00000497, 0x00000481, 0x0003003e, 0x00000446,
    0x00000499, 0x0004003d, 0x00000006, 0x0000049b, 0x0000048c, 0x0004003d, 0x00000006, 0x0000049d, 0x0000048e,
    0x0004007f, 0x00000006, 0x0000049e, 0x0000049d, 0x0004003d, 0x00000006, 0x000004a0, 0x0000048e, 0x0004003d,
    0x00000006, 0x000004a2, 0x0000048c, 0x00050050, 0x0000008e, 0x000004a3, 0x0000049b, 0x0000049e, 0x00050050,
    0x0000008e, 0x000004a4, 0x000004a0, 0x000004a2, 0x00050050, 0x000000ac, 0x000004a5, 0x000004a3, 0x000004a4,
    0x00050091, 0x0000008e, 0x000004a7, 0x000004a5, 0x00000481, 0x0003003e, 0x00000447, 0x000004a7, 0x00050041,
    0x00000015, 0x000004a8, 0x00000442, 0x00000063, 0x0004003d, 0x00000006, 0x000004a9, 0x000004a8, 0x00050041,
    0x00000015, 0x000004aa, 0x00000442, 0x0000005f, 0x0004003d, 0x00000006, 0x000004ab, 0x000004aa, 0x00050088,
    0x00000006, 0x000004ac, 0x000004a9, 0x000004ab, 0x00050085, 0x00000006, 0x000004ae, 0x000004ac, 0x00000261,
    0x00050041, 0x00000015, 0x000004af, 0x00000446, 0x00000063, 0x0004003d, 0x00000006, 0x000004b0, 0x000004af,
    0x00050041, 0x00000015, 0x000004b1, 0x00000446, 0x0000005f, 0x0004003d, 0x00000006, 0x000004b2, 0x000004b1,
    0x00050088, 0x00000006, 0x000004b3, 0x000004b0, 0x000004b2, 0x00050085, 0x00000006, 0x000004b5, 0x000004b3,
    0x00000264, 0x00050041, 0x00000015, 0x000004b6, 0x00000443, 0x00000063, 0x0004003d, 0x00000006, 0x000004b7,
    0x000004b6, 0x00050041, 0x00000015, 0x000004b8, 0x00000443, 0x0000005f, 0x0004003d, 0x00000006, 0x000004b9,
    0x000004b8, 0x00050088, 0x00000006, 0x000004ba, 0x000004b7, 0x000004b9, 0x00050085, 0x00000006, 0x000004bc,
    0x000004ba, 0x00000261, 0x00050041, 0x00000015, 0x000004bd, 0x00000447, 0x00000063, 0x0004003d, 0x00000006,
    0x000004be, 0x000004bd, 0x00050041, 0x00000015, 0x000004bf, 0x00000447, 0x0000005f, 0x0004003d, 0x00000006,
    0x000004c0, 0x000004bf, 0x00050088, 0x00000006, 0x000004c1, 0x000004be, 0x000004c0, 0x00050085, 0x00000006,
    0x000004c3, 0x000004c1, 0x00000264, 0x00070050, 0x00000007, 0x000004c4, 0x000004ae, 0x000004b5, 0x000004bc,
    0x000004c3, 0x00050085, 0x00000007, 0x000004c6, 0x000004c4, 0x0000010f, 0x00050081, 0x00000007, 0x000004c7,
    0x000004c6, 0x00000111, 0x000200f9, 0x000004c8, 0x000200f8, 0x000004c8, 0x000700f5, 0x00000007, 0x00000573,
    0x00000574, 0x00000452, 0x000004c7, 0x00000453, 0x000700f5, 0x00000017, 0x00000572, 0x0000008c, 0x00000452,
    0x00000113, 0x00000453, 0x0003003e, 0x00000256, 0x00000573, 0x0007004f, 0x0000008e, 0x0000026a, 0x00000573,
    0x00000573, 0x00000002, 0x00000003, 0x0007004f, 0x0000008e, 0x0000026c, 0x00000573, 0x00000573, 0x00000000,
    0x00000001, 0x00050083, 0x0000008e, 0x0000026d, 0x0000026a, 0x0000026c, 0x0003003e, 0x00000268, 0x0000026d,
    0x00060041, 0x00000142, 0x0000026e, 0x00000141, 0x00000052, 0x00000170, 0x0004003d, 0x00000027, 0x0000026f,
    0x0000026e, 0x000500ab, 0x00000017, 0x00000270, 0x0000026f, 0x00000063, 0x000300f7, 0x00000272, 0x00000000,
    0x000400fa, 0x00000270, 0x00000271, 0x00000272, 0x000200f8, 0x00000271, 0x000300f7, 0x00000275, 0x00000000,
    0x000400fa, 0x00000113, 0x00000274, 0x00000275, 0x000200f8, 0x00000274, 0x0003003e, 0x00000276, 0x00000244,
    0x00060041, 0x0000027b, 0x0000027c, 0x00000141, 0x00000052, 0x00000041, 0x0004003d, 0x00000007, 0x0000027d,
    0x0000027c, 0x0003003e, 0x0000027a, 0x0000027d, 0x00050041, 0x00000015, 0x000004cc, 0x00000276, 0x0000005c,
    0x0004003d, 0x00000006, 0x000004cd, 0x000004cc, 0x00050041, 0x00000015, 0x000004ce, 0x0000027a, 0x0000005f,
    0x0004003d, 0x00000006, 0x000004cf, 0x000004ce, 0x00050085, 0x00000006, 0x000004d0, 0x000004cd, 0x000004cf,
    0x00050041, 0x00000015, 0x000004d1, 0x00000276, 0x00000063, 0x0004003d, 0x00000006, 0x000004d2, 0x000004d1,
    0x0006000c, 0x00000006, 0x000004d3, 0x00000001, 0x00000004, 0x000004d2, 0x00050041, 0x00000015, 0x000004d4,
    0x0000027a, 0x00000063, 0x0004003d, 0x00000006, 0x000004d5, 0x000004d4, 0x00050085, 0x00000006, 0x000004d6,
    0x000004d3, 0x000004d5, 0x00050083, 0x00000006, 0x000004d7, 0x000004d0, 0x000004d6, 0x0004007f, 0x00000006,
    0x000004d9, 0x00000253, 0x000500ba, 0x00000017, 0x000004da, 0x000004d7, 0x000004d9, 0x000300f7, 0x000004eb,
    0x00000000, 0x000400fa, 0x000004da, 0x000004db, 0x000004eb, 0x000200f8, 0x000004db, 0x0004003d, 0x00000006,
    0x000004dd, 0x000004cc, 0x0004007f, 0x00000006, 0x000004de, 0x000004dd, 0x00050041, 0x00000015, 0x000004df,
    0x0000027a, 0x00000032, 0x0004003d, 0x00000006, 0x000004e0, 0x000004df, 0x00050085, 0x00000006, 0x000004e1,
    0x000004de, 0x000004e0, 0x00050041, 0x00000015, 0x000004e2, 0x00000276, 0x0000005f, 0x0004003d, 0x00000006,
    0x000004e3, 0x000004e2, 0x0006000c, 0x00000006, 0x000004e4, 0x00000001, 0x00000004, 0x000004e3, 0x00050041,
    0x00000015, 0x000004e5, 0x0000027a, 0x0000005c, 0x0004003d, 0x00000006, 0x000004e6, 0x000004e5, 0x00050085,
    0x00000006, 0x000004e7, 0x000004e4, 0x000004e6, 0x00050083, 0x00000006, 0x000004e8, 0x000004e1, 0x000004e7,
    0x000500b8, 0x00000017, 0x000004ea, 0x000004e8, 0x00000253, 0x000200f9, 0x000004eb, 0x000200f8, 0x000004eb,
    0x000700f5, 0x00000017, 0x000004ec, 0x000004da, 0x00000274, 0x000004ea, 0x000004db, 0x000400a8, 0x00000017,
    0x000004ed, 0x000004ec, 0x000400a8, 0x00000017, 0x0000027f, 0x000004ed, 0x000200f9, 0x00000275, 0x000200f8,
    0x00000275, 0x000700f5, 0x00000017, 0x00000280, 0x00000113, 0x00000271, 0x0000027f, 0x000004eb, 0x000400a8,
    0x00000017, 0x00000282, 0x00000280, 0x000300f7, 0x00000284, 0x00000000, 0x000400fa, 0x00000282, 0x00000283,
    0x00000284, 0x000200f8, 0x00000283, 0x00060041, 0x00000286, 0x00000287, 0x00000141, 0x00000052, 0x00000285,
    0x0004003d, 0x0000012b, 0x00000288, 0x00000287, 0x00060041, 0x00000289, 0x0000028a, 0x00000288, 0x00000052,
    0x00000054, 0x000700ea, 0x00000027, 0x0000028b, 0x0000028a, 0x0000005f, 0x00000063, 0x0000005f, 0x000200f9,
    0x00000284, 0x000200f8, 0x00000284, 0x000200f9, 0x00000272, 0x000200f8, 0x00000272, 0x000700f5, 0x00000017,
    0x00000576, 0x00000113, 0x000004c8, 0x00000280, 0x00000284, 0x000300f7, 0x0000028e, 0x00000000, 0x000400fa,
    0x00000576, 0x0000028d, 0x0000028e, 0x000200f8, 0x0000028d, 0x00060041, 0x00000142, 0x0000028f, 0x00000141,
    0x00000052, 0x00000176, 0x0004003d, 0x00000027, 0x00000290, 0x0000028f, 0x000500ab, 0x00000017, 0x00000291,
    0x00000290, 0x00000063, 0x000200f9, 0x0000028e, 0x000200f8, 0x0000028e, 0x000700f5, 0x00000017, 0x00000292,
    0x00000576, 0x00000272, 0x00000291, 0x0000028d, 0x000500a7, 0x00000017, 0x00000294, 0x00000292, 0x00000572,
    0x000300f7, 0x00000296, 0x00000000, 0x000400fa, 0x00000294, 0x00000295, 0x00000296, 0x000200f8, 0x00000295,
    0x00070041, 0x0000025c, 0x00000298, 0x00000141, 0x00000052, 0x0000016d, 0x00000063, 0x0004003d, 0x00000006,
    0x00000299, 0x00000298, 0x00050088, 0x00000006, 0x0000029a, 0x000000ad, 0x00000299, 0x000300f7, 0x0000029d,
    0x00000000, 0x000400fa, 0x00000576, 0x0000029c, 0x0000029d, 0x000200f8, 0x0000029c, 0x00050041, 0x00000015,
    0x0000029e, 0x00000268, 0x00000063, 0x0004003d, 0x00000006, 0x0000029f, 0x0000029e, 0x00050041, 0x00000015,
    0x000002a0, 0x00000268, 0x0000005f, 0x0004003d, 0x00000006, 0x000002a1, 0x000002a0, 0x0007000c, 0x00000006,
    0x000002a2, 0x00000001, 0x00000028, 0x0000029f, 0x000002a1, 0x000500be, 0x00000017, 0x000002a4, 0x000002a2,
    0x0000029a, 0x000200f9, 0x0000029d, 0x000200f8, 0x0000029d, 0x000700f5, 0x00000017, 0x000002a5, 0x00000576,
    0x00000295, 0x000002a4, 0x0000029c, 0x000400a8, 0x00000017, 0x000002a7, 0x000002a5, 0x000300f7, 0x000002a9,
    0x00000000, 0x000400fa, 0x000002a7, 0x000002a8, 0x000002a9, 0x000200f8, 0x000002a8, 0x00060041, 0x00000286,
    0x000002aa, 0x00000141, 0x00000052, 0x00000285, 0x0004003d, 0x0000012b, 0x000002ab, 0x000002aa, 0x00060041,
    0x00000289, 0x000002ac, 0x000002ab, 0x00000052, 0x0000003d, 0x000700ea, 0x00000027, 0x000002ad, 0x000002ac,
    0x0000005f, 0x00000063, 0x0000005f, 0x000200f9, 0x000002a9, 0x000200f8, 0x000002a9, 0x000200f9, 0x00000296,
    0x000200f8, 0x00000296, 0x000700f5, 0x00000017, 0x00000579, 0x00000576, 0x0000028e, 0x000002a5, 0x000002a9,
    0x000300f7, 0x000002b0, 0x00000000, 0x000400fa, 0x00000579, 0x000002af, 0x000002b0, 0x000200f8, 0x000002af,
    0x00060041, 0x00000142, 0x000002b1, 0x00000141, 0x00000052, 0x00000173, 0x0004003d, 0x00000027, 0x000002b2,
    0x000002b1, 0x000500ab, 0x00000017, 0x000002b3, 0x000002b2, 0x00000063, 0x000200f9, 0x000002b0, 0x000200f8,
    0x000002b0, 0x000700f5, 0x00000017, 0x000002b4, 0x00000579, 0x00000296, 0x000002b3, 0x000002af, 0x000500a7,
    0x00000017, 0x000002b6, 0x000002b4, 0x00000572, 0x000300f7, 0x000002b8, 0x00000000, 0x000400fa, 0x000002b6,
    0x000002b7, 0x000002b8, 0x000200f8, 0x000002b7, 0x00050041, 0x00000015, 0x000002ba, 0x00000268, 0x00000063,
    0x0004003d, 0x00000006, 0x000002bb, 0x000002ba, 0x00070041, 0x0000025c, 0x000002bc, 0x00000141, 0x00000052,
    0x0000016d, 0x00000063, 0x0004003d, 0x00000006, 0x000002bd, 0x000002bc, 0x00050085, 0x00000006, 0x000002be,
    0x000002bb, 0x000002bd, 0x00050041, 0x00000015, 0x000002c0, 0x00000268, 0x0000005f, 0x0004003d, 0x00000006,
    0x000002c1, 0x000002c0, 0x00070041, 0x0000025c, 0x000002c2, 0x00000141, 0x00000052, 0x0000016d, 0x0000005f,
    0x0004003d, 0x00000006, 0x000002c3, 0x000002c2, 0x00050085, 0x00000006, 0x000002c4, 0x000002c1, 0x000002c3,
    0x0007000c, 0x00000006, 0x000002c8, 0x00000001, 0x00000028, 0x000002be, 0x000002c4, 0x0006000c, 0x00000006,
    0x000002c9, 0x00000001, 0x0000001e, 0x000002c8, 0x0006000c, 0x00000006, 0x000002ca, 0x00000001, 0x00000008,
    0x000002c9, 0x0004003d, 0x000002cf, 0x000002d2, 0x000002d1, 0x00050081, 0x0000008e, 0x000002d7, 0x0000026c,
    0x0000026a, 0x0005008e, 0x0000008e, 0x000002d8, 0x000002d7, 0x0000010d, 0x00070058, 0x00000007, 0x000002da,
    0x000002d2, 0x000002d8, 0x00000002, 0x000002ca, 0x00050051, 0x00000006, 0x000002db, 0x000002da, 0x00000000,
    0x00050088, 0x00000006, 0x000002dc, 0x0000025e, 0x000002db, 0x00060041, 0x0000025c, 0x000002df, 0x00000141,
    0x00000052, 0x0000003f, 0x0004003d, 0x00000006, 0x000002e0, 0x000002df, 0x0008000c, 0x00000006, 0x000002e1,
    0x00000001, 0x0000002b, 0x000002dc, 0x0000025e, 0x000002e0, 0x00050041, 0x00000015, 0x000002e3, 0x00000236,
    0x0000005c, 0x0004003d, 0x00000006, 0x000002e4, 0x000002e3, 0x0004007f, 0x00000006, 0x000002e5, 0x000002e4,
    0x00050083, 0x00000006, 0x000002e7, 0x000002e5, 0x00000253, 0x000500bc, 0x00000017, 0x000002ea, 0x000002e7,
    0x000002e1, 0x000400a8, 0x00000017, 0x000002ec, 0x000002ea, 0x000300f7, 0x000002ee, 0x00000000, 0x000400fa,
    0x000002ec, 0x000002ed, 0x000002ee, 0x000200f8, 0x000002ed, 0x00060041, 0x00000286, 0x000002ef, 0x00000141,
    0x00000052, 0x00000285, 0x0004003d, 0x0000012b, 0x000002f0, 0x000002ef, 0x00060041, 0x00000289, 0x000002f1,
    0x000002f0, 0x00000052, 0x00000056, 0x000700ea, 0x00000027, 0x000002f2, 0x000002f1, 0x0000005f, 0x00000063,
    0x0000005f, 0x000200f9, 0x000002ee, 0x000200f8, 0x000002ee, 0x000200f9, 0x000002b8, 0x000200f8, 0x000002b8,
    0x000700f5, 0x00000017, 0x0000057b, 0x00000579, 0x000002b0, 0x000002ea, 0x000002ee, 0x000300f7, 0x000002f5,
    0x00000000, 0x000400fa, 0x0000057b, 0x000002f4, 0x000002f5, 0x000200f8, 0x000002f4, 0x00060041, 0x00000142,
    0x000002f6, 0x00000141, 0x00000052, 0x0000017c, 0x0004003d, 0x00000027, 0x000002f7, 0x000002f6, 0x000500ab,
    0x00000017, 0x000002f8, 0x000002f7, 0x00000063, 0x000200f9, 0x000002f5, 0x000200f8, 0x000002f5, 0x000700f5,
    0x00000017, 0x000002f9, 0x0000057b, 0x000002b8, 0x000002f8, 0x000002f4, 0x000300f7, 0x000002fb, 0x00000000,
    0x000400fa, 0x000002f9, 0x000002fa, 0x000002fb, 0x000200f8, 0x000002fa, 0x00050041, 0x00000015, 0x000002fd,
    0x00000256, 0x0000005c, 0x0004003d, 0x00000006, 0x000002fe, 0x000002fd, 0x00050041, 0x00000015, 0x000002ff,
    0x00000256, 0x00000063, 0x0004003d, 0x00000006, 0x00000300, 0x000002ff, 0x00050083, 0x00000006, 0x00000301,
    0x000002fe, 0x00000300, 0x00050041, 0x00000015, 0x00000302, 0x00000256, 0x00000032, 0x0004003d, 0x00000006,
    0x00000303, 0x00000302, 0x00050041, 0x00000015, 0x00000304, 0x00000256, 0x0000005f, 0x0004003d, 0x00000006,
    0x00000305, 0x00000304, 0x00050083, 0x00000006, 0x00000306, 0x00000303, 0x00000305, 0x00050085, 0x00000006,
    0x00000307, 0x00000301, 0x00000306, 0x00060041, 0x0000025c, 0x00000309, 0x00000141, 0x00000052, 0x00000047,
    0x0004003d, 0x00000006, 0x0000030a, 0x00000309, 0x00050088, 0x00000006, 0x0000030c, 0x0000030a, 0x00000307,
    0x0006000c, 0x00000006, 0x0000030d, 0x00000001, 0x0000001e, 0x0000030c, 0x00060041, 0x0000025c, 0x0000030e,
    0x00000141, 0x00000052, 0x00000049, 0x0004003d, 0x00000006, 0x0000030f, 0x0000030e, 0x0006000c, 0x00000006,
    0x00000310, 0x00000001, 0x0000001e, 0x0000030f, 0x00050088, 0x00000006, 0x00000311, 0x0000030d, 0x00000310,
    0x00060041, 0x00000142, 0x00000313, 0x00000141, 0x00000052, 0x0000004b, 0x0004003d, 0x00000027, 0x00000314,
    0x00000313, 0x000500ac, 0x00000017, 0x00000315, 0x00000314, 0x00000063, 0x000300f7, 0x00000318, 0x00000000,
    0x000400fa, 0x00000315, 0x00000317, 0x0000031e, 0x000200f8, 0x00000317, 0x0007000c, 0x00000027, 0x0000031d,
    0x00000001, 0x00000026, 0x00000314, 0x000001e0, 0x000200f9, 0x00000318, 0x000200f8, 0x0000031e, 0x000200f9,
    0x00000318, 0x000200f8, 0x00000318, 0x000700f5, 0x00000027, 0x0000057e, 0x0000031d, 0x00000317, 0x000001e0,
    0x0000031e, 0x00050082, 0x00000027, 0x00000322, 0x0000057e, 0x0000005f, 0x000300f7, 0x00000327, 0x00000000,
    0x000400fa, 0x00000572, 0x00000326, 0x0000032d, 0x000200f8, 0x00000326, 0x00050081, 0x00000006, 0x00000329,
    0x00000311, 0x000000ad, 0x0004006d, 0x00000027, 0x0000032a, 0x00000329, 0x0008000c, 0x00000027, 0x0000032c,
    0x00000001, 0x0000002c, 0x0000032a, 0x00000063, 0x00000322, 0x000200f9, 0x00000327, 0x000200f8, 0x0000032d,
    0x000200f9, 0x00000327, 0x000200f8, 0x00000327, 0x000700f5, 0x00000027, 0x0000057f, 0x0000032c, 0x00000326,
    0x00000063, 0x0000032d, 0x00050041, 0x000001e6, 0x0000053e, 0x0000053d, 0x0000057f, 0x0004003d, 0x000001ca,
    0x00000332, 0x0000053e, 0x00050051, 0x00000027, 0x00000544, 0x00000332, 0x00000000, 0x00050051, 0x00000027,
    0x00000545, 0x00000332, 0x00000001, 0x00050051, 0x00000027, 0x00000546, 0x00000332, 0x00000002, 0x00050051,
    0x00000027, 0x00000547, 0x00000332, 0x00000003, 0x0004007c, 0x0000003c, 0x00000335, 0x000001dc, 0x00060041,
    0x00000142, 0x00000342, 0x00000141, 0x00000052, 0x0000033d, 0x0004003d, 0x00000027, 0x00000343, 0x00000342,
    0x00050080, 0x00000027, 0x000004f2, 0x00000547, 0x00000343, 0x00050082, 0x00000027, 0x000004f3, 0x000004f2,
    0x0000005f, 0x00050086, 0x00000027, 0x000004f5, 0x000004f3, 0x00000343, 0x000200f9, 0x0000034f, 0x000200f8,
    0x0000034f, 0x000700f5, 0x00000027, 0x000005b2, 0x00000175, 0x00000327, 0x00000360, 0x00000350, 0x000700f5,
    0x00000027, 0x00000580, 0x00000063, 0x00000327, 0x00000363, 0x00000350, 0x000500b0, 0x00000017, 0x00000356,
    0x00000580, 0x0000057f, 0x000400f6, 0x00000351, 0x00000350, 0x00000000, 0x000400fa, 0x00000356, 0x00000350,
    0x00000351, 0x000200f8, 0x00000350, 0x00060041, 0x00000028, 0x0000053f, 0x0000053d, 0x00000580, 0x0000003d,
    0x0004003d, 0x00000027, 0x0000035b, 0x0000053f, 0x00050080, 0x00000027, 0x000004fb, 0x0000035b, 0x00000571,
    0x00050086, 0x00000027, 0x000004fd, 0x000004fb, 0x00000358, 0x00050080, 0x00000027, 0x00000360, 0x000005b2,
    0x000004fd, 0x00050080, 0x00000027, 0x00000363, 0x00000580, 0x00000054, 0x000200f9, 0x0000034f, 0x000200f8,
    0x00000351, 0x000200f9, 0x000002fb, 0x000200f8, 0x000002fb, 0x000700f5, 0x00000027, 0x00000611, 0x00000158,
    0x000002f5, 0x00000544, 0x00000351, 0x000700f5, 0x0000003c, 0x00000602, 0x0000015a, 0x000002f5, 0x00000335,
    0x00000351, 0x000700f5, 0x00000027, 0x000005f3, 0x0000015f, 0x000002f5, 0x000004f5, 0x00000351, 0x000700f5,
    0x00000027, 0x000005b5, 0x0000016f, 0x000002f5, 0x00000546, 0x00000351, 0x000700f5, 0x00000027, 0x000005a4,
    0x00000175, 0x000002f5, 0x000005b2, 0x00000351, 0x000700f5, 0x00000027, 0x00000595, 0x00000172, 0x000002f5,
    0x00000547, 0x00000351, 0x000700f5, 0x00000027, 0x00000586, 0x00000154, 0x000002f5, 0x00000545, 0x00000351,
    0x000600a9, 0x00000027, 0x0000064c, 0x000002f9, 0x0000005f, 0x00000161, 0x000600a9, 0x00000027, 0x0000064d,
    0x000002f9, 0x0000005f, 0x00000163, 0x000300f7, 0x00000366, 0x00000000, 0x000400fa, 0x0000057b, 0x00000365,
    0x00000366, 0x000200f8, 0x00000365, 0x00060041, 0x00000286, 0x00000367, 0x00000141, 0x00000052, 0x00000285,
    0x0004003d, 0x0000012b, 0x00000368, 0x00000367, 0x00060041, 0x00000289, 0x00000369, 0x00000368, 0x00000052,
    0x00000052, 0x000700ea, 0x00000027, 0x0000036a, 0x00000369, 0x0000005f, 0x00000063, 0x0000005f, 0x00060041,
    0x00000289, 0x0000036d, 0x00000368, 0x00000052, 0x0000003f, 0x00050086, 0x00000027, 0x00000370, 0x00000586,
    0x00000032, 0x000700ea, 0x00000027, 0x00000371, 0x0000036d, 0x0000005f, 0x00000063, 0x00000370, 0x00060041,
    0x00000289, 0x00000374, 0x00000368, 0x00000052, 0x00000041, 0x000700ea, 0x00000027, 0x00000377, 0x00000374,
    0x0000005f, 0x00000063, 0x00000595, 0x000400a8, 0x00000017, 0x0000037b, 0x00000166, 0x00060041, 0x0000037e,
    0x0000037f, 0x00000141, 0x00000052, 0x0000037d, 0x0004003d, 0x0000012a, 0x00000380, 0x0000037f, 0x00060041,
    0x00000289, 0x00000383, 0x00000380, 0x00000052, 0x00000178, 0x000700ea, 0x00000027, 0x00000384, 0x00000383,
    0x0000005f, 0x00000063, 0x0000005f, 0x00060041, 0x0000014d, 0x00000386, 0x00000141, 0x00000052, 0x00000385,
    0x0004003d, 0x00000127, 0x00000387, 0x00000386, 0x00050080, 0x00000027, 0x0000038b, 0x0000017b, 0x00000384,
    0x00060041, 0x00000151, 0x0000038d, 0x00000387, 0x00000052, 0x0000038b, 0x00050041, 0x00000289, 0x0000038f,
    0x0000038d, 0x00000052, 0x0005003e, 0x0000038f, 0x00000586, 0x00000002, 0x00000000, 0x00050041, 0x00000289,
    0x00000391, 0x0000038d, 0x00000054, 0x0005003e, 0x00000391, 0x00000156, 0x00000002, 0x00000004, 0x00050041,
    0x00000289, 0x00000393, 0x0000038d, 0x00000056, 0x0005003e, 0x00000393, 0x00000611, 0x00000002, 0x00000008,
    0x00050041, 0x00000395, 0x00000396, 0x0000038d, 0x0000003d, 0x0005003e, 0x00000396, 0x00000602, 0x00000002,
    0x00000004, 0x00050041, 0x00000289, 0x00000398, 0x0000038d, 0x0000003f, 0x0005003e, 0x00000398, 0x0000015d,
    0x00000002, 0x00000010, 0x00050041, 0x00000289, 0x0000039a, 0x0000038d, 0x00000041, 0x0005003e, 0x0000039a,
    0x000005f3, 0x00000002, 0x00000004, 0x00050041, 0x00000289, 0x0000039c, 0x0000038d, 0x00000043, 0x0005003e,
    0x0000039c, 0x0000064c, 0x00000002, 0x00000008, 0x00050041, 0x00000289, 0x0000039e, 0x0000038d, 0x00000047,
    0x0005003e, 0x0000039e, 0x0000064d, 0x00000002, 0x00000004, 0x000600a9, 0x00000027, 0x000003a0, 0x00000166,
    0x0000005f, 0x00000063, 0x00050041, 0x00000289, 0x000003a1, 0x0000038d, 0x00000049, 0x0005003e, 0x000003a1,
    0x000003a0, 0x00000002, 0x00000020, 0x000600a9, 0x00000027, 0x000003a3, 0x0000016a, 0x0000005f, 0x00000063,
    0x00050041, 0x00000289, 0x000003a4, 0x0000038d, 0x0000004b, 0x0005003e, 0x000003a4, 0x000003a3, 0x00000002,
    0x00000004, 0x00050041, 0x00000289, 0x000003a6, 0x0000038d, 0x0000016d, 0x0005003e, 0x000003a6, 0x0000016c,
    0x00000002, 0x00000008, 0x00050041, 0x00000289, 0x000003a8, 0x0000038d, 0x00000170, 0x0005003e, 0x000003a8,
    0x000005b5, 0x00000002, 0x00000004, 0x00050041, 0x00000289, 0x000003aa, 0x0000038d, 0x00000173, 0x0005003e,
    0x000003aa, 0x00000595, 0x00000002, 0x00000010, 0x00050041, 0x00000289, 0x000003ac, 0x0000038d, 0x00000176,
    0x0005003e, 0x000003ac, 0x000005a4, 0x00000002, 0x00000004, 0x00050041, 0x00000289, 0x000003ae, 0x0000038d,
    0x00000179, 0x0005003e, 0x000003ae, 0x00000178, 0x00000002, 0x00000008, 0x00050041, 0x00000289, 0x000003b0,
    0x0000038d, 0x0000017c, 0x0005003e, 0x000003b0, 0x0000017b, 0x00000002, 0x00000004, 0x000400a8, 0x00000017,
    0x000003b2, 0x0000037b, 0x000300f7, 0x000003b4, 0x00000000, 0x000400fa, 0x000003b2, 0x000003b3, 0x000003b4,
    0x000200f8, 0x000003b3, 0x00060041, 0x00000142, 0x000003b5, 0x00000141, 0x00000052, 0x00000179, 0x0004003d,
    0x00000027, 0x000003b6, 0x000003b5, 0x000500ab, 0x00000017, 0x000003b7, 0x000003b6, 0x00000063, 0x000300f7,
    0x000003b9, 0x00000000, 0x000400fa, 0x000003b7, 0x000003b8, 0x000003b9, 0x000200f8, 0x000003b8, 0x000500ac,
    0x00000017, 0x000003bc, 0x00000595, 0x00000063, 0x000200f9, 0x000003b9, 0x000200f8, 0x000003b9, 0x000700f5,
    0x00000017, 0x000003bd, 0x000003b7, 0x000003b3, 0x000003bc, 0x000003b8, 0x000200f9, 0x000003b4, 0x000200f8,
    0x000003b4, 0x000700f5, 0x00000017, 0x000003be, 0x0000037b, 0x00000365, 0x000003bd, 0x000003b9, 0x000300f7,
    0x000003c0, 0x00000000, 0x000400fa, 0x000003be, 0x000003bf, 0x000003c0, 0x000200f8, 0x000003bf, 0x000300f7,
    0x000003c4, 0x00000000, 0x000400fa, 0x000003b2, 0x000003c3, 0x000003c4, 0x000200f8, 0x000003c3, 0x00060041,
    0x00000142, 0x000003c5, 0x00000141, 0x00000052, 0x00000179, 0x0004003d, 0x00000027, 0x000003c6, 0x000003c5,
    0x000500ab, 0x00000017, 0x000003c7, 0x000003c6, 0x00000063, 0x000300f7, 0x000003c9, 0x00000000, 0x000400fa,
    0x000003c7, 0x000003c8, 0x000003c9, 0x000200f8, 0x000003c8, 0x00070041, 0x00000289, 0x000003cf, 0x0000014f,
    0x00000052, 0x00000124, 0x00000170, 0x0006003d, 0x00000027, 0x000003d0, 0x000003cf, 0x00000002, 0x00000004,
    0x000500ab, 0x00000017, 0x000003d1, 0x000005b5, 0x000003d0, 0x000200f9, 0x000003c9, 0x000200f8, 0x000003c9,
    0x000700f5, 0x00000017, 0x000003d2, 0x000003c7, 0x000003c3, 0x000003d1, 0x000003c8, 0x000200f9, 0x000003c4,
    0x000200f8, 0x000003c4, 0x000700f5, 0x00000017, 0x000003d3, 0x0000037b, 0x000003bf, 0x000003d2, 0x000003c9,
    0x00060041, 0x0000037e, 0x000003d7, 0x00000141, 0x00000052, 0x000003d6, 0x0004003d, 0x0000012a, 0x000003d8,
    0x000003d7, 0x00060041, 0x00000289, 0x000003db, 0x000003d8, 0x00000052, 0x00000178, 0x000700ea, 0x00000027,
    0x000003dc, 0x000003db, 0x0000005f, 0x00000063, 0x0000005f, 0x00060041, 0x0000014d, 0x000003de, 0x00000141,
    0x00000052, 0x000003dd, 0x0004003d, 0x00000127, 0x000003df, 0x000003de, 0x00050080, 0x00000027, 0x000003e3,
    0x0000017b, 0x000003dc, 0x00060041, 0x00000151, 0x000003e5, 0x000003df, 0x00000052, 0x000003e3, 0x00050041,
    0x00000289, 0x000003e7, 0x000003e5, 0x00000052, 0x0005003e, 0x000003e7, 0x00000586, 0x00000002, 0x00000000,
    0x00050041, 0x00000289, 0x000003e9, 0x000003e5, 0x00000054, 0x0005003e, 0x000003e9, 0x00000156, 0x00000002,
    0x00000004, 0x00050041, 0x00000289, 0x000003eb, 0x000003e5, 0x00000056, 0x0005003e, 0x000003eb, 0x00000611,
    0x00000002, 0x00000008, 0x00050041, 0x00000395, 0x000003ed, 0x000003e5, 0x0000003d, 0x0005003e, 0x000003ed,
    0x00000602, 0x00000002, 0x00000004, 0x00050041, 0x00000289, 0x000003ef, 0x000003e5, 0x0000003f, 0x0005003e,
    0x000003ef, 0x0000015d, 0x00000002, 0x00000010, 0x00050041, 0x00000289, 0x000003f1, 0x000003e5, 0x00000041,
    0x0005003e, 0x000003f1, 0x000005f3, 0x00000002, 0x00000004, 0x00050041, 0x00000289, 0x000003f3, 0x000003e5,
    0x00000043, 0x0005003e, 0x000003f3, 0x0000064c, 0x00000002, 0x00000008, 0x00050041, 0x00000289, 0x000003f5,
    0x000003e5, 0x00000047, 0x0005003e, 0x000003f5, 0x0000064d, 0x00000002, 0x00000004, 0x00050041, 0x00000289,
    0x000003f8, 0x000003e5, 0x00000049, 0x0005003e, 0x000003f8, 0x000003a0, 0x00000002, 0x00000020, 0x000600a9,
    0x00000027, 0x000003fa, 0x000003d3, 0x0000005f, 0x00000063, 0x00050041, 0x00000289, 0x000003fb, 0x000003e5,
    0x0000004b, 0x0005003e, 0x000003fb, 0x000003fa, 0x00000002, 0x00000004, 0x00050041, 0x00000289, 0x000003fd,
    0x000003e5, 0x0000016d, 0x0005003e, 0x000003fd, 0x0000016c, 0x00000002, 0x00000008, 0x00050041, 0x00000289,
    0x000003ff, 0x000003e5, 0x00000170, 0x0005003e, 0x000003ff, 0x000005b5, 0x00000002, 0x00000004, 0x00050041,
    0x00000289, 0x00000401, 0x000003e5, 0x00000173, 0x0005003e, 0x00000401, 0x00000595, 0x00000002, 0x00000010,
    0x00050041, 0x00000289, 0x00000403, 0x000003e5, 0x00000176, 0x0005003e, 0x00000403, 0x000005a4, 0x00000002,
    0x00000004, 0x00050041, 0x00000289, 0x00000405, 0x000003e5, 0x00000179, 0x0005003e, 0x00000405, 0x00000178,
    0x00000002, 0x00000008, 0x00050041, 0x00000289, 0x00000407, 0x000003e5, 0x0000017c, 0x0005003e, 0x00000407,
    0x0000017b, 0x00000002, 0x00000004, 0x000200f9, 0x000003c0, 0x000200f8, 0x000003c0, 0x000200f9, 0x00000366,
    0x000200f8, 0x00000366, 0x000600a9, 0x00000027, 0x0000040c, 0x0000057b, 0x0000005f, 0x00000063, 0x00070041,
    0x00000289, 0x0000040d, 0x0000014f, 0x00000052, 0x00000124, 0x00000049, 0x0005003e, 0x0000040d, 0x0000040c,
    0x00000002, 0x00000010, 0x00070041, 0x00000289, 0x00000413, 0x0000014f, 0x00000052, 0x00000124, 0x00000170,
    0x0005003e, 0x00000413, 0x000005b5, 0x00000002, 0x00000004, 0x000200f9, 0x00000415, 0x000200f8, 0x00000415,
    0x000100fd, 0x00010038
};

TEST_CASE("SPIRV", "[buffer_references]")
{
    // setting this to kDebugSeverity yields debug-output from parser
    gfxrecon::util::Log::Init(gfxrecon::util::Log::kInfoSeverity);

    gfxrecon::util::SpirVParsingUtil spirVParsingUtil;

    // parsing nullptr yields false
    REQUIRE(!spirVParsingUtil.ParseBufferReferences(nullptr, 0));

    REQUIRE(spirVParsingUtil.ParseBufferReferences(test_bda_spirv, sizeof(test_bda_spirv)));

    // there are 8 buffer-references in a uniform-buffer
    auto buffer_references = spirVParsingUtil.GetBufferReferenceInfos();
    REQUIRE(buffer_references.size() == 8);
    REQUIRE(buffer_references[0].source == gfxrecon::util::SpirVParsingUtil::BufferReferenceLocation::UNIFORM_BUFFER);
    REQUIRE(buffer_references[0].set == 0);
    REQUIRE(buffer_references[0].binding == 1);
    REQUIRE(buffer_references[0].buffer_offset == 144);

    REQUIRE(buffer_references[7].source == gfxrecon::util::SpirVParsingUtil::BufferReferenceLocation::UNIFORM_BUFFER);
    REQUIRE(buffer_references[7].set == 0);
    REQUIRE(buffer_references[7].binding == 1);
    REQUIRE(buffer_references[7].buffer_offset == 200);

    gfxrecon::util::Log::Release();
}
