.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtApp-Create-Shell XtVa-App-Create-Shell wid-get
.na
.TH XtAppCreateShell __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtAppCreateShell, XtVaAppCreateShell \- create top-level widget instance
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
Widget XtAppCreateShell(const char *\fIapplication_name\fP,
const char *\fIapplication_class\fP, WidgetClass \fIwidget_class\fP,
Display *\fIdisplay\fP, ArgList \fIargs\fP, Cardinal \fInum_args\fP);
.HP
Widget XtVaAppCreateShell(const char * \fIapplication_name\fP, const char *
\fIapplication_class\fP, WidgetClass \fIwidget_class\fP, Display
*\fIdisplay\fP, ...\^);
.SH ARGUMENTS
.IP \fIapplication_name\fP 1i
Specifies the name of the application instance.
.IP \fIapplication_class\fP 1i
Specifies the class name of this application, which 
usually is the generic name for all instances of this application.
.IP \fIwidget_class\fP 1i
Specifies the widget class that the application top-level widget should be.
.IP \fIdisplay\fP 1i
Specifies the display from which to get the resources.
.IP \fIargs\fP 1i
Specifies the argument list from which to get the resources.
.IP \fInum_args\fP 1i
Specifies the number of arguments in the argument list.
.IP \fI...\fP 1i
Specifies the variable argument list from which to get the resources.
.SH DESCRIPTION
The
.B XtAppCreateShell
function saves the specified application name and application class
for qualifying all widget resource specifiers.
The application name and application class are used as the left-most components
in all widget resource names for this application.
.B XtAppCreateShell
should be used to create a new logical application within a program
or to create a shell on another display.
In the first case,
it allows the specification of a new root in the resource hierarchy.
In the second case,
it uses the resource database associated with the other display.
.LP
Note that the widget returned by
.B XtAppCreateShell
has the \s-1WM_COMMAND\s+1
property set for session managers (see Chapter 4).
.SH "SEE ALSO"
XtCreateWidget(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
