#ifndef _LINUX_OOM_NOTIFIER_H
#define _LINUX_OOM_NOTIFIER_H


#ifdef debug
#undef dbg
#endif
#define dbg(format, arg...)					\
do {							\
		printk (KERN_DEBUG "Out of memory: " format "\n",	## arg);                        \
} while(0)

#ifdef warn
#undef warn
#endif
#define warn(format, arg...)					  \
do {							  \
		printk (KERN_WARNING "Out of memory: " format "\n", ## arg);                          \
} while(0)

#ifdef info
#undef info
#endif
#define info(format, arg...)					  \
do {							  \
		printk (KERN_INFO "Out of Memory: " format "\n", ## arg);                          \
} while(0)

#ifdef error
#undef error
#endif
#define error(format, arg...)					        \
do {							        \
		printk (KERN_ERR "Out of Memory: " format "\n",	## arg);                                \
} while(0)

int register_oom_notifier(struct notifier_block * nb);
int unregister_oom_notifier(struct notifier_block * nb);

#endif /* _LINUX_OOM_NOTIFIER_H */
