/*
 *  linux/fs/ext2/symlink.c
 *
 * Only fast symlinks left here - the rest is done by generic code. AV, 1999
 *
 * Copyright (C) 1992, 1993, 1994, 1995
 * Remy Card (card@masi.ibp.fr)
 * Laboratoire MASI - Institut Blaise Pascal
 * Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/fs/minix/symlink.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  ext2 symlink handling code
 */

#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <linux/ext2_xattr.h>

/* RSBAC */
#ifdef CONFIG_RSBAC_SYM_REDIR
#include <linux/slab.h>
#include <rsbac/adf.h>
#endif

static int ext2_readlink(struct dentry *dentry, char *buffer, int buflen)
{
	char *s = (char *)dentry->d_inode->u.ext2_i.i_data;
#ifdef CONFIG_RSBAC_SYM_REDIR
        char * rsbac_name;
        int res;

	/* copying is ugly, but we must not change the const */
	rsbac_name = __getname();
	if(!rsbac_name)
	  return -ENOMEM;
	strcpy(rsbac_name, s);
        rsbac_symlink_redirect(dentry, rsbac_name);
        res = vfs_readlink(dentry, buffer, buflen, rsbac_name);
        putname(rsbac_name);
        return res;
#else
	return vfs_readlink(dentry, buffer, buflen, s);
#endif
}

static int ext2_follow_link(struct dentry *dentry, struct nameidata *nd)
{
	char *s = (char *)dentry->d_inode->u.ext2_i.i_data;
#ifdef CONFIG_RSBAC_SYM_REDIR
        char * rsbac_name;
        int res;

	/* copying is ugly, but we must not change the const */
	rsbac_name = __getname();
	if(!rsbac_name)
	  return -ENOMEM;
	strcpy(rsbac_name, s);
        rsbac_symlink_redirect(dentry, rsbac_name);
        res = vfs_follow_link(nd, rsbac_name);
        putname(rsbac_name);
        return res;
#else
	return vfs_follow_link(nd, s);
#endif
}

struct inode_operations ext2_symlink_inode_operations = {
	readlink:	page_readlink,
	follow_link:	page_follow_link,
	setxattr:	ext2_setxattr,
	getxattr:	ext2_getxattr,
	listxattr:	ext2_listxattr,
	removexattr:	ext2_removexattr,
};

struct inode_operations ext2_fast_symlink_inode_operations = {
	readlink:	ext2_readlink,
	follow_link:	ext2_follow_link,
	setxattr:	ext2_setxattr,
	getxattr:	ext2_getxattr,
	listxattr:	ext2_listxattr,
	removexattr:	ext2_removexattr,
};
