#ifndef _FTPFS_H_
#define _FTPFS_H_

#include <linux/types.h>
#include <linux/in.h>

#define FTP_SUPER_MAGIC 0xFADE
#define FTP_VERSION 0x03

#define FTP_MAX_USER 64
#define FTP_MAX_PASS 64
#define FTP_MAX_LINE 255
#define FTP_MAXPATHLEN 1024

#include "ftpfs_debug.h"
#include "ftpfs_cache.h"


struct ftp_mount_data{
	int version;
	int force_own;
	int active;
	__kernel_uid_t uid;
	__kernel_gid_t gid;
	__kernel_mode_t file_mode;
	__kernel_mode_t dir_mode;
	char root[FTP_MAXPATHLEN];
	char mount_point[FTP_MAXPATHLEN];
};

struct ftp_sb_info{
	struct sockaddr_in address;
	struct ftp_mount_data mnt;
	char user[FTP_MAX_USER];
	char pass[FTP_MAX_PASS];
	struct semaphore sem;
	struct socket *ctrl_sock;
	struct socket *data_sock;
	struct ftp_dir_cache cache;
};

struct ftp_fattr{
	unsigned long 	f_ino;
	umode_t		f_mode;
	nlink_t		f_nlink;
	uid_t		f_uid;
	gid_t		f_gid;
	kdev_t		f_rdev;
	off_t		f_size;
	time_t		f_atime;
	time_t		f_mtime;
	time_t		f_ctime;
	unsigned long 	f_blksize;
	unsigned long	f_blocks;
};


#endif
