
/***************************************************************************
*
*   Copyright (c) 1998, 1999 Jeff V. Merkey
*   895 West Center Street
*   Orem, Utah  84057
*   jmerkey@utah-nac.org
*
*   This program is free software; you can redistribute it and/or modify it
*   under the terms of the GNU General Public License as published by the
*   Free Software Foundation, version 2, or any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You are free to modify and re-distribute this program in accordance
*   with the terms specified in the GNU Public License.  The copyright
*   contained in this code is required to be present in any derivative
*   works and you are required to provide the source code for this
*   program as part of any commercial or non-commercial distribution.
*   You are required to respect the rights of the Copyright holders
*   named within this code.
*
*   jmerkey@utah-nac.org is the official maintainer of
*   this code.  You are encouraged to report any bugs, problems, fixes,
*   suggestions, and comments about this software to jmerkey@utah-nac.org
*   or linux-kernel@vger.kernel.org.  New releases, patches, bug fixes, and
*   technical documentation can be found at www.kernel.org.  We will
*   periodically post new releases of this software to www.kernel.org
*   that contain bug fixes and enhanced capabilities.
*
*   Original Authorship      :
*      source code written by Jeff V. Merkey
*
*   Original Contributors    :
*      Jeff V. Merkey
*      Darren Major
*      
*
****************************************************************************
*
*
*   AUTHOR   :  Jeff V. Merkey (jmerkey@utah-nac.org)
*   FILE     :  SYMLINK.C
*   DESCRIP  :  NWFS Symbolic Link Code for Linux
*   DATE     :  June 24, 1999
*
*   This code was adapted from the Linux UMSDOS File system for nwfs.
*
***************************************************************************/

#include "globals.h"


struct inode_operations nwfs_symlink_inode_operations =
{
    readlink:	    page_readlink,
    follow_link:    page_follow_link,
    setattr:        nwfs_notify_change,
};

static int nwfs_symlink_readpage(struct file *file, struct page *page)
{
    register int length, ccode;
    register struct inode *inode = (struct inode *)page->mapping->host;
    BYTE *buf = (BYTE *) kmap(page);
    loff_t loffs = 0;
    extern int nwfs_read_file_link(struct inode *, BYTE *, int, loff_t *);

    length = inode->i_size;
    ccode = nwfs_read_file_link(inode, buf, length, &loffs);
    if (ccode != length)
    {
       SetPageError(page);
       kunmap(page);
       UnlockPage(page);
       return -EIO;
    }

    buf[length] = '\0';
    SetPageUptodate(page);
    kunmap(page);
    UnlockPage(page);

    return 0;
}

struct address_space_operations nwfs_symlink_aops =
{
    readpage:	nwfs_symlink_readpage,
};

