/******************************** */
/* Rule Set Based Access Control  */
/* Author and (c) 1999: Amon Ott  */
/* Helper functions for all parts */
/* Last modified:  05/Aug/99      */
/******************************** */

#ifndef __RSBAC_HELPER_H
#define __RSBAC_HELPER_H

#include <linux/types.h>
#include <rsbac/types.h>

char * inttostr(char[], int);

char * ulongtostr(char[], u_long);

/* convert u_long_long to binary string representation for MAC module */
char * u64tostrmac(char[], __u64);

#ifndef __KERNEL__
rsbac_uid_t get_user(char * name);

char * get_user_name(rsbac_uid_t user, char * name);

/* covert u_long_long to binary string representation for log array */
char * u64tostrlog(char[], __u64);
/* and back */
__u64 strtou64log(char[], __u64 *);

/* convert u_long_long to binary string representation for MAC module */
/* and back */
__u64 strtou64mac(char[], __u64 *);

/* covert u_long_long to binary string representation for RC module */
char * u64tostrrc(char[], __u64);
/* and back */
__u64 strtou64rc(char[], __u64 *);

/* covert u_long_long to binary string representation for RC module / rights */
char * u64tostrrcr(char[], __u64);
/* and back */
__u64 strtou64rcr(char[], __u64 *);

/* ACL back */
__u64 strtou64acl(char[], __u64 *);
#endif

/* covert u_long_long to binary string representation for ACL module */
char * u64tostracl(char[], __u64);

char * longtostr(char[], long);

#ifdef __KERNEL__
int rsbac_get_owner(rsbac_uid_t * user_p);

int rsbac_put_user(unsigned char *, unsigned char *, int);

int rsbac_get_user(unsigned char *, unsigned char *, int);

extern inline void clear_user_buf(char * ubuf, int len);

char * rsbac_getname(const char *);

void rsbac_putname(const char *);

void rsbac_get_attr_error(char * , enum rsbac_adf_request_t);
#endif

#endif
