#
#	MN_scheduler.pl
#
#	Mail-Net scheduler.
#	Handles MN_admin, MN_info, and MN_server.
#
#	Created: Sun Dec 13 04:35:49 1992
#	Last modified: Mon Dec 28 00:28:49 1992
#
#	@ arl // 1992
#

require		"$ARGV[0]/MN_config.pl";
require		"$ARGV[0]/MN_lib.pl";
require		"$ARGV[0]/MN_global.pl";
require		"$ARGV[0]/MN_digest.pl";

#	We are cheating to start the system:
#		* MN_admin & MN_info immediately
#		* MN_server after the first loop
#		* digest sending after the second loop
$COLLECTED_SERVER_SECONDS	= 3300;
#$COLLECTED_DIGEST_SECONDS	= 42600;
#$COLLECTED_DIGEST_SECONDS	= 28200;
$COLLECTED_DIGEST_SECONDS	= 21000;
$COLLECTED_ADMIN_SECONDS	= 300;
$COLLECTED_INFO_SECONDS		= 300;

$save_time  = 0;
$SIG{'INT'} = 'sig_handler';

sub
sig_handler
{
	local($sig) = @_;

#	Should read MN_config.pl file and evaluate it....

	return 0;
}

sub
CheckDigestCrashes
{
	local(@locks)	= ();
	local($channel)	= '';

	@files = `/bin/ls -rt $DIGEST_DIRECTORY`;
	foreach (@files)
	{
		if ( ! /.lock$/ )
		{
			next;
		}
		chop;
		push( @locks, $_ );
	}

	foreach (@locks)
	{
		($channel,$dummy) = split( /[.]/o );

		if ( -f $DIGEST_DIRECTORY . $channel . ".digest.body.out" )
		{
			$DEBUG && print $DIGEST_DIRECTORY, $channel,
				".digest.body.out exists\n";
			if ( -f $DIGEST_DIRECTORY . $channel . ".digest.body" )
			{
				next;
			}
		}
		if ( -f $DIGEST_DIRECTORY . $channel . ".digest.out" )
		{
			$DEBUG && print $DIGEST_DIRECTORY, $channel,
				".digest.out exists\n";
			if ( -f $DIGEST_DIRECTORY . $channel . ".digest" )
			{
				next;
			}
		}

		if ( -f $DIGEST_DIRECTORY . $channel . ".digest.lock" )
		{
#			Link digest body file again.
			link( $DIGEST_DIRECTORY . $channel .
				".digest.body.out",
				$DIGEST_DIRECTORY . $channel .
				".digest.body" );
			unlink( $DIGEST_DIRECTORY . $channel .
				".digest.body.out" );

#			Link digest file again.
			link( $DIGEST_DIRECTORY . $channel . ".digest.out",
				$DIGEST_DIRECTORY . $channel . ".digest" );
			unlink( $DIGEST_DIRECTORY . $channel . ".digest.out" );

#			Remove the lock file.
			unlink( $DIGEST_DIRECTORY . $channel .
				".digest.lock" );

			system( $SERVER_COMMAND . " " . @ARGV[0] . " " .
					@ARGV[1] . " " . @ARGV[2] . " " . 
					$DIGEST_DIRECTORY . $channel .
					".digest" );
			sleep( 30 );
		}
	}
}

sub
HandleTimes
{
	local($addcount) = pop(@_);

	$COLLECTED_SERVER_SECONDS += $addcount;
	$COLLECTED_DIGEST_SECONDS += $addcount;
	$COLLECTED_ADMIN_SECONDS += $addcount;
	$COLLECTED_INFO_SECONDS += $addcount;

	return 0;
}

#
#	main
#

setpgrp( 0, $$ );

chdir( @ARGV[1] );

$GL_WhoAmI = @ARGV[2];

while ( 1 )
{

#	Correct digest crashes
	$save_time = time;
	&CheckDigestCrashes();
	&HandleTimes( time - $save_time );

	if ( ( $COLLECTED_SERVER_SECONDS >= $SERVER_SECONDS ) ||
		( $COLLECTED_DIGEST_SECONDS >= $DIGEST_SECONDS ) )
	{
#		Time to run server queue.
		$save_time = time;
		&WriteLog( $LOG_FILENAME, $0, "starting MN_server" );
		@files = `/bin/ls -rt $SERVER_DIRECTORY`;
		foreach (@files)
		{
			chop;
			system( $SERVER_COMMAND . " " . @ARGV[0] . " " .
				@ARGV[1] . " " . @ARGV[2] . " " . 
				$SERVER_DIRECTORY . $_ );
			sleep( 5 );
		}
		$COLLECTED_SERVER_SECONDS = 0;
		&HandleTimes( time - $save_time );
	}

	if ( -f $FORCE_DIGESTS_OUT )
	{
		$COLLECTED_DIGEST_SECONDS = $DIGEST_SECONDS;
		unlink( $FORCE_DIGESTS_OUT );
	}

	if ( $COLLECTED_DIGEST_SECONDS >= $DIGEST_SECONDS )
	{
#		Time to run server queue.
		$save_time = time;
		&WriteLog( $LOG_FILENAME, $0, "sending digests out" );
		@files = `/bin/ls -rt $DIGEST_DIRECTORY`;
		foreach (@files)
		{
			if ( ! /.digest$/ )
			{
				next;
			}
			chop;
			system( $SERVER_COMMAND . " " . @ARGV[0] . " " .
				@ARGV[1] . " " . @ARGV[2] . " " . 
				$DIGEST_DIRECTORY . $_ );
			sleep( 30 );
		}
		$COLLECTED_DIGEST_SECONDS = 0;
		&HandleTimes( time - $save_time );
	}

	if ( $COLLECTED_ADMIN_SECONDS >= $ADMIN_SECONDS )
	{
#		Time to run admin queue.
		$save_time = time;
		&WriteLog( $LOG_FILENAME, $0, "starting MN_admin" );
		@files = `/bin/ls -rt $ADMIN_DIRECTORY`;
		foreach (@files)
		{
			chop;
			system( $ADMIN_COMMAND . " " . @ARGV[0] . " " .
				@ARGV[1] . " " . @ARGV[2] . " " . 
				$ADMIN_DIRECTORY . $_ );
			sleep( 10 );
		}
		$COLLECTED_ADMIN_SECONDS = 0;
		&HandleTimes( time - $save_time );
	}

	if ( $COLLECTED_INFO_SECONDS >= $INFO_SECONDS )
	{
#		Time to run info queue.
		$save_time = time;
		&WriteLog( $LOG_FILENAME, $0, "starting MN_info" );
		@files = `/bin/ls -rt $INFO_DIRECTORY`;
		foreach (@files)
		{
			chop;
			system( $INFO_COMMAND . " " . @ARGV[0] . " " .
				@ARGV[1] . " " . @ARGV[2] . " " . 
				$INFO_DIRECTORY . $_ );
			sleep( 10 );
		}
		$COLLECTED_INFO_SECONDS = 0;
		&HandleTimes( time - $save_time );
	}

	sleep( $BASIC_SLEEP );

	&HandleTimes( $BASIC_SLEEP );

}

exit( 0 );
