/* atm.h - general ATM declarations */
 
/* Written 1995 by Werner Almesberger, EPFL LRC */
 
 
#ifndef _LINUX_ATM_H
#define _LINUX_ATM_H

#define ATM_CELL_SIZE	    53	/* ATM cell size incl. header */
#define ATM_CELL_PAYLOAD    48	/* ATM payload size */
#define ATM_MAX_AAL5_PDU 65535	/* maximum AAL5 PDU payload */
#define ATM_MAX_CDV	  9999	/* maximum (default) CDV */

/*
 * The following items should be added to sys/socket.h aka linux/socket.h
 */

#define AF_ATMPVC	6		/* ATM PVCs */
#define AF_ATMSVC	7		/* ATM SVCs */

#define ATM_AAL0	0		/* "raw" ATM cells */
#define ATM_AAL1	1		/* AAL1 (CBR) */
#define ATM_AAL2	2		/* AAL2 (VBR) */
#define ATM_AAL34	3		/* AAL3/4 (data) */
#define ATM_AAL5	5		/* AAL5 (data) */
#define ATM_SAAL	12		/* signaling AAL */
#define	ATM_CLIP	16		/* Classical IP over ATM, RFC1577 */

/*
 * UGLY - there should only be one protocol family (PF_ATM) for both
 * address families. A quick glance at some kernel internals seems to
 * suggest to me that doing it the "right" way might involve some
 * swimming against the stream ...
 */

#define PF_ATMPVC	AF_ATMPVC
#define PF_ATMSVC	AF_ATMSVC

#define SOL_ATM		2
#define SOL_AAL		3

/* ATM layer (values used for flags must be 2^n) */
#define SO_SETCLP	1		/* set CLP bit value - TODO */
#define SO_CIRANGE	3		/* connection identifier range;
					   socket must be bound or connected */

/* AAL layer (values used for flags must be 2^n) */
#define SO_TIMESTAMP	1		/* enable/disable RX timestamping */
#define SO_GETTIMESTAMP	3		/* get RX timestamp */

/* socket layer */
#define SO_BCTXOPT	16		/* not ATM specific - will go */
#define SO_BCRXOPT	17		/*   somewhere else */


/* for SO_BCTXOPT and SO_BCRXOPT */

struct atm_buffconst {
	unsigned long	buf_fac;	/* buffer alignment factor */
	unsigned long	buf_off;	/* buffer alignment offset */
	unsigned long	size_fac;	/* buffer size factor */
	unsigned long	size_off;	/* buffer size offset */
	unsigned long	min_size;	/* minimum size */
	unsigned long	max_size;	/* maximum size, 0 = unlimited */
};


/* for SO_CIRANGE */

#define ATM_CI_MAX	-1		/* use maximum range of VPI/VCI */

struct atm_cirange {
	char	vpi_bits;		/* 1..8, ATM_CI_MAX (-1) for maximum */
	char	vci_bits;		/* 1..16, ATM_CI_MAX (-1) for maximum */
};

/*
 * The following items should stay in linux/atm.h, which should be linked to
 * netatm/atm.h
 */

/* Traffic description */

#define ATM_NONE	0		/* no traffic */
#define ATM_UBR		1
#define ATM_CBR		2
#define ATM_VBR		3
#define ATM_ABR		4

#define ATM_MAX_PCR	-1		/* maximum available PCR */

struct atm_trafprm {
	unsigned char	class;		/* traffic class (ATM_UBR, ...) */
	int		min_pcr;	/* maximum PCR in cells per second */
	int		max_cdv;	/* maximum CDV in cell slots */
	int		max_sdu;	/* maximum SDU in bytes */
};

/* PVC addressing */

#define ATM_ITF_ANY	-1		/* "magic" PVC address values */
#define ATM_VPI_ANY	-1
#define ATM_VCI_ANY	-1
#define ATM_VPI_UNSPEC	-1
#define ATM_VCI_UNSPEC	-1

struct sockaddr_atmpvc {
	unsigned short 	sap_family;	/* address family */
	struct {
		short	itf;		/* ATM interface */
		short	vpi;		/* VPI (only 8 bits at UNI) */
		int	vci;		/* VCI (only 16 bits at UNI) */
	}		sap_addr;	/* PVC address */
	struct atm_trafprm sap_txtp;	/* TX traffic parameters */
	struct atm_trafprm sap_rxtp;	/* TX traffic parameters */
};

/* SVC addressing - not used yet */

struct sockaddr_atmsvc {
    unsigned short 	family;		/* address family */
    unsigned char	pub[20];	/* public ATM address */
    unsigned char	prv[20];	/* private ATM address */
    /* unused addresses must be bzero'ed */
    /* should also include BLLI and BHLI; some might also want TNS */
};


/*
 * Some stuff for linux/sockios.h
 */

#define MAX_IF_NAME	10

#define SIOCSIFATMTCP	0x8982		/* set ATMTCP mode */

struct atmif_sioc {
    char name[MAX_IF_NAME+1];
};

#ifdef __KERNEL__

#include <linux/net.h>	/* struct net_proto */


void atmpvc_proto_init(struct net_proto *pro);
void atmsvc_proto_init(struct net_proto *pro);

#endif /* __KERNEL__ */

#endif
