/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   svc_info.h
*   
* Abstract:
*  This header file describes the information elements needed to support the
*  svc to connection manager interface.
*
* Authors:
*  JAD - John A. DeNisco
*
* Modification History:
*  Date       Name  Description 
*  26-Jan-95  JAD   Created.
*  21-Feb-95  JAD   Use trillium definitions directly.
*
* Description:
*  Generally the svc_info structures are used, to pass information to and
*  from the connection manager and the svc interface. The svc interface is
*  found in the modules svc_cm.h and cm_svc.h.
*
*/
#ifndef SVC_INFO_H
#define SVC_INFO_H

#include <linux/atm.h>

/* General constants */

#define SVC_SIZE_STRING_MED              32    /* token string size - medium */
#define SVC_ELEMENT_REPEAT_MAX            2    /* maximum repeated elements  */
#define REL_LOC_USER                      0    /* ref: 5.4.5.15 UNI 3.0      */

/* Cause Values */

#define CAUSE_RESOURCE_UNAVAIL           47
#define CAUSE_NORMAL                     31

/* Event Values */

#define EVENT_CALL_PROCEEDING             0
#define EVENT_CONN_ACK                    2
#define EVENT_UNKNOWN                     9

/* The following definitions describe error conditions in the CM that result */
/* in connection releases.  These values are used as input to                */
/* "svc_release_info_make". These values can not conflict with the cause     */
/* values in the UNI specification 5.4.5.15.                                 */

#define RECORD_NOT_FOUND_ON_STATUS_IND    (0x01 | 0x8000)
#define CONN_ID_MISSING                   (0x02 | 0x8000)
#define RECORD_NOT_FOUND_ON_CONN_CFM      (0x03 | 0x8000)
#define RECORD_NOT_FOUND_ON_REL_IND       (0x04 | 0x8000)
#define REJECT_SAP_MISMATCH               (0x05 | 0x8000)
#define CAUSE_QOS_CHECK_FAIL              (0x06 | 0x8000)
#define CONN_RSP_CALL_FAILED              (0x07 | 0x8000)

/* Type definitions */

typedef unsigned char EVENT_TYPE;
typedef long CALL_ID;
typedef short RST_REASON;
typedef long PORT_NUMBER;

/* Redefine some trilllium definitions the svc module needs */

/*++
 * CONN_INFO
 *
 * This structure contains all of the information needed to setup a a virtual
 * connection.
 *
 --*/
typedef struct {
  struct sockaddr_atmsvc addr;
  struct atm_blli blli;
  struct atm_qos conqos;
} CONN_INFO;


/*++
 * CONN_STATUS
 *
 * This structure contains status related to a virtual connection.
 *
 --*/
typedef struct {
  int status;
} CONN_STATUS;


/*++
 * RELEASE_INFO
 *
 *  Information used to release a virtual connection.
 *
 --*/
typedef int RELEASE_INFO;


/*++
 * DROP_PTY_INFO
 *
 *  Information used for a drop party from a virtual connection.
 *
 --*/
typedef int DROP_PTY_INFO;



/*++
 * =====================
 * = svcinit_conn_info =
 * =====================
 *
 * Overview:
 *  This function initilizes the connection information structure.
 *  Initilization simply involves setting all the present flags to 
 *  "not present".
 *
 * Arguments:
 *
 *  p_svc_conn_info - Pointer to the connection information.
 *
 * Returns:
 *
 * None
 *
 --*/

void svcinit_conn_info (CONN_INFO *p_svc_conn_info);

/*++
 * ==========================
 * = svc_release_info_make =
 * ==========================
 *
 * Overview:
 *  This function generates a RELEASE_INFO block appropriate to the indicated
 *  error condition.
 *
 * Arguments:
 *
 *  code           - Error Code.
 *  p_release_info - Pointer to the release information structure.
 *
 * Returns:
 *
 *  None
 *
 --*/

void svc_release_info_make (int           code,
                            RELEASE_INFO *p_release_info);

#endif /* SVC_INFO_H */
