/* arequipad.c - AREQUIPA demon */
 
/* Written 1996 by Werner Almesberger, EPFL-LRC */
 

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>

#include "atm.h"
#include "atmd.h"

#include "io.h"


#ifndef NULL
#define NULL ((void *) 0)
#endif


#define COMPONENT "AQD"


int debug;
int pretty = A2T_PRETTY | A2T_NAME;


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -b ] [ -d ] [ -l logfile ] [ -n ] \n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    int c,background;

    set_application("arequipad");
    set_verbosity(NULL,DIAG_INFO);
    background = 0;
    while ((c = getopt(argc,argv,"bdn")) != EOF)
	switch (c) {
	    case 'b':
		background = 1;
		break;
	    case 'd':
		set_verbosity(NULL,DIAG_DEBUG);
		debug = 1;
		break;
	    case 'l':
		set_logfile(optarg);
		break;
	    case 'n':
		pretty = A2T_PRETTY;
		break;
	    default:
		usage(argv[0]);
	}
    diag(COMPONENT,DIAG_INFO,"Linux Arequipa, version " VERSION);
    open_all();
    if (background) {
    	pid_t pid;
 
	pid = fork();
	if (pid < 0) diag(COMPONENT,DIAG_FATAL,"fork: %s",strerror(errno));
	if (pid) {
	    diag(COMPONENT,DIAG_DEBUG,"Backgrounding (PID %d)",pid);
	    exit(0);
	}
    }
    poll_loop();
    close_all();
    return 0;
}
