/* trace.c - Support functions for message tracing */
 
/* Written 1996 by Werner Almesberger, EPFL-LRC */
 

#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>

#include "atmd.h"

#include "trace.h"


typedef struct _entry {
    struct timeval time;
    void (*parse)(void *msg,int size);
    const char *comment;
    void *msg;
    int size;
    struct _entry *next;
} ENTRY;


int trace_size = 0;
static int current = 0;
ENTRY *first = NULL,*last = NULL;


static void append(const char *fmt,...)
{
    /* append to a growing string */
}


static void parse_text(void *msg,int size)
{
    append("%s\n",msg);
}


static void parse_q2931(void *msg,int size)
{
    /* set q_report and let qd_open do the work */
}


static void parse_kernel(void *msg,int size)
{
    /* print the message */
}


static void store(void (*parse)(void *msg,int size),const char *comment,
  void *msg,int size)
{
    ENTRY *entry;

    if (!trace_size) return;
    entry = alloc_t(ENTRY);
    (void) gettimeofday(&entry->time,NULL);
    entry->parse = parse;
    entry->comment = comment;
    entry->msg = msg;
    entry->size = size;
    entry->next = NULL;
    if (current >= trace_size) { /* handle trace_size < 1 (actually < 0) too */
	ENTRY *next;

	next = first->next;
	free(first->msg);
	free(first);
	if (first == last) last = NULL; /* someone set trace_size < 2 */
	first = next;
    }
    if (last) last->next = entry;
    else first = entry;
    last = entry;
}


void trace_msg(const char *msg)
{
    char *buf;

    buf = alloc(strlen(msg)+1);
    strcpy(buf,msg);
    store(&parse_text,"MESSAGE",buf,strlen(msg));
}


void trace_q2931(const char *comment,const void *msg,int size)
{
    void *buf;

    buf = alloc(size);
    memcpy(buf,msg,size);
    store(&parse_q2931,comment,buf,size);
}


void trace_kernel(const char *comment,const struct atmsvc_msg *msg,int size)
{
    struct atmsvc_msg *buf;

    buf = alloc(size);
    memcpy(buf,msg,size); /* DON'T use *buf = *msg; */
    store(&parse_kernel,comment,buf,size);
}


char *get_trace(void)
{
    static char msg[] = "Trace generation isn't implemented yet\n";

    return msg;
}
