# Default is UNI 3.0, for good reasons, see below.
#
STANDARDS=-DUNI30
#
# Note: some UNI 3.0 switches will show really strange behaviour if confronted
#	with using 3.1 signaling, so be sure to test your network *very*
#	carefully before permanently configuring machines to use UNI 3.1.
#
# STANDARDS=-DUNI31 -DALLOW_UNI30

CC=cc
CFLAGS_NOWARN=-g -DVERSION=\"`cat ../VERSION`\" $(INCLUDES) -I../lib
CFLAGS_NOOPT=$(CFLAGS_NOWARN) -Wall -Wshadow -Wpointer-arith -Wcast-align \
  -Wwrite-strings -Wstrict-prototypes -Wmissing-prototypes \
  #-Wmissing-declarations (gcc 2.6.x only) #-Wconversion (breaks inline)
CFLAGS_OPT=#-O
CFLAGS=$(CFLAGS_NOOPT) $(CFLAGS_OPT) $(CFLAGS_PRIVATE)
CFLAGS_LEX=$(CFLAGS_NOWARN) $(CFLAGS_OPT)
CFLAGS_YACC=$(CFLAGS_NOWARN) $(CFLAGS_OPT) -DYY_USE_CONST
LDFLAGS=
LDLIBS=-L../lib -latm -larequipa
YACC=bison -y -d #-v
INSTROOT=
INSTPREFIX=$(INSTROOT)/usr/local
INSTBOOTBIN=$(INSTPREFIX)/sbin
INSTUSRBIN=$(INSTPREFIX)/bin
INSTSYSBIN=$(INSTPREFIX)/sbin
INSTLIB=$(INSTROOT)/usr/lib
INSTHDR=$(INSTROOT)/usr/include
INSTMAN=$(INSTPREFIX)/man
INSTMAN1=$(INSTMAN)/man1
INSTMAN4=$(INSTMAN)/man4
INSTMAN8=$(INSTMAN)/man8

#
# Enable memory debugging if MPR is installed
#
ifeq (/usr/lib/libmpr.a,$(wildcard /usr/lib/libmpr.a))
CFLAGS += -DMEM_DEBUG
LDLIBS += -lmpr
endif

LINK.c = $(CC) $(LDFLAGS)

all:
		[ ! -r .checker ] || $(MAKE) clean
		$(MAKE) do_all

do_all:		$(BOOTPGMS) $(SYSPGMS) $(USRPGMS) $(PGMS)

checker:
		[ -r .checker ] || $(MAKE) clean
		$(MAKE) do_checker

do_checker:
		CC=checkergcc $(MAKE) -e do_all
		touch .checker

install:
		@process() { if [ ! -z "$$3" ]; then mode=$$1; dir=$$2; \
		  shift 2; echo "install -c -m $$mode $$* $$dir"; \
		  install -c -m $$mode $$* $$dir; fi }; \
		  process 0755 $(INSTBOOTBIN) $(BOOTPGMS); \
		  process 0755 $(INSTSYSBIN) $(SYSPGMS); \
		  process 0755 $(INSTUSRBIN) $(USRPGMS); \
		  process 0644 $(INSTLIB) $(GENLIBS); \
		  process 0644 $(INSTHDR) $(SYSHDR); \
		  process 0644 $(INSTMAN1) $(MAN1); \
		  process 0644 $(INSTMAN4) $(MAN4); \
		  process 0644 $(INSTMAN8) $(MAN8)

uninstall:
		@process() { if [ ! -z "$$2" ]; then dir=$$1; shift; \
		  echo "cd $$dir; rm -f $$*"; \
		  cd $$dir; echo rm -f $$*; fi }; \
		  process $(INSTBOOTBIN) $(BOOTPGMS); \
		  process $(INSTSYSBIN) $(SYSPGMS); \
		  process $(INSTUSRBIN) $(USRPGMS); \
		  process $(INSTLIB) $(GENLIBS); \
		  process $(INSTHDR) $(SYSHDR); \
		  process $(INSTMAN1) $(MAN1); \
		  process $(INSTMAN4) $(MAN4); \
		  process $(INSTMAN8) $(MAN8)

depend:
		$(CPP) -M *.c $(INCLUDES) -I../lib >.tmpdepend
		mv .tmpdepend .depend

clean:
		rm -f *.o core .checker y.tab.h y.tab.c lex.yy.c $(TRASH)

spotless:	clean
		rm -f $(BOOTPGMS) $(SYSPGMS) $(USRPGMS) $(PGMS) *.a .depend

lex.yy.o:	lex.yy.c y.tab.h
		$(CC) -c $(CFLAGS_LEX) lex.yy.c

y.tab.o:	y.tab.c
		$(CC) -c $(CFLAGS_YACC) y.tab.c

$(PGMS) dummy:	../lib/libatm.a

ifeq (.depend,$(wildcard .depend))
include .depend
endif
