%{
/* cfg.l - configuration language */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <linux/atm.h>

#include "atm.h"

#include "y.tab.h"


static int lineno = 1;
static int token; /* f@#%ing flex doesn't grok return after BEGIN */


void yyerror(const char *s);

%}

%s N
%s P

%%
			BEGIN(N);

<N>level		return TOK_LEVEL;
<N>debug			|
<N>debugging		return TOK_DEBUG;		/* obsolete */
<N>info			|
<N>information		|				/* obsolete */
<N>informational	return TOK_INFO;
<N>warn			|
<N>warning		return TOK_WARN;		/* obsolete */
<N>error		return TOK_ERROR;
<N>fatal		return TOK_FATAL;
<N>sig			|
<N>signaling		|				/* obsolete */
<N>signalling		return TOK_SIG;			/* obsolete */
<N>uni30		return TOK_UNI30;
<N>uni31		return TOK_UNI31;
<N>net			|				/* obsolete */
<N>network		return TOK_NET;
<N>saal			return TOK_SAAL;
<N>vc			|
<N>svc			return TOK_VC;			/* obsolete */
<N>io			return TOK_IO;
<N>itf			|
<N>interface		return TOK_ITF;			/* obsolete */
<N>vpci			return TOK_VPCI;
<N>pcr			return TOK_PCR;
<N>dump			{ BEGIN(P);
			  token = TOK_DUMP_DIR; }
<N>log			{ BEGIN(P);
			  token = TOK_LOGFILE; }
<N>trace		return TOK_TRACE;
<N>[0-9]+		{ char *end;
			  yylval.num = strtoul(yytext,&end,10);
			  if (*end) yyerror("invalid number");
			  return TOK_NUMBER; }
<N>[0-9]+\.[0-9]+(\.[0-9]+)? {
			  if (text2atm(yytext,(struct sockaddr *) &yylval.pvc,
			    sizeof(yylval.pvc),T2A_PVC) < 0)
			      yyerror("invalid signaling channel");
			  return TOK_PVC;
			}
<P>[^\t\n ]+		{ BEGIN(N);
			  yylval.str = strdup(yytext); /* tiny leak ... */
			  if (!yylval.str) {
				perror("strdup");
				exit(1);
			  }
			  return token; }
\n?[\t ]*		lineno += *yytext && *yytext == '\n';
#[^\n]*\n		lineno++;
<N>.			return *yytext;

%%

void yyerror(const char *s)
{
    fprintf(stderr,"line %d: %s near \"%s\"\n",lineno,s,yytext);
    exit(1);
}
