/* qgen.h - constructor/parser generator for Q.2931-like data structures */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 
 
#ifndef QGEN_H
#define QGEN_H

typedef enum { vt_id,vt_case,vt_multi,vt_length } VALUE_TYPE;

typedef struct {
    /* --- the following fields are initialized by the parser */
    VALUE_TYPE type;
    const char *id; /* for value-only and for default tag */
    struct _item *block; /* length */
    struct _tag *tags; /* case or multi */
    /* --- the following fields are initialized in the first phase */
    /* id of default tag */
} VALUE;

typedef struct _item {
    /* --- the following fields are initialized by the parser */
    const char *id;
    int size;
    int var_len;
    int pos; /* modified in the first phase */
    int flush;
    VALUE *value;
    struct _item *next;
    /* --- the following fields are initialized in the first phase */
    int item; /* item number */
    int jump; /* move by that many bytes before writing that field */
    int group; /* group number, only in first element of group */
    /* --- the following fields are initialized in the second phase */
    int has_required;
    /* --- the following fields are initialized in the third phase */
    int patch;
} ITEM;

typedef struct _tag {
    /* --- the following fields are initialized by the parser */
    const char *id;
    const char *value;
    ITEM *block;
    struct _tag *next;
    int deflt;
    /* --- the following fields are initialized in the first phase */
    int group;
    int pos;
    /* --- the following fields are initialized in the third phase */
    int patch;
} TAG;


void first(ITEM *def);
void second(ITEM *def);
void third(ITEM *def);

#endif
