/* second.c - Phase II, table generation */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>

#include "qgen.h"
#include "file.h"


static void dump_required(ITEM *start,ITEM *leader,int group)
{
    ITEM *walk;

    for (walk = start; walk; walk = walk->next)
	if (!walk->value) {
	    if (!leader->has_required) {
		to_c("static int required_%d[] = {\n",group);
		leader->has_required = 1;
	    }
	    to_c("    %d, /* %s */\n",walk->item,walk->id);
	}
	else if (walk->value->type == vt_length)
		dump_required(walk->value->block,leader,group);
    if (leader == start && leader && leader->has_required)
	to_c("    -1\n};\n\n");
}


static void find_required(ITEM *start)
{
    ITEM *walk;
    TAG *scan;

    for (walk = start; walk; walk = walk->next)
	if (walk->value) 
	    switch  (walk->value->type) {
		case vt_id:
		case vt_case:
		case vt_multi:
		    for (scan = walk->value->tags; scan; scan = scan->next)
			if (scan->block) {
			    scan->block->has_required = 0;
			    dump_required(scan->block,scan->block,scan->group);
			    find_required(scan->block);
			}
		    break;
		case vt_length:
		    find_required(walk->value->block);
		    break;
		default:
		    abort();
	    }
}


static void groups(ITEM *start,int group)
{
    ITEM *walk;
    TAG *scan;

    for (walk = start; walk; walk = walk->next) {
	if (walk->value)
	    switch  (walk->value->type) {
		case vt_id:
		    break;
		case vt_case:
		case vt_multi:
		    for (scan = walk->value->tags; scan; scan = scan->next) {
			if (scan->block && scan->block->has_required)
			    to_c("    { %d, required_%d }, /* %d: %s */ \n",
			      group,scan->group,scan->group,scan->block->id);
			else to_c("    { %d, NULL },\n",group);
			groups(scan->block,scan->group);
		    }
		    break;
		case vt_length:
		    groups(walk->value->block,group);
		    break;
		default:
		    abort();
	    }
    }
}


static void values(ITEM *start)
{
    ITEM *walk;
    TAG *scan;

    for (walk = start; walk; walk = walk->next)
	if (walk->value)
	    switch (walk->value->type) {
		case vt_id:
		    break;
		case vt_case:
		    if (*walk->id != '_') {
			to_c("static int values_%d[] = {\n",walk->item);
			for (scan = walk->value->tags; scan; scan = scan->next)
			    to_c("    %s, %d,\n",scan->value,scan->group);
			to_c("    -1, -1\n};\n\n");
		    }
		    /* fall through */
		case vt_multi:
		    for (scan = walk->value->tags; scan; scan = scan->next)
			values(scan->block);
		    break;
		case vt_length:
		    values(walk->value->block);
		    break;
		default:
		    abort();
	    }
}


static void items(ITEM *start,int group)
{
    ITEM *walk;
    TAG *scan;

    for (walk = start; walk; walk = walk->next) {
	if (*walk->id != '_')
	    if (walk->value && walk->value->type == vt_case)
		to_c("    { %d, %d, %d, values_%d, %d }, /* %s */\n",group,
		  walk->pos,walk->size,walk->item,walk->var_len,walk->id);
	    else to_c("    { %d, %d, %d, NULL, %d }, /* %s */\n",group,
		  walk->pos,walk->size,walk->var_len,walk->id);
	if (walk->value)
	    switch  (walk->value->type) {
		case vt_id:
		    break;
		case vt_case:
		case vt_multi:
		    for (scan = walk->value->tags; scan; scan = scan->next)
			items(scan->block,scan->group);
		    break;
		case vt_length:
		    items(walk->value->block,group);
		    break;
		default:
		    abort();
	    }
    }
}


void second(ITEM *def)
{
    def->has_required = 0;
    to_c("\n/*\n");
    to_c(" * If a groups contains required fields, these are listed in the\n");
    to_c(" * following arrays. Each list ends with -1. The variable names\n");
    to_c(" * contain the group number.\n */\n\n");
    dump_required(def,def,0);
    find_required(def);
    to_c("\n/*\n * Various information about groups.\n */\n\n");
    to_c("typedef struct {\n    int parent;\n    int *required;\n} GROUP;\n\n");
    to_c("static GROUP groups[] = {\n");
    if (def->has_required) to_c("    { -1, required_0 },\n");
    else to_c("    { -1, NULL },\n");
    groups(def,0);
    to_c("};\n\n\n");
    to_c("/*\n * Named case selectors only have a limited set of valid\n");
    to_c(" * values. They are listed in the following arrays.\n */\n\n");
    values(def);
    to_c("\n/*\n * Various information about fields.\n */\n\n");
    to_c("typedef struct {\n    int parent;\n    int pos,size;\n");
    to_c("    int *values;\n    int actual;\n} ITEM;\n\n");
    to_c("static ITEM items[] = {\n");
    items(def,0);
    to_c("};\n\n");
}
