/* third.c - Phase III, code generation */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>

#include "common.h"
#include "qgen.h"
#include "file.h"


int constr_size,parser_size;


static void construct(ITEM *start)
{
    ITEM *walk;
    TAG *scan;
    int patch_here;

    for (walk = start; walk; walk = walk->next) {
	if (!walk->value)
	    if (walk->var_len == -1)
		code("%s%d%d%d/* %s */\n","OP_COPY",walk->jump,walk->pos,
		  walk->size,walk->id);
	    else code("%s%d%d%d/* %s */\n","OP_COPYVAR",walk->var_len,
		  walk->pos,walk->size/8,walk->id);
	else switch (walk->value->type) {
		case vt_id:
		    code("%s%d%d%d/* %s */\n","OP_COPY",walk->jump,walk->pos,
		      walk->size,walk->id);
		    break;
		case vt_case:
		    for (scan = walk->value->tags; scan; scan = scan->next) {
			if (debug)
			    printf("C %s/%s(%d): %d\n",walk->id,scan->value,
			      scan->group,scan->deflt);
			if (!scan->deflt) {
			    code("%s%d%s\n","OP_IFGROUP",scan->group,"?");
			    patch_here = pc-1;
			}
			code("%s%d%d%d/* %s */\n","OP_COPY",walk->jump,
			  scan->pos,walk->size,scan->value);
			construct(scan->block);
			if (scan->next) {
			    code("%s%s\n","OP_JUMP","?");
			    scan->patch = pc-1;
			}
			if (!scan->deflt) patch(patch_here,pc-patch_here-1);
		    }
		    for (scan = walk->value->tags; scan && scan->next;
		      scan = scan->next)
			patch(scan->patch,pc-scan->patch-1);
		    break;
		case vt_multi:
		    for (scan = walk->value->tags; scan; scan = scan->next) {
			if (debug)
			    printf("M %s/%s(%d)\n",walk->id,scan->value,
			      scan->group);
			code("%s%d%s\n","OP_IFGROUP",scan->group,"?");
			scan->patch = pc-1;
			code("%s%d%d%d/* %s */\n","OP_COPY",walk->jump,
			  scan->pos,walk->size,scan->value);
			construct(scan->block);
			patch(scan->patch,pc-scan->patch-1);
		    }
		    break;
		case vt_length:
		    code("%s%d%d%d/* %s */\n","OP_BEGIN_LEN",walk->jump,
                      walk->pos,walk->size,walk->id);
		    construct(walk->value->block);
		    code("%s\n","OP_END_LEN");
		    break;
		default:
		    abort();
	    }
    }
}


static void parser(ITEM *start)
{
    ITEM *walk;
    TAG *scan;
    int count;

    for (walk = start; walk; walk = walk->next) {
	if (!walk->value) {
	    if (walk->var_len != -1)
		code("%s%d%d%d/* %s */\n","OP_COPYVAR",walk->var_len,walk->pos,
		  walk->size/8,walk->id);
	    else if (*walk->id != '_' || walk->jump)
		    code("%s%d%d%d/* %s */\n","OP_COPY",walk->jump,walk->pos,
		      walk->size,walk->id);
	}
	else switch (walk->value->type) {
		case vt_id:
		    if (*walk->id != '_' || walk->jump)
			code("%s%d%d%d/* %s */\n","OP_COPY",walk->jump,
			  walk->pos,walk->size,walk->id);
		    break;
		case vt_multi:
		    code("%s%s/* %s */\n","OP_MULTI","?",walk->id);
		    walk->patch = pc-1;
		    /* fall through */
		case vt_case:
		    count = 0;
		    for (scan = walk->value->tags; scan; scan = scan->next)
			count++;
		    code("%s%d%d%d%d/* %s */\n","OP_CASE",walk->jump,
		      walk->pos,walk->size,count,walk->id);
		    for (scan = walk->value->tags; scan; scan = scan->next) {
			code("%s%d%s\n",scan->value,scan->group,"?");
			scan->patch = pc-1;
		    }
		    for (scan = walk->value->tags; scan; scan = scan->next) {
			patch(scan->patch,pc-scan->patch-1);
			parser(scan->block);
			if (scan->next) {
			    code("%s%s\n","OP_JUMP","?");
			    scan->patch = pc-1;
			}
		    }
		    for (scan = walk->value->tags; scan && scan->next;
		      scan = scan->next)
			patch(scan->patch,pc-scan->patch-1);
		    if (walk->value->type == vt_multi) {
			code("%s%d\n","OP_JUMP",walk->patch-pc-3);
			patch(walk->patch,pc-walk->patch-1);
		    }
		    break;
		case vt_length:
		    code("%s%d%d%d/* %s */\n","OP_BEGIN_LEN",walk->jump,
                      walk->pos,walk->size,walk->id);
		    parser(walk->value->block);
		    code("%s\n","OP_END_LEN");
		    break;
		default:
		    abort();
	    }
    }
}


void third(ITEM *def)
{
    to_c("\n/*\n");
    to_c(" * \"Microcode\" used to construct messages. It copies all\n");
    to_c(" * fields from the construction area to the resulting message.\n");
    to_c(" */\n\n");
    to_c("static int construct[] = {\n");
    begin_code();
    construct(def);
    constr_size = end_code()+1;
    to_c("    OP_END\n};\n\n");
    to_c("\n/*\n * \"Microcode\" used to parse messages. It detects the\n");
    to_c(" * presence of fields and copies them from the message to the\n");
    to_c(" * construction area.\n */\n\n");
    to_c("static int parse[] = {\n");
    begin_code();
    parser(def);
    parser_size = end_code()+1;
    to_c("    OP_END\n};\n\n");
}
