/* atmsigd.c - ATM signaling demon */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "qlib.h"

#include "diag.h"
#include "common.h"
#include "io.h"
#include "proto.h"
#include "saal.h"


#define COMPONENT "SIGD"
#define CONFIG_FILE "./atmsigd.conf"


extern int yyparse(void);
extern FILE *yyin;

int net = 0;
int dump = 0;

static SAAL_DSC saal;


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -d ] [ -n ] [ interface ]\n",name);
    exit(1);
}


static void q_rel_ind(SAAL_DSC *dsc,void *user_data,void *uu_data,
  int uu_length)
{
    saal_estab_req(dsc,NULL,0);
}


void from_net(void *buffer,int size)
{
    saal_pdu(&saal,buffer,size);
}


void to_signaling(void *msg,int size)
{
    saal_send(&saal,msg,size);
}


static void q_data_ind(SAAL_DSC *dsc,void *user_data,void *data,int length)
{
    to_q2931(data,length);
}


static void q_cpcs_send(SAAL_DSC *dsc,void *user_data,void *data,int length)
{
    to_net(data,length);
}


static SAAL_USER_OPS ops = {
    NULL, /* no q_estab_ind - should be handled, see 5.5.6.9 */
    NULL, /* no q_estab_conf */
    q_rel_ind,
    NULL, /* no q_rel_conf - what to do ? */
    NULL, /* no q_restart - should be handled, see 5.5.6.9 and 5.5.6.10 */
    q_data_ind,
    NULL, /* no q_unitdata */
    q_cpcs_send
};


#include <linux/atm.h>
int main(int argc,char **argv)
{
    int itf,c;

    itf = 0;
    while ((c = getopt(argc,argv,"dn")) != EOF)
	switch (c) {
	    case 'd':
		set_verbosity(NULL,DIAG_DEBUG);
		dump = 1;
		q_dump = 1;
		break;
	    case 'n':
		net = 1;
		break;
	    default:
		usage(argv[0]);
	}
    if (optind == argc-1) itf = atoi(argv[optind++]);
    if (optind != argc) usage(argv[0]);
    diag(COMPONENT,DIAG_INFO,"Linux ATM signaling UNI 3.0(red)/AAL5, version "
      VERSION);
    if (!(yyin = fopen(CONFIG_FILE,"r")))
	diag(COMPONENT,DIAG_WARN,CONFIG_FILE " not found. - Using defaults.");
    else if (yyparse()) {
	    diag(COMPONENT,DIAG_FATAL,"Error in config file. - Aborting.");
	    return 1;
	}
    diag(COMPONENT,DIAG_INFO,"Acting as %s side",net ? "NETWORK" : "USER");
    if (open_all(itf)) return 1;
    q_start();
    start_saal(&saal,&ops,NULL);
    saal_estab_req(&saal,NULL,0);
    poll_loop();
    close_all();
    stop_saal(&saal);
    return 0;
}
