/* common.h - Common definitions */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#ifndef COMMON_H
#define COMMON_H

#include <sys/types.h>
#include <sys/time.h>


/* doubly linked list primitives */
 
#define Q_INSERT_HEAD(r,i) ({ (i)->next = r; (i)->prev = NULL; \
  if (r) (r)->prev = i; r = i; })
#define Q_INSERT_AFTER(r,i,a) ({ if (a) { (i)->next = (a)->next; \
  (i)->prev = a; if ((a)->next) (a)->next->prev = i; (a)->next = i; } \
  else { (i)->next = r; (i)->prev = NULL; if (r) (r)->prev = i; r = i; } })
#define Q_INSERT_BEFORE(r,i,b) ({ if (b) { (i)->next = b; \
  (i)->prev = (b)->prev; if ((b)->prev) (b)->prev->next = i; else r = i; \
  (b)->prev = i; } else { (i)->next = r; (i)->prev = NULL; \
  if (r) (r)->prev = i; r = i; } })
#define Q_REMOVE(r,i) ({ if ((i)->next) (i)->next->prev = (i)->prev; \
  if ((i)->prev) (i)->prev->next = (i)->next; else r = (i)->next; })

extern struct timeval now;
extern int net,dump;


#define alloc_t(t) ((t *) alloc(sizeof(t)))


void *alloc(size_t size);

#endif
