#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "diag.h"


typedef struct _component {
    const char *name;
    int verbosity;
    struct _component *next;
} COMPONENT;


static COMPONENT *components = NULL;
static int default_verbosity = DIAG_INFO;


void set_verbosity(const char *component,int level)
{
    COMPONENT *walk;

    if (!component) {
	default_verbosity = level;
	return;
    }
    for (walk = components; walk; walk = walk->next)
	if (!strcmp(walk->name,component)) break;
    if (!walk) {
	walk = alloc_t(COMPONENT);
	walk->name = component;
	walk->next = components;
	components = walk;
    }
    walk->verbosity = level;
}


void vdiag(const char *component,int severity,const char *fmt,va_list ap)
{
    COMPONENT *walk;

    for (walk = components; walk; walk = walk->next)
	if (!strcmp(walk->name,component)) break;
    if (severity > (walk ? walk->verbosity : default_verbosity)) return;
    fflush(stdout);
    fprintf(stderr,"%s: ",component);
    vfprintf(stderr,fmt,ap);
    fputc('\n',stderr);
    if (severity == DIAG_FATAL) exit(1);
}


void diag(const char *component,int severity,const char *fmt,...)
{
    va_list ap;

    va_start(ap,fmt);
    vdiag(component,severity,fmt,ap);
    va_end(ap);
}
