/* q2931.c - Processing of incoming Q.2931 messages */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

/*
 * TODO:
 * - concentrate sending of status
 */


#include <stdio.h>
#include <assert.h>

#include "q2931.h"
#include "qlib.h"

#include "diag.h"
#include "common.h"
#include "proto.h"
#include "io.h"
#include "timer.h"
#include "timeout.h"

#define __KERNEL__ /* since that's what we effectively are */
#include <linux/errno.h>


#define COMPONENT "Q2931"


static Q_DSC in_dsc;
int vci = 42; /* assigning VCIs from here on if acting as network */


static void send_call_proceeding(SOCKET *sock)
{
    Q_DSC dsc;
    int size;

    q_create(&dsc,q_buffer,MAX_Q_MSG);
    q_assign(&dsc,QF_msg_type,QMSG_CALL_PROC);
    q_assign(&dsc,QF_call_ref,sock->call_ref);
    if (net) {
	q_assign(&dsc,QF_vpi,0);
	q_assign(&dsc,QF_vci,vci); /* @@@ */
	sock->pvc.sap_addr.vpi = 0;
	sock->pvc.sap_addr.vci = vci++;
    }
    size = q_close(&dsc);
    to_signaling(q_buffer,size);
}


static void send_release_complete(unsigned long call_ref,unsigned char cause)
{
    Q_DSC dsc;
    int size;

    q_create(&dsc,q_buffer,MAX_Q_MSG);
    q_assign(&dsc,QF_msg_type,QMSG_REL_COMP);
    q_assign(&dsc,QF_call_ref,call_ref);
    /* set cause */
    size = q_close(&dsc);
    to_signaling(q_buffer,size);
}


static void setup_call(unsigned long call_ref)
{
    SOCKET *sock,*this,**walk;
    unsigned char buf[ATM_ESA_LEN];
    int len,i;

    for (sock = sockets; sock; sock = sock->next)
	if (sock->state == ss_listening) break;
    /* LISTENING */
    if (!sock) {
	send_release_complete(call_ref,0); /* @@@ dunno */
	return;
    }
    this = new_sock(0);
    this->state = ss_indicated;
    this->q2931_state = qs_in_proc;
    this->call_ref = call_ref;
    send_call_proceeding(this);
    /* this->local = alloc_sap(sock->local); @@@ - not yet */
    printf("AAL type %ld\n",q_fetch(&in_dsc,QF_aal_type));
    len = q_read(&in_dsc,QF_cdpn_nsap,(void *) &buf,sizeof(buf));
    printf("Addr len %d:",len);
    for (i = 0; i < (len < 30 ? len : 30); i++) printf(" %02X",buf[i]);
    putchar('\n');
    if (q_present(&in_dsc,QF_vci)) {
	this->pvc.sap_addr.vpi = q_fetch(&in_dsc,QF_vpi);
	this->pvc.sap_addr.vci = q_fetch(&in_dsc,QF_vci);
printf("VPI/VCI: %d/%d\n",this->pvc.sap_addr.vpi,this->pvc.sap_addr.vci);
    }
    if (q_present(&in_dsc,QF_cgpn)) {
	this->remote = alloc_t(struct sockaddr_atmsvc);
	this->remote->sas_addr.blli = NULL;
	i = q_read(&in_dsc,QF_cgpn,(void *) this->remote->sas_addr.prv,
	  ATM_ESA_LEN);
	printf("addr_len = %d\n",i);
    }
    /* extract remote address */
    send_kernel(0,sock->id,as_indicate,0,this);
    for (walk = &sock->listen; *walk; walk = &(*walk)->listen);
    *walk = this;
    diag(COMPONENT,DIAG_DEBUG,"SE vpi.vci=%d.%d",this->pvc.sap_addr.vpi,
      this->pvc.sap_addr.vci);
}


static void send_status(SOCKET *sock)
{
    Q_DSC dsc;
    int size;

    q_create(&dsc,q_buffer,MAX_Q_MSG);
    q_assign(&dsc,QF_msg_type,QMSG_STATUS);
    q_assign(&dsc,QF_call_ref,sock->call_ref);
    q_assign(&dsc,QF_call_state,(int) sock->q2931_state);
    size = q_close(&dsc);
    to_signaling(q_buffer,size);
}


static void send_connect_ack(SOCKET *sock)
{
    Q_DSC dsc;
    int size;

    q_create(&dsc,q_buffer,MAX_Q_MSG);
    q_assign(&dsc,QF_msg_type,QMSG_CONN_ACK);
    q_assign(&dsc,QF_call_ref,sock->call_ref);
    size = q_close(&dsc);
    to_signaling(q_buffer,size);
}


static void q2931_call(SOCKET *sock,unsigned char mid)
{
    int error;

    switch (mid) {
	case QMSG_STATUS:
	    /* uh */
	    return;
	case QMSG_STATUS_ENQ:
	    send_status(sock);
	    return;
	default:
	    ;
    }
    switch (mid) {
	case QMSG_CALL_PROC: /* CONNECTING, WAIT_REL, REL_REQ */
	    if (sock->state == ss_wait_rel || sock->state == ss_rel_req) {
		send_status(sock);
		return;
	    }
	    if (sock->state != ss_connecting) break;
	    /* check for 2nd CALL_PROC @@@ */
	    STOP_TIMER(sock);
	    if (q_present(&in_dsc,QG_conn_id) >= 0) {
		sock->pvc.sap_addr.vpi = q_fetch(&in_dsc,QF_vpi);
		sock->pvc.sap_addr.vci = q_fetch(&in_dsc,QF_vci);
printf("VPI/VCI: %d/%d\n",sock->pvc.sap_addr.vpi,sock->pvc.sap_addr.vci);
	    }
	    START_TIMER(sock,T310);
	    sock->q2931_state = qs_out_proc;
	    return;
	case QMSG_CONNECT: /* CONNECTING, REL_REQ */
	    if (sock->state == ss_rel_req) {
		send_status(sock);
		return;
	    }
	    if (sock->state != ss_connecting) break;
	    STOP_TIMER(sock);
	    if (q_present(&in_dsc,QG_conn_id) >= 0) {
		sock->pvc.sap_addr.vpi = q_fetch(&in_dsc,QF_vpi);
		sock->pvc.sap_addr.vci = q_fetch(&in_dsc,QF_vci);
printf("VPI/VCI: %d/%d\n",sock->pvc.sap_addr.vpi,sock->pvc.sap_addr.vci);
	    }
	    error = 0;
	    if (!sock->pvc.sap_addr.vpi && !sock->pvc.sap_addr.vci)
		error = -EPROTO;
	    /* more problems */
	    if (error) {
		set_error(sock,error);
		send_release(sock,0); /* @@@ */
		START_TIMER(sock,T308_1);
		new_state(sock,ss_rel_req);
		return;
	    }
	    send_connect_ack(sock);
	    /* @@@ fill in sock->remote */
	    /* @@@ fill in traffic parameters */
	    send_kernel(sock->id,0,as_okay,0,sock);
	    new_state(sock,ss_connected);
	    diag(COMPONENT,DIAG_INFO,"Active open succeeded (CR 0x%06X)",
	      sock->call_ref);
	    return;
	case QMSG_CONN_ACK: /* ACCEPTING, WAIT_REL, REL_REQ */
	    diag(COMPONENT,DIAG_DEBUG,"CA vpi.vci=%d.%d",
	      sock->pvc.sap_addr.vpi,sock->pvc.sap_addr.vci);
	    if (sock->state == ss_wait_rel || sock->state == ss_rel_req) {
		send_status(sock);
		return;
	    }
	    if (sock->state != ss_accepting) break;
	    STOP_TIMER(sock);
	    send_kernel(sock->id,0,as_okay,0,sock);
		/* repeat remote information - just for fun */
	    new_state(sock,ss_connected);
	    diag(COMPONENT,DIAG_INFO,"Passive open succeeded (CR 0x%06X)",
	      sock->call_ref);
	    return;
	case QMSG_RELEASE: /* all states */
	    switch (sock->state) {
		case ss_connecting:
		    set_error(sock,-ECONNREFUSED);
		    /* fall through */
		case ss_accepting:
		    set_error(sock,-ECONNRESET); /* ERESTARTSYS ? */
		    send_release_complete(sock->call_ref,0); /* @@@ */
		    /* fall through */
		case ss_rel_req:
		    send_close(sock);
		    /* fall through */
		case ss_wait_rel:
		    STOP_TIMER(sock);
		    free_sock(sock);
		    return;
		case ss_connected:
		    diag(COMPONENT,DIAG_INFO,"Passive close (CR 0x%06X)",
		      sock->call_ref);
		    send_close(sock);
		    /* fall through */
		case ss_hold:
		    new_state(sock,ss_rel_ind);
		    return;
		case ss_indicated:
		    new_state(sock,ss_zombie);
		    /* fall through */
		case ss_rel_ind:
		    /* send_release_complete(sock->call_ref,0); / * @@@ */
		    return;
		default:
		    send_release_complete(sock->call_ref,0); /* @@@ */
		    break;
	    }
	    break;
	case QMSG_REL_COMP: /* basically any state (except LISTENING,
				  ZOMBIE, REL_IND) */
	    switch (sock->state) {
		case ss_connecting:
		    set_error(sock,-ECONNREFUSED);
		    /* fall through */
		case ss_accepting:
		    set_error(sock,-ECONNRESET); /* ERESTARTSYS ? */
		    /* fall through */
		case ss_rel_req:
		    send_close(sock);
		    /* fall through */
		case ss_wait_rel:
		    STOP_TIMER(sock);
		    free_sock(sock);
		    return;
		case ss_connected:
		    diag(COMPONENT,DIAG_INFO,"Passive clsoe (CR 0x%06X)",
		      sock->call_ref);
		    send_close(sock);
		    /* fall through */
		case ss_hold:
		    new_state(sock,ss_wait_close);
		    return;
		case ss_indicated:
		    new_state(sock,ss_zombie);
		    return;
		default:
		    break;
	    }
	default:
	    diag(COMPONENT,DIAG_WARN,"Bad Q.2931 message %d",mid);
	    return;
    }
    diag(COMPONENT,DIAG_WARN,
      "Q.2931 message %s is incompatible with state %s/%s (%d?%d)",
      mid2name(mid),state_name[sock->state],qs_name[sock->q2931_state],
      (int) sock->state,(int) sock->q2931_state);
    send_status(sock);
}



void to_q2931(void *msg,int size)
{
    SOCKET *curr;
    unsigned long call_ref;
    unsigned char mid;

    q_open(&in_dsc,msg,size);
    call_ref = q_fetch(&in_dsc,QF_call_ref)^0x800000;
    if (!(call_ref & 0x7fffff)) {
	return; /* bad things happen ... @@@ */
    }
    for (curr = sockets; curr; curr = curr->next)
	if (curr->call_ref == call_ref) break;
    mid = q_fetch(&in_dsc,QF_msg_type);
    diag(COMPONENT,DIAG_DEBUG,"FROM NET: %s (0x%02X) CR 0x%06lx for 0x%lx",
      mid2name(((unsigned char *) msg)[5]),((unsigned char *)msg)[5],call_ref,
      curr ? curr->id : 0);
    if (mid == QMSG_SETUP) {
	if (!curr) setup_call(call_ref);
	return;
    }
    if (!curr || curr->q2931_state == qs_null) {
	if (mid != QMSG_REL_COMP && mid != QMSG_STATUS)
	    send_release_complete(call_ref,81);
		/* #81, "invalid call ref value" */
	return;
    }
    q2931_call(curr,mid);
    q_close(&in_dsc);
}
