/* aqpvc.c - Sets up a PVC and awaits Arequipa traffic on it */
 
/* Hacked 1997,1998 by Werner Almesberger, EPFL-LRC/ICA */
 
/*
 * Features:
 * - if there's no traffic on that PVC, no INET socket will ever pick it up
 * - if no socket picks it up, it won't go away by itself
 * - you guessed right; there's no other way to get rid of it (short of
 *   rebooting)
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <atm.h>
#include <linux/atmclip.h>
#include <linux/arequipa.h>


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [itf.]vpi.vci [qos]\n",name);
    exit(1);
}


int main(int argc,const char **argv)
{
    struct sockaddr_atmpvc addr;
    struct atm_qos qos;
    int s;

    if (argc != 2 && argc != 3) usage(*argv);
    if (text2atm(argv[1],(struct sockaddr *) &addr,sizeof(addr),T2A_PVC |
      T2A_NAME) < 0) usage(*argv);
    if (argc == 2) {
	memset(&qos,0,sizeof(qos));
	qos.aal = ATM_AAL5;
	qos.txtp.traffic_class = qos.rxtp.traffic_class = ATM_UBR;
	qos.txtp.max_sdu = qos.rxtp.max_sdu = RFC1626_MTU+RFC1483LLC_LEN;
    }
    else {
	if (text2qos(argv[2],&qos,0) < 0) usage(*argv);
    }
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,0)) < 0) {
	perror("socket");
	return 1;
    }
    if (setsockopt(s,SOL_ATM,SO_ATMQOS,&qos,sizeof(qos)) < 0) {
	perror("setsockopt SO_ATMQOS");
	return 1;
    }
    if (bind(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    if (ioctl(s,AREQUIPA_INCOMING,0) < 0) {
	perror("ioctl AREQUIPA_INCOMING");
	return 1;
    }
    return 0;
}
