#include <stdio.h>
#include <string.h> 
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdint.h>
#include <atm.h>
#include <linux/atmdev.h>
#include <sys/ioctl.h>  
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h> 
#include <net/if.h>
#include <arpa/inet.h>
#include <errno.h>
#include "get_vars.h" 
#include "io.h"

extern struct sockaddr_atmsvc data_listen_addr; /* From main.c */

/* Returns the Time To Live value. */
int get_ttl(){
  int optvalue = 1;
  unsigned optlength = sizeof(optvalue);
  int sockfd = socket( AF_INET, SOCK_STREAM, IPPROTO_IP );
  getsockopt( sockfd, IPPROTO_IP, IP_TTL, &optvalue, &optlength );
  close(sockfd);
  return optvalue;
}

/* 
 * Returns clients own IP-address. According to interface number.
 *
 */ 
uint32_t get_own_ip_addr(int iface_nmbr ){
  struct ifreq req;
  int fd;
  char * addr;
  uint32_t address;
  char name[6];
  sprintf(name, "lec%d", iface_nmbr );
  memcpy(req.ifr_ifrn.ifrn_name,name,sizeof(name));
  fd =  socket( AF_INET, SOCK_STREAM, IPPROTO_IP );
  if(fd < 0){
    printf("mpcd: get_vars.c: socket creation failed.\n");
    exit(1);
  }
  if(ioctl(fd,SIOCGIFADDR,&req)<0){
    printf("mpcd: get_vars.c: ioctl failed: %s\n", strerror(errno));
    exit(1);
  }
  addr = req.ifr_ifru.ifru_addr.sa_data;
  address = ((unsigned char)addr[2] << 24) |
            ((unsigned char)addr[3] << 16) |
            ((unsigned char)addr[4] << 8 ) |
             (unsigned char)addr[5] ;
  close(fd);
  return address;
} 


/*
 * Sets our ATM address to be used in control packets.
 * This get's called if the address is not given as a parameter 
 * while starting MPC daemon.
 *
 */
int set_own_atm_addr(unsigned char address[20]){
  struct sockaddr_atmsvc sa;
  struct atmif_sioc req;
  int fd = get_socket(NULL);
  int selector;
  req.number=0;
  req.arg=&sa;
  req.length=sizeof(struct sockaddr_atmsvc);
  if ( ioctl(fd, ATM_GETADDR, &req) <0 ){
    printf("mpcd: get_vars.c: ioctl error \n");
    return 0;
  }
  address[0] = sa.sas_addr.prv[0];
  address[1] = sa.sas_addr.prv[1];
  address[2] = sa.sas_addr.prv[2];
  address[3] = sa.sas_addr.prv[3];
  address[4] = sa.sas_addr.prv[4];
  address[5] = sa.sas_addr.prv[5];
  address[6] = sa.sas_addr.prv[6];
  address[7] = sa.sas_addr.prv[7];
  address[8] = sa.sas_addr.prv[8];
  address[9] = sa.sas_addr.prv[9];
  address[10] = sa.sas_addr.prv[10];
  address[11] = sa.sas_addr.prv[11];
  address[12] = sa.sas_addr.prv[12];
  address[13] = sa.sas_addr.prv[13];
  address[14] = sa.sas_addr.prv[14];
  address[15] = sa.sas_addr.prv[15];
  address[16] = sa.sas_addr.prv[16];
  address[17] = sa.sas_addr.prv[17];
  address[18] = sa.sas_addr.prv[18];
  address[19] = sa.sas_addr.prv[19];
  address[20] = sa.sas_addr.prv[20];
  /* Loop until a free selector byte is found. */
  selector = atoi(&sa.sas_addr.prv[20]);
  while(bind(fd, (struct sockaddr *)&sa, sizeof(struct sockaddr_atmsvc))<0){
    printf("mpcd: get_vars.c: %s\n",strerror(errno));
    selector++;
    if(selector>254){
      printf("mpcd: get_vars.c: could not set own atm address.\n");
      exit(1);
    }
    sprintf(&address[20],"%d",selector);
    sprintf(&sa.sas_addr.prv[20],"%d",selector);
  }
  printf("mpcd: get_vars.c: selector set to %d \n",selector);
  close(fd);
  return 1;
}

int get_own_atm_addr(unsigned char  * address){
  memcpy(address,data_listen_addr.sas_addr.prv,ATM_ESA_LEN);
  return 1;
}







