/* tcpswc.h - ATMTCP switch control interface */

/* Written 1998 by Werner Almesberger, EPFL ICA */


#ifndef TCPSWC_H
#define TCPSWC_H

#include <atm.h>


typedef enum {
    tmt_invalid,	/* catch uninitialized variables */
    tmt_get,		/* get/return n-th entry */
    tmt_add,		/* add one-way VC */
    tmt_del		/* remove one-way VC */
} TCPSWC_MSG_TYPE;

typedef struct tcpswc_msg {
    TCPSWC_MSG_TYPE type;		/* message type */
    int n;				/* index (for tmt_get) and error code
					   (for tmt_get, tmt_set, tmt_del) */
    struct sockaddr_atmpvc in;
    struct sockaddr_atmpvc out;
    struct atm_qos qos;			/* currently unused */
} TCPSWC_MSG;

#endif
