#include <stdio.h>
#include <stdlib.h>
#include <sys/utsname.h>
#include <getopt.h>
#include <time.h>
#include <sys/ioctl.h>
#include <atm.h>
#include <linux/atmmpc.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <atm.h>
#include <linux/if_ether.h>
#include <signal.h>
#include "packets.h"
#include "io.h"
#include "k_interf.h"
#include "get_vars.h"

/*
 * Global variables.
 */
int kernel_socket;           /* socket for mpoad <--> kernel messages    */
int MPS_socket;              /* MPS control socket for outgoing msgs     */
int MPS_listen_socket;       /* listen socket for incoming control calls */
unsigned char MPS_CTRL_ATM_ADDR[ATM_ESA_LEN];
unsigned char MPS_MAC_ADDRESS[13];
int mps_ctrl_addr_set = 0;
int mps_mac_addr_set = 0;
unsigned char OWN_ATM_ADDRESS[ATM_ESA_LEN]; /* Our control ATM address   */
struct sockaddr_atmsvc data_listen_addr;
int INTERFACE_NUMBER;        /* Interface number, x for lecx */

static void create_kernel_socket(int itf);
static int create_listen_socket(struct sockaddr_atmsvc addr);
static int listen_to_MPS( struct sockaddr_atmsvc ctrl_listen_addr );
static int set_mps_mac_addr(void);
static void usage(const char *progname);

static void signal_handler(int sgnl){
  struct k_message msg;
  memset(&msg,0,sizeof(struct k_message));
  msg.type = CLEAN_UP_AND_EXIT;
  send_to_kernel(&msg);
  printf("mpcd: main.c: signal_handler()\n");
  return;
}


int main(int argc, char **argv){
  int listen_socket;
  int opt_ret = 0;
  struct k_message msg;
  struct sockaddr_atmsvc control_listen_addr;
  struct sockaddr_atmsvc mps_ctrl_addr;
  memset(&control_listen_addr,0,sizeof(struct sockaddr_atmsvc));
  memset(&data_listen_addr,0,sizeof(struct sockaddr_atmsvc));
  memset(&mps_ctrl_addr,0,sizeof(struct sockaddr_atmsvc));
  memset(&msg,0,sizeof(struct k_message));
  while( opt_ret != -1 ){
    opt_ret = getopt(argc, argv, "h:s:l:c:i:m:");
    switch(opt_ret) {
    case 'h':
      usage(argv[0]);
      exit(0);
      break;
    case 's':
      if(text2atm(optarg,(struct sockaddr *)&control_listen_addr,
		  sizeof(struct sockaddr_atmsvc),T2A_SVC | T2A_NAME)<0){
	printf("mpcd: main.c: text2atm failed.\n");
	usage(argv[0]);
        exit(1);
      }
      memcpy(OWN_ATM_ADDRESS,control_listen_addr.sas_addr.prv, ATM_ESA_LEN);
      break;
    case 'l':
      if(text2atm(optarg,(struct sockaddr *)&data_listen_addr,
		  sizeof(struct sockaddr_atmsvc),T2A_SVC | T2A_NAME)<0){
	printf("mpcd: main.c: text2atm failed.\n");
	usage(argv[0]);
	exit(1);
      }
      break;
    case 'c':
      if(text2atm(optarg,(struct sockaddr *)&mps_ctrl_addr,
		  sizeof(struct sockaddr_atmsvc),T2A_SVC | T2A_NAME)<0){
	printf("mpcd: main.c: text2atm failed.\n");
	usage(argv[0]);
	exit(1);
      }
      memcpy(MPS_CTRL_ATM_ADDR,mps_ctrl_addr.sas_addr.prv,ATM_ESA_LEN);
      mps_ctrl_addr_set = 1;
      break;
    case 'm':
      strncpy(MPS_MAC_ADDRESS,optarg,13);
      mps_mac_addr_set = 1;
      break;
    case 'i':
      INTERFACE_NUMBER = atoi(optarg);
      break;
    }
  }
  if (argc != optind) {
    usage(argv[0]);
    exit(1);
  }
  create_kernel_socket(INTERFACE_NUMBER);
  msg.type = SET_MPC_CTRL_ADDR; 
  memcpy(msg.MPS_ctrl,OWN_ATM_ADDRESS,ATM_ESA_LEN);
  if (send_to_kernel(&msg) < 0) {
       printf("mpcd: main.c: send_to_kernel(SET_MPC_CTRL_ADDR) failed\n");
       exit(1);
  }
  if(mps_mac_addr_set)
    set_mps_mac_addr();
  listen_to_MPS( control_listen_addr );
  if ( (listen_socket = create_listen_socket(data_listen_addr)) < 0) {
    printf("mpcd: main.c: listen_socket creation failed\n");
    exit (1);
  }

  signal(SIGHUP, signal_handler);
  signal(SIGINT, signal_handler);
  signal(SIGQUIT, signal_handler);
  signal(SIGABRT, signal_handler);
  signal(SIGTERM, signal_handler);
  signal(SIGSEGV, signal_handler);

  main_loop(listen_socket);
  return 0;
}

static void create_kernel_socket(int itf)
{
        kernel_socket = socket(PF_ATMSVC, SOCK_DGRAM, 0);
        if (kernel_socket < 0) {
                printf("mpcd: main.c: kernel socket creation failed: %s\n", strerror(errno));
                exit (1);
        }
        if ( ioctl(kernel_socket, ATMMPC_CTRL, itf) < 0) {
                printf("mpcd: main.c: kernel socket ioctl(ATMMPC_CTRL) failed: %s\n", strerror(errno));
                exit (1);
        }
	return;
}

/*
 * Listen socket for incoming shortcuts
 *
 * return < 0 for error, socket for ok
 *
 */
static int create_listen_socket(struct sockaddr_atmsvc addr)
{
        int s;
        
        s = get_socket(&addr);
        if (s < 0)
                return -1;
        
        if (listen(s, 5) < 0) {
                printf("mpcd: main.c: listen failed: %s\n",strerror(errno));
                close(s);
                return -1;
        }
        
        return s;
}

static int listen_to_MPS( struct sockaddr_atmsvc ctrl_listen_addr ){
        /* soketti, joka kuuntelee MPC:n Control ATM-osoitteessa */
        MPS_listen_socket = create_listen_socket(ctrl_listen_addr); 
        if (MPS_listen_socket < 0)
	        return -1;
	return 0;
}

static int set_mps_mac_addr(){
     char *string = MPS_MAC_ADDRESS;
     struct k_message msg;
     unsigned char mac_addr[ETH_ALEN];
     int tmp;
     int i = strlen(string);
     memset(&msg,0,sizeof(struct k_message));
     if (i != 12){
       printf("mpcd: main.c: incorrect mac address.\n");
       exit(1);
     }
     for(i=0;i<6;i++) {
             sscanf(&string[i*2],"%2x",&tmp);
	     mac_addr[i]=(unsigned char)tmp;
     }
     msg.type = SET_MPS_MAC_ADDR;
     memcpy(&msg.MPS_ctrl,&mac_addr,ETH_ALEN);
     send_to_kernel(&msg);
     return 0;
}



static void usage( const char * progname ){
        printf("Usage: %s [-s our_control_listen_ATM_Address]  [-l our_data_listen_address]\n"
               "              [-c MPS_control_ATM_Address] [-i interface_number]\n"
	       "              [-m MPS_MAC_address]\n",
               progname);
        return;
}
