/* atmaddr.c - Get/set local ATM adresses */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdio.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/atmdev.h>

#include "atm.h"


int main(int argc,char **argv)
{
    struct atmif_sioc req;
    struct sockaddr_atmsvc addr;
    char buffer[MAX_ATM_ADDR_LEN+1];
    int s;

    if ((s = socket(PF_ATMSVC,SOCK_DGRAM,0)) < 0) {
	perror("socket");
	return 1;
    }
    req.number = 0;
    req.arg = &addr;
    if (argc == 1) {
	if (ioctl(s,SIOCGIFATMADDR,&req) < 0) {
	    perror("ioctl SIOCGIFATMADDR");
	    return 1;
	}
	if (!addr.sas_family) {
	    printf("No address\n");
	    return 0;
	}
	if (atm2text(buffer,MAX_ATM_ADDR_LEN+1,(struct sockaddr *) &addr,
	  A2T_PRETTY) < 0) {
	    fprintf(stderr,"bad address (internal error)\n");
	    return 1;
	}
	printf("%s\n",buffer);
	return 0;
    }
    if (argc > 2 || text2atm(argv[1],(struct sockaddr *) &addr,sizeof(addr),
      T2A_SVC | T2A_NAME) < 0) {
	fprintf(stderr,"usage: %s [atm_address]\n",argv[0]);
	return 1;
    }
    if (ioctl(s,SIOCSIFATMADDR,&req) < 0) {
	perror("ioctl SIOCSIFATMADDR");
	return 1;
    }
    return 0;
}
