%{
/* cfg.y - configuration language */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <string.h>
#include <ctype.h>
#include <linux/atm.h>

#include "atmd.h"

#include "proto.h"


extern int signaling_vpi;
extern int signaling_vci;
extern int net;


static int hex2num(char digit)
{
    if (isdigit(digit)) return digit-'0';
    if (islower(digit)) return toupper(digit)-'A'+10;
    return digit-'A'+10;
}

%}

%union {
    int num;
    char nsap[ATM_ESA_LEN*2+1];
};


%token		TOK_LEVEL TOK_DEBUG TOK_INFO TOK_WARN TOK_ERROR TOK_FATAL
%token		TOK_SIG TOK_UNI30 TOK_UNI31 TOK_SAAL TOK_VPI TOK_VCI TOK_NSAP
%token		TOK_IO TOK_NET
%token <num>	TOK_NUMBER
%token <nsap>	TOK_ADDR

%type <num>	level opt_bits

%%

all:
    | item all
    ;

item:
    TOK_LEVEL level
	{
	    set_verbosity(NULL,$2);
	}
    | TOK_SIG sig
    | TOK_SAAL saal
    | TOK_IO io
    ;

sig:
    sig_item
    | '{' sig_items '}'
    ;

sig_items:
    | sig_item sig_items
    ;

saal:
    saal_item
    | '{' saal_items '}'
    ;

saal_items:
    | saal_item saal_items
    ;

io:
    io_item
    | '{' io_items '}'
    ;

io_items:
    | io_item io_items
    ;

sig_item:
    TOK_LEVEL level
	{
	    set_verbosity("Q2931",$2);
	    set_verbosity("KERNEL",$2);
	}
    | TOK_UNI30
	{
	    /* that's the default anyway */
	}
    | TOK_UNI31
	{
	    yyerror("Sorry, not supported yet");
	}
    | TOK_NET
	{
	    net = 1;
	}
    | TOK_NSAP nsap_list
    ;

nsap_list:
    nsap
    | nsap ',' nsap_list
    ;

nsap:
    TOK_ADDR opt_bits
	{
	    int bits;
	    unsigned char nsap[ATM_ESA_LEN];
	    int i;

	    bits = $2 ? $2 : ATM_ESA_LEN*8;
	    if (bits != ATM_ESA_LEN*8 /*&& bits != (ATM_ESA_LEN-6)*8*/)
		yyerror("invalid number of bits");
	    if (strlen($1) < (bits+3)/4) yyerror("NSAP string is too short");
	    memset(nsap,0,ATM_ESA_LEN);
	    for (i = 0; $1[i]; i++)
		nsap[i >> 1] = hex2num($1[i]) << (i & 1 ? 0 : 4);
	    /* do something with NSAP */
	}
    ;

opt_bits:
	{
	    $$ = 0;
	}
    | '/' TOK_NUMBER
	{
	    if (!$2) yyerror("number of bits must be non-zero");
	    $$ = $2;
	}
    ;

saal_item:
    TOK_LEVEL level
	{
	    set_verbosity("SSCF",$2);
	    set_verbosity("SSCOP",$2);
	}
    ;

io_item:
    TOK_LEVEL level
	{
	    set_verbosity("IO",$2);
	}
    | TOK_VPI TOK_NUMBER
	{
	    if ($2 > 0xff) yyerror("VPI is only 8 bits");
	    signaling_vpi = $2;
	}
    | TOK_VCI TOK_NUMBER
	{
	    if ($2 > 0xffff) yyerror("VCI is only 16 bits");
	    signaling_vci = $2;
	}
    ;

level:
    TOK_DEBUG
	{
	    $$ = DIAG_DEBUG;
	}
    | TOK_INFO
	{
	    $$ = DIAG_INFO;
	}
    | TOK_WARN
	{
	    $$ = DIAG_WARN;
	}
    | TOK_ERROR
	{
	    $$ = DIAG_ERROR;
	}
    | TOK_FATAL
	{
	    $$ = DIAG_FATAL;
	}
    ;
